/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.o;

import com.objectdb.o.BGV;
import com.objectdb.o.BLV;
import com.objectdb.o.InternalException;
import com.objectdb.o.NLT;
import com.objectdb.o.SMT;
import com.objectdb.o.VAL;
import com.objectdb.o.VUT;
import com.objectdb.spi.OReader;
import com.objectdb.spi.OWriter;
import java.math.BigInteger;

public final class BGT
extends SMT {
    public BGT() {
        super(-16, BigInteger.class);
        this.j = new NLT(BigInteger.class, this);
    }

    public void writeStrictly(Object object, OWriter oWriter) {
        oWriter.writeBigIntValue((BigInteger)object);
    }

    public Object readAndAdjust(OReader oReader) {
        return this.l(oReader);
    }

    public BigInteger l(OReader oReader) {
        int n2 = oReader.w();
        switch (n2) {
            case 41: {
                return BGV.ac;
            }
            case 42: {
                return BGV.af(oReader.P(1));
            }
            case 43: {
                return BGV.af(oReader.P(2));
            }
            case 44: {
                return BGV.af(oReader.P(3));
            }
            case 45: {
                return BGV.af(oReader.P(4));
            }
            case 46: {
                return BGV.af(oReader.P());
            }
        }
        if (n2 >= 129 && n2 < 192) {
            return BGT.m(oReader.N(n2 - 128), oReader);
        }
        VAL vAL = VUT.k(n2, oReader);
        if (vAL.m() || vAL == BLV.O) {
            return BigInteger.ZERO;
        }
        if (vAL == BLV.P) {
            return BigInteger.ONE;
        }
        return BGT.n(vAL, oReader);
    }

    private static BigInteger m(String string, OReader oReader) {
        try {
            return new BigInteger(string);
        }
        catch (Exception exception) {
            InternalException.g(exception);
            oReader.addFailurePoint();
            return BigInteger.ZERO;
        }
    }

    private static BigInteger n(VAL vAL, OReader oReader) {
        try {
            BigInteger bigInteger = vAL.y();
            if (vAL.compareTo(BGV.ad(bigInteger)) != 0) {
                oReader.addFailurePoint();
            }
            return bigInteger;
        }
        catch (Exception exception) {
            oReader.addFailurePoint();
            return BigInteger.ZERO;
        }
    }

    public Object newInstance() {
        return BigInteger.valueOf(0L);
    }

    public boolean checkFirstByte(int n2) {
        return n2 >= 41 && n2 <= 46;
    }
}

