/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.jpa;

import com.objectdb.jpa.criteria.Expressions;
import com.objectdb.o.DAV;
import com.objectdb.o.ERR;
import com.objectdb.o.HMP;
import com.objectdb.o.LKM;
import com.objectdb.o.MSS;
import com.objectdb.o.OBM;
import com.objectdb.o.QRC;
import com.objectdb.o.QRD;
import com.objectdb.o.QRQ;
import com.objectdb.o.QRS;
import com.objectdb.o.QRY;
import com.objectdb.o.SYH;
import com.objectdb.o.UserException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Parameter;
import javax.persistence.TemporalType;
import javax.persistence.TupleElement;
import javax.persistence.TypedQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaQuery<X>
extends QRY
implements TypedQuery<X> {
    private Set<Parameter<?>> m_parameters;
    private TupleElement[] m_resultElements;

    protected JpaQuery(String string, OBM oBM, Class clazz) {
        super(string, oBM, clazz);
    }

    protected JpaQuery() {
    }

    protected JpaQuery(QRD qRD) {
        super(qRD);
    }

    public final TypedQuery<X> setFlushMode(FlushModeType flushModeType) {
        this.f = flushModeType == FlushModeType.COMMIT;
        return this;
    }

    public final FlushModeType getFlushMode() {
        return this.f ? FlushModeType.COMMIT : FlushModeType.AUTO;
    }

    public final TypedQuery<X> setLockMode(LockModeType lockModeType) {
        this.a.j = LKM.z(lockModeType);
        return this;
    }

    public final LockModeType getLockMode() {
        return LKM.A(this.a.j);
    }

    public final TypedQuery<X> setFirstResult(int n2) {
        this.j = n2;
        this.a.f = true;
        return this;
    }

    public final int getFirstResult() {
        int n2 = (int)this.j;
        return n2 <= 0 ? 0 : n2;
    }

    public final TypedQuery<X> setMaxResults(int n2) {
        this.k = n2;
        this.a.f = true;
        this.u();
        return this;
    }

    public final int getMaxResults() {
        return (int)this.k;
    }

    public final Set<String> getSupportedHints() {
        return new HashSet<String>(Arrays.asList("javax.persistence.query.timeout", "javax.persistence.lock.timeout", "objectdb.query-language", "objectdb.result-fetch"));
    }

    public final TypedQuery<X> setHint(String string, Object object) {
        ERR.assertNotNull(string);
        ERR.assertNotNull(object);
        try {
            this.p(string, object);
            return this;
        }
        catch (RuntimeException runtimeException) {
            throw this.d.onObjectDBError(runtimeException);
        }
    }

    public final Map<String, Object> getHints() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(11, 0.5f);
        hashMap.put("objectdb.jpql.update", this.a.q());
        hashMap.put("objectdb.jpql.delete", this.a.r());
        hashMap.put("javax.persistence.query.timeout", this.a.i);
        hashMap.put("javax.persistence.lock.timeout", Long.valueOf(this.a.k));
        hashMap.put("objectdb.result-fetch", this.a.h ? "lazy" : "eager");
        hashMap.put("objectdb.query-language", this.a.a == 2 ? "JPQL" : (this.a.a == 1 ? "JDOQL" : "ODBQL"));
        if (this.l != null) {
            hashMap.put("objectdb.query.explanation", this.l);
        }
        this.analyzeQuery();
        if (this.m_resultElements != null) {
            hashMap.put("objectdb.tuple-elements", this.m_resultElements);
        }
        return hashMap;
    }

    public final <T> T unwrap(Class<T> clazz) {
        ERR.assertNotNull(clazz);
        if (!clazz.isInstance(this)) {
            throw MSS.cv.d(clazz.getName(), "Query");
        }
        return (T)this;
    }

    public final TypedQuery<X> setParameter(String string, Object object) {
        ERR.assertNotNull(string);
        this.putParameter(string, object);
        return this;
    }

    public final TypedQuery<X> setParameter(String string, Date date, TemporalType temporalType) {
        return this.setParameter(string, (Object)JpaQuery.fixTemporalArg(date, temporalType));
    }

    public final TypedQuery<X> setParameter(String string, Calendar calendar, TemporalType temporalType) {
        return this.setParameter(string, calendar.getTime(), temporalType);
    }

    public final TypedQuery<X> setParameter(int n2, Object object) {
        this.putParameter(String.valueOf(n2), object);
        return this;
    }

    public final TypedQuery<X> setParameter(int n2, Date date, TemporalType temporalType) {
        return this.setParameter(n2, (Object)JpaQuery.fixTemporalArg(date, temporalType));
    }

    public final TypedQuery<X> setParameter(int n2, Calendar calendar, TemporalType temporalType) {
        return this.setParameter(n2, calendar.getTime(), temporalType);
    }

    public final <T> TypedQuery<X> setParameter(Parameter<T> parameter, T t2) {
        ERR.assertNotNull(parameter);
        if (parameter.getName() != null) {
            this.setParameter(parameter.getName(), t2);
        } else if (parameter.getPosition() != null) {
            this.setParameter(parameter.getPosition(), t2);
        }
        return this;
    }

    public final TypedQuery<X> setParameter(Parameter<Calendar> parameter, Calendar calendar, TemporalType temporalType) {
        return this.setParameter((Parameter<T>)((Parameter)parameter), (T)calendar);
    }

    public final TypedQuery<X> setParameter(Parameter<Date> parameter, Date date, TemporalType temporalType) {
        return this.setParameter((Parameter<T>)((Parameter)parameter), (T)date);
    }

    private static Date fixTemporalArg(Date date, TemporalType temporalType) {
        if (temporalType == TemporalType.DATE) {
            return new Date(DAV.Y(SYH.C(date.getTime())));
        }
        if (temporalType == TemporalType.TIME) {
            return new Date(DAV.aa(SYH.C(date.getTime())));
        }
        return date;
    }

    public final void putParameter(String string, Object object) {
        if (object instanceof Calendar) {
            object = ((Calendar)object).getTime();
        }
        if (this.g == null) {
            this.g = new HMP(7, 1.0f);
        }
        this.g.w(string, object);
    }

    public final Object getParameterValue(String string) {
        ERR.assertNotNull(string);
        return this.g == null ? null : this.g.z(string);
    }

    public final Object getParameterValue(int n2) {
        return this.getParameterValue(String.valueOf(n2));
    }

    public final <T> T getParameterValue(Parameter<T> parameter) {
        ERR.assertNotNull(parameter);
        if (parameter.getName() != null) {
            return (T)this.getParameter(parameter.getName());
        }
        return (T)this.getParameter(parameter.getPosition());
    }

    public final boolean isBound(Parameter<?> parameter) {
        ERR.assertNotNull(parameter);
        if (this.g == null) {
            return false;
        }
        if (parameter.getName() != null) {
            return this.g.A(parameter.getName());
        }
        return this.g.A(parameter.getPosition().toString());
    }

    public final Parameter<?> getParameter(String string) {
        try {
            for (Parameter<?> parameter : this.getParameters()) {
                if (!string.equals(parameter.getName())) continue;
                return parameter;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.getParameter(string, Object.class);
    }

    public final <T> Parameter<T> getParameter(String string, Class<T> clazz) {
        ERR.assertNotNull(string);
        return new Expressions.h<T>(clazz, string);
    }

    public final Parameter<?> getParameter(int n2) {
        try {
            for (Parameter<?> parameter : this.getParameters()) {
                Integer n3 = parameter.getPosition();
                if (n3 == null || n2 != n3) continue;
                return parameter;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.getParameter(n2, Object.class);
    }

    public final <T> Parameter<T> getParameter(int n2, Class<T> clazz) {
        return new Expressions.h<T>(clazz, n2);
    }

    public final Set<Parameter<?>> getParameters() {
        this.analyzeQuery();
        return this.m_parameters;
    }

    private void analyzeQuery() {
        if (this.m_resultElements == null || this.m_parameters == null) {
            try {
                this.a.d = 0;
                QRC qRC = new QRC(this.a, this.g, this.d.ah(), this.d.UW());
                qRC.z();
                this.m_resultElements = qRC.B();
                this.m_parameters = qRC.A();
            }
            catch (UserException userException) {
                throw this.d.onObjectDBError(userException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<X> getResultList() {
        try {
            OBM oBM = this.d;
            synchronized (oBM) {
                Object object = this.s();
                if (object != this) {
                    return object instanceof List ? (List<Object>)object : Collections.singletonList(object);
                }
                QRQ qRQ = this.v(Boolean.FALSE);
                return (List)this.e.f(this, qRQ, this.g, this.f, this.i, 3);
            }
        }
        catch (RuntimeException runtimeException) {
            throw this.d.onObjectDBError(runtimeException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final X getSingleResult() {
        try {
            OBM oBM = this.d;
            synchronized (oBM) {
                Object object = this.s();
                if (object != this) {
                    return (X)object;
                }
                QRQ qRQ = this.v(Boolean.TRUE);
                Object object2 = this.e.f(this, qRQ, this.g, this.f, this.i, 3);
                return (X)object2;
            }
        }
        catch (RuntimeException runtimeException) {
            throw this.d.onObjectDBError(runtimeException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int executeUpdate() {
        try {
            OBM oBM = this.d;
            synchronized (oBM) {
                this.d.bl("run update query");
                this.a.d = 3;
                QRQ qRQ = this.v(Boolean.FALSE);
                QRS qRS = (QRS)this.e.f(this, qRQ, this.g, this.f, this.i, 1);
                long l2 = qRS.n();
                if (l2 > 0L) {
                    long l3 = this.d.ap();
                    if (l3 > 0L) {
                        this.d.ah().Vr(l3);
                    }
                    this.d.ao(l2);
                }
                return qRS.l().w();
            }
        }
        catch (RuntimeException runtimeException) {
            throw this.d.onObjectDBError(runtimeException);
        }
    }
}

