/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.conv1.store;

import com.objectdb.conv1.common.OldBuffer;
import com.objectdb.conv1.store.OldDataStore;
import com.objectdb.conv1.store.OldPageTypes;
import java.util.Arrays;

public abstract class OldPage
extends OldBuffer
implements OldPageTypes,
Comparable {
    protected static final int PAGE_TYPE_OFFSET = 0;
    protected static final int PAGE_VERSION_OFFSET = 1;
    protected static final int FLAGS_OFFSET = 3;
    protected static final int RESERVE_POS_OFFSET = 4;
    protected static final int HEADER_SIZE = 6;
    protected OldDataStore m_dataStore;
    protected int m_pageId;
    protected int m_pageType;
    protected int m_reservePos;

    final void set(OldDataStore oldDataStore, int n, int n2, byte[] byArray) {
        this.m_dataStore = oldDataStore;
        this.m_pageId = n;
        this.m_pageType = n2;
        this.m_data = byArray;
    }

    protected void init() {
        byte[] byArray = this.m_data;
        byArray[0] = (byte)this.m_pageType;
        Arrays.fill(byArray, 1, 6, (byte)0);
        this.m_reservePos = 0;
    }

    protected void destroy() {
    }

    protected void postRead() {
        this.m_reservePos = this.getUnsignedShort(4);
    }

    protected void postCache() {
    }

    public void reread() {
        this.m_data = this.m_dataStore.readPaper(this.m_pageId);
        this.postRead();
    }

    public final OldDataStore getDataStore() {
        return this.m_dataStore;
    }

    public final int getPageId() {
        return this.m_pageId;
    }

    public final int getPageType() {
        return this.m_pageType;
    }

    protected final int getPageSize() {
        return this.m_dataStore.getPageSize();
    }

    public static int getUnsignedShort(byte[] byArray, int n) {
        return ((byArray[n++] & 0xFF) << 8) + (byArray[n] & 0xFF);
    }

    public final int getUnsignedShort(int n) {
        return ((this.m_data[n++] & 0xFF) << 8) + (this.m_data[n] & 0xFF);
    }

    public final void setUnsignedShort(int n, int n2) {
        this.m_data[n] = (byte)(n2 >>> 8);
        this.m_data[n + 1] = (byte)(n2 & 0xFF);
    }

    public final int getInt(int n) {
        byte[] byArray = this.m_data;
        return (((byArray[n++] << 8) + (byArray[n++] & 0xFF) << 8) + (byArray[n++] & 0xFF) << 8) + (byArray[n] & 0xFF);
    }

    public final void setInt(int n, int n2) {
        this.m_data[n] = (byte)(n2 >>> 24);
        this.m_data[n + 1] = (byte)(n2 >>> 16 & 0xFF);
        this.m_data[n + 2] = (byte)(n2 >>> 8 & 0xFF);
        this.m_data[n + 3] = (byte)(n2 & 0xFF);
    }

    protected final int getFreeSpace() {
        return this.m_data.length - this.m_reservePos;
    }

    protected final void writeShortLength(int n) {
        if (n < 128) {
            this.writeByte(n);
        } else {
            this.writeShort(~n);
        }
    }

    protected final void writeShortLength(int n, int n2) {
        if (n2 < 128) {
            this.m_data[n] = (byte)n2;
        } else {
            OldPage.writeShort(this.m_data, n, ~n2);
        }
    }

    public int readShortLength(int n) {
        byte by = this.m_data[n];
        if (by >= 0) {
            return by;
        }
        return ~((by << 8) + (this.m_data[n + 1] & 0xFF));
    }

    protected void skipShortLength() {
        if (this.m_data[this.m_pos++] < 0) {
            ++this.m_pos;
        }
    }

    protected static int getGrossLength(int n) {
        if (n <= 126) {
            return n + 1;
        }
        return n + 2;
    }

    public int compareTo(Object object) {
        return this.m_pageId - ((OldPage)object).m_pageId;
    }
}

