/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.conv1.common;

public final class OldIntToObjMap {
    Entry[] m_table;
    private int m_count;
    private int m_threshold;
    private float m_loadFactor;

    public OldIntToObjMap(int n, float f) {
        this.m_loadFactor = f;
        this.m_threshold = (int)((float)n * f);
        this.m_table = new Entry[n];
    }

    public void put(int n, Object object) {
        if (this.m_count >= this.m_threshold) {
            this.resize(2 * this.m_table.length + 1);
            this.put(n, object);
        } else {
            int n2 = (n & Integer.MAX_VALUE) % this.m_table.length;
            Entry entry = new Entry(n, object);
            entry.m_next = this.m_table[n2];
            this.m_table[n2] = entry;
            ++this.m_count;
        }
    }

    private void resize(int n) {
        Entry[] entryArray = this.m_table;
        int n2 = entryArray.length;
        Entry[] entryArray2 = new Entry[n];
        this.m_threshold = (int)((float)n * this.m_loadFactor);
        int n3 = n2;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.m_next;
                int n4 = (entry2.m_key & Integer.MAX_VALUE) % n;
                entry2.m_next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
        this.m_table = entryArray2;
    }

    public boolean remove(int n) {
        Entry[] entryArray = this.m_table;
        int n2 = (n & Integer.MAX_VALUE) % this.m_table.length;
        Entry entry = entryArray[n2];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.m_key == n) {
                --this.m_count;
                if (entry2 != null) {
                    entry2.m_next = entry.m_next;
                } else {
                    entryArray[n2] = entry.m_next;
                }
                return true;
            }
            entry2 = entry;
            entry = entry.m_next;
        }
        return false;
    }

    public void clear() {
        if (this.m_count > 0) {
            Entry[] entryArray = this.m_table;
            int n = entryArray.length;
            while (--n >= 0) {
                entryArray[n] = null;
            }
            this.m_count = 0;
        }
    }

    public Object get(int n) {
        Entry[] entryArray = this.m_table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.m_key == n) {
                return entry.m_value;
            }
            entry = entry.m_next;
        }
        return null;
    }

    public int size() {
        return this.m_count;
    }

    private static final class Entry {
        int m_key;
        Object m_value;
        Entry m_next;

        Entry(int n, Object object) {
            this.m_key = n;
            this.m_value = object;
        }
    }
}

