/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb;

import com.objectdb.o.EXA;
import com.objectdb.o.SwingHelper;
import java.awt.Color;
import java.awt.Insets;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class Explorer {
    public static void main(final String[] stringArray) {
        System.setProperty("com.objectdb.internal.Explorer", "true");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public final void run() {
                Explorer.init(stringArray);
                new EXA(stringArray);
            }
        });
    }

    public static void init(String[] stringArray) {
        try {
            MetalLookAndFeel.setCurrentTheme(new MyMetalTheme());
            Color color = UIManager.getColor("List.background");
            Color color2 = UIManager.getColor("List.foreground");
            Color color3 = new Color(128);
            Color color4 = Color.white;
            UIManager.put("List.selectionBackground", color3);
            UIManager.put("List.selectionForeground", color4);
            UIManager.put("Table.selectionBackground", color3);
            UIManager.put("Table.selectionForeground", color4);
            UIManager.put("Tree.selectionBackground", color3);
            UIManager.put("Tree.selectionForeground", color4);
            UIManager.put("Tree.background", color);
            UIManager.put("Tree.textBackground", color);
            UIManager.put("Tree.textForeground", color2);
            UIManager.put("Desktop.background", Color.gray);
            Insets insets = new Insets(1, 4, 1, 4);
            UIManager.put("TabbedPane.tabInsets", insets);
            UIManager.put("TabbedPane.selectedTabPadInsets", insets);
            UIManager.put("Label.foreground", Color.black);
            Explorer.freeKeyBinding("List");
            Explorer.freeKeyBinding("Tree");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    static void freeKeyBinding(String string) {
        InputMap inputMap = (InputMap)UIManager.get(string + ".focusInputMap");
        inputMap.remove(KeyStroke.getKeyStroke(67, 2));
        inputMap.remove(KeyStroke.getKeyStroke(86, 2));
        inputMap.remove(KeyStroke.getKeyStroke(80, 2));
        inputMap.remove(KeyStroke.getKeyStroke(88, 2));
    }

    static class MyMetalTheme
    extends DefaultMetalTheme {
        FontUIResource m_controlFUIR;
        FontUIResource m_systemFUIR;
        FontUIResource m_smallFUIR;
        ColorUIResource controlColor;

        MyMetalTheme() {
            this.m_systemFUIR = this.m_controlFUIR = new FontUIResource(SwingHelper.f());
            this.m_smallFUIR = new FontUIResource(this.m_systemFUIR.deriveFont(11.0f));
            this.controlColor = new ColorUIResource(208, 208, 208);
        }

        @Override
        public FontUIResource getControlTextFont() {
            return this.m_controlFUIR;
        }

        @Override
        public FontUIResource getSystemTextFont() {
            return this.m_systemFUIR;
        }

        @Override
        public FontUIResource getUserTextFont() {
            return this.m_systemFUIR;
        }

        @Override
        public FontUIResource getMenuTextFont() {
            return this.m_systemFUIR;
        }

        @Override
        public FontUIResource getWindowTitleFont() {
            return this.m_controlFUIR;
        }

        @Override
        public FontUIResource getSubTextFont() {
            return this.m_smallFUIR;
        }

        @Override
        public ColorUIResource getControl() {
            return this.controlColor;
        }

        @Override
        public ColorUIResource getMenuBackground() {
            return this.controlColor;
        }
    }
}

