/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.conv1.common;

import com.objectdb.conv1.common.OldObjectRef;

public class OldBuffer {
    protected byte[] m_data;
    protected volatile int m_pos;
    public static final byte JUMP_INT = -1;
    public static final byte JUMP_LONG = -2;
    public static final byte JUMP_STRING = -3;
    public static final byte JUMP_OBJECT = -4;

    public OldBuffer() {
    }

    public OldBuffer(int n) {
        this.m_data = new byte[n];
    }

    public OldBuffer(byte[] byArray, int n) {
        this.m_data = byArray;
        this.m_pos = n;
    }

    public final OldBuffer set(byte[] byArray, int n) {
        this.m_data = byArray;
        this.m_pos = n;
        return this;
    }

    public final void set(byte[] byArray) {
        this.m_data = byArray;
        this.m_pos = 0;
    }

    public void makeSpace(int n) {
        if (this.m_pos + n > this.m_data.length) {
            int n2 = Math.max(this.m_data.length << 1, this.m_pos + n);
            byte[] byArray = new byte[n2];
            System.arraycopy(this.m_data, 0, byArray, 0, Math.min(this.m_pos, this.m_data.length));
            this.m_data = byArray;
        }
    }

    public final int prepareForInsert(int n, int n2) {
        this.makeSpace(n2);
        System.arraycopy(this.m_data, n, this.m_data, n + n2, this.m_pos - n);
        int n3 = this.m_pos + n2;
        this.m_pos = n;
        return n3;
    }

    public final void setData(byte[] byArray) {
        this.m_data = byArray;
        this.m_pos = 0;
    }

    public final byte[] getData() {
        return this.m_data;
    }

    public int getLength() {
        return this.m_data.length;
    }

    public final void setPos(int n) {
        this.m_pos = n;
    }

    public final int getPos() {
        return this.m_pos;
    }

    public final void skip(int n) {
        this.m_pos += n;
    }

    public int peek() {
        return this.m_data[this.m_pos];
    }

    public int readShortLength() {
        byte by;
        if ((by = this.m_data[this.m_pos++]) >= 0) {
            return by;
        }
        return ~((by << 8) + (this.m_data[this.m_pos++] & 0xFF));
    }

    public final void writeBoolean(boolean bl) {
        this.writeByte(bl ? 1 : 0);
    }

    public final boolean readBoolean() {
        return this.readByte() != 0;
    }

    public final void writeByte(int n) {
        this.makeSpace(1);
        this.m_data[this.m_pos++] = (byte)n;
    }

    public final byte readByte() {
        return this.m_data[this.m_pos++];
    }

    public final void writeByteArray(byte[] byArray) {
        int n = byArray.length;
        this.writeCompressedUInt(n);
        this.writeByteArray(byArray, 0, n);
    }

    public final void writeByteArray(byte[] byArray, int n, int n2) {
        this.makeSpace(n2);
        System.arraycopy(byArray, n, this.m_data, this.m_pos, n2);
        this.m_pos += n2;
    }

    public final byte[] readByteArray() {
        return this.readByteArray(null, this.readCompressedUInt());
    }

    public final int readByteArray(byte[] byArray) {
        int n = this.readCompressedUInt();
        if (this.readByteArray(byArray, n) != byArray) {
            throw new RuntimeException("Internal Exception");
        }
        return n;
    }

    public final byte[] readByteArray(byte[] byArray, int n) {
        if (byArray == null || n > byArray.length) {
            byArray = new byte[n];
        }
        System.arraycopy(this.m_data, this.m_pos, byArray, 0, n);
        this.m_pos += n;
        return byArray;
    }

    public final void skipByteArray() {
        int n = this.readCompressedUInt();
        this.m_pos += n;
    }

    public final void writeShort(int n) {
        this.writeByte(n >>> 8 & 0xFF);
        this.writeByte(n & 0xFF);
    }

    public final int readShort() {
        return (this.readByte() << 8) + (this.readByte() & 0xFF);
    }

    public static void writeShort(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n + 1] = (byte)(n2 & 0xFF);
    }

    public static short readShort(byte[] byArray, int n) {
        return (short)((byArray[n++] << 8) + (byArray[n] & 0xFF));
    }

    public final void writeChar(char c) {
        this.writeByte(c >>> 8);
        this.writeByte(c & 0xFF);
    }

    public final char readChar() {
        return (char)((this.readByte() << 8) + (this.readByte() & 0xFF));
    }

    public final void writeInt(int n) {
        this.writeByte(n >>> 24);
        this.writeByte(n >>> 16 & 0xFF);
        this.writeByte(n >>> 8 & 0xFF);
        this.writeByte(n & 0xFF);
    }

    public final int readInt() {
        return (((this.readByte() << 8) + (this.readByte() & 0xFF) << 8) + (this.readByte() & 0xFF) << 8) + (this.readByte() & 0xFF);
    }

    public final void writeCompressedInt(int n) {
        int n2;
        if (n >>> 7 == 0) {
            this.writeByte(n);
            return;
        }
        if (n < 0) {
            n ^= 0xFFFFFFFF;
            n2 = 192;
        } else {
            n2 = 128;
        }
        n2 |= (n & 7) << 3;
        n >>= 3;
        int n3 = this.m_pos;
        this.writeByte(0);
        while (n != 0) {
            this.writeByte(n & 0xFF);
            n >>= 8;
        }
        this.m_data[n3] = (byte)(n2 | this.m_pos - n3);
    }

    public final int readCompressedInt() {
        byte by = this.readByte();
        if (by >= 0) {
            return by;
        }
        int n = this.m_pos;
        int n2 = this.m_pos = n + (by & 7) - 1;
        int n3 = 0;
        while (n2 > n) {
            n3 = (n3 << 8) + (this.m_data[--n2] & 0xFF);
        }
        n3 = (n3 << 3) + (by >> 3 & 7);
        if ((by & 0x40) != 0) {
            return ~n3;
        }
        return n3;
    }

    public final void skipCompressedInt() {
        byte by = this.m_data[this.m_pos];
        this.m_pos = by >= 0 ? ++this.m_pos : (this.m_pos += by & 7);
    }

    public static void writeInt(byte[] byArray, int n, int n2) {
        byArray[n + 3] = (byte)(n2 & 0xFF);
        byArray[n + 2] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n + 1] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n] = (byte)(n2 >>> 24);
    }

    public static int readInt(byte[] byArray, int n) {
        return (((byArray[n++] << 8) + (byArray[n++] & 0xFF) << 8) + (byArray[n++] & 0xFF) << 8) + (byArray[n] & 0xFF);
    }

    public static void writeLong(byte[] byArray, int n, long l) {
        OldBuffer.writeInt(byArray, n, (int)(l >>> 32));
        OldBuffer.writeInt(byArray, n + 4, (int)(l & 0xFFFFFFFFL));
    }

    public static long readLong(byte[] byArray, int n) {
        return ((long)OldBuffer.readInt(byArray, n) << 32) + ((long)OldBuffer.readInt(byArray, n + 4) & 0xFFFFFFFFL);
    }

    public final void writeLong(long l) {
        this.writeInt((int)(l >>> 32));
        this.writeInt((int)(l & 0xFFFFFFFFL));
    }

    public final long readLong() {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public final void writeCompressedLong(long l) {
        int n;
        if (l >>> 7 == 0L) {
            this.writeByte((int)l);
            return;
        }
        if (l < 0L) {
            l ^= 0xFFFFFFFFFFFFFFFFL;
            n = 192;
        } else {
            n = 128;
        }
        n = (int)((long)n | (l & 3L) << 4);
        l >>= 2;
        int n2 = this.m_pos++;
        while (l != 0L) {
            this.writeByte((int)l & 0xFF);
            l >>= 8;
        }
        this.m_data[n2] = (byte)(n | this.m_pos - n2);
    }

    public final long readCompressedLong() {
        byte by = this.readByte();
        if (by >= 0) {
            return by;
        }
        int n = this.m_pos;
        int n2 = this.m_pos = n + (by & 0xF) - 1;
        long l = 0L;
        while (n2 > n) {
            l = (l << 8) + (long)(this.m_data[--n2] & 0xFF);
        }
        l = (l << 2) + (long)(by >> 4 & 3);
        if ((by & 0x40) != 0) {
            return l ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return l;
    }

    public final void skipCompressedLong() {
        byte by = this.m_data[this.m_pos];
        this.m_pos = by >= 0 ? ++this.m_pos : (this.m_pos += by & 0xF);
    }

    public final void writeFloat(float f) {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public final void writeDouble(double d) {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public final void writeCompressedUInt(int n) {
        if (n <= 127) {
            this.writeByte(n);
        } else {
            this.encodeU7(n);
        }
    }

    public final void writeCompressedUInt2(int n) {
        int n2 = n & Short.MAX_VALUE;
        if (n2 == n) {
            this.writeShort(n2);
        } else {
            this.writeShort(~n2);
            this.encodeU7(n >>> 15);
        }
    }

    private final void encodeU7(int n) {
        while (true) {
            int n2 = n & 0x7F;
            if ((n >>= 7) == 0) {
                this.writeByte(n2);
                return;
            }
            this.writeByte(~n2);
        }
    }

    public final int readCompressedUInt() {
        byte by = this.readByte();
        if (by >= 0) {
            return by;
        }
        return this.decodeU7(~by, 7);
    }

    public final int readCompressedUInt2() {
        int n = this.readShort();
        if (n >= 0) {
            return n;
        }
        return this.decodeU7(~n, 15);
    }

    private int decodeU7(int n, int n2) {
        byte by;
        while ((by = this.readByte()) < 0) {
            n += ~by << n2;
            n2 += 7;
        }
        return n + (by << n2);
    }

    public final void skipCompressedUNum() {
        while (this.readByte() < 0) {
        }
    }

    public final void skipCompressedUNum2() {
        if (this.peek() >= 0) {
            this.m_pos += 2;
        } else {
            this.m_pos += 2;
            while (this.m_data[this.m_pos++] < 0) {
            }
        }
    }

    public static int getStorageSizeOfCompressedUInt(int n) {
        int n2 = 1;
        while ((n >>= 7) != 0) {
            ++n2;
        }
        return n2;
    }

    public static int getStorageSizeOfCompressedUInt2(int n) {
        int n2 = 2;
        if ((n >>= 15) != 0) {
            do {
                ++n2;
            } while ((n >>= 7) != 0);
        }
        return n2;
    }

    public final void writeUIntArray(int[] nArray) {
        int n = nArray.length;
        this.writeCompressedUInt(n);
        this.writeUIntArray(nArray, n);
    }

    public final void writeUIntArray(int[] nArray, int n) {
        int n2 = n;
        while (n2-- > 0) {
            this.writeCompressedUInt(nArray[n2]);
        }
    }

    public final int[] readUIntArray() {
        return this.readUIntArray(null, this.readCompressedUInt());
    }

    public final int[] readUIntArray(int[] nArray, int n) {
        if (nArray == null || n > nArray.length) {
            nArray = new int[n];
        }
        while (n > 0) {
            nArray[--n] = this.readCompressedUInt();
        }
        return nArray;
    }

    public final void writeCompressedULong2(long l) {
        int n = (int)l & Short.MAX_VALUE;
        if ((long)n == l) {
            this.writeShort(n);
        } else {
            this.writeShort(~n);
            this.encodeU7(l >>> 15);
        }
    }

    public final void encodeU7(long l) {
        while (true) {
            int n = (int)l & 0x7F;
            if ((l >>= 7) == 0L) {
                this.writeByte(n);
                return;
            }
            this.writeByte(~n);
        }
    }

    public final long readCompressedULong2() {
        long l = (this.readByte() << 8) + (this.readByte() & 0xFF);
        if (l >= 0L) {
            return l;
        }
        return this.decodeU7(l ^ 0xFFFFFFFFFFFFFFFFL, 15);
    }

    public long decodeU7(long l, int n) {
        long l2;
        while ((l2 = (long)this.readByte()) < 0L) {
            l += (l2 ^ 0xFFFFFFFFFFFFFFFFL) << n;
            n += 7;
        }
        return l + (l2 << n);
    }

    public static int getStorageSizeOfCompressedULong2(long l) {
        int n = 2;
        if ((l >>= 15) != 0L) {
            do {
                ++n;
            } while ((l >>= 7) != 0L);
        }
        return n;
    }

    public final void writeString(String string) {
        if (string == null || OldBuffer.isAsciiString(string)) {
            this.writeAsciiString(string);
        } else {
            this.writeUnicodeString(string);
        }
    }

    public static boolean isAsciiString(String string) {
        int n = string.length();
        while (n-- > 0) {
            if ((string.charAt(n) & 0xFF00) == 0) continue;
            return false;
        }
        return true;
    }

    public final void writeAsciiString(String string) {
        if (string == null) {
            this.writeByte(0);
            return;
        }
        int n = string.length();
        if (n == 0) {
            this.writeByte(1);
            return;
        }
        this.writeCompressedUInt(n << 1);
        for (int i = 0; i < n; ++i) {
            this.writeByte(string.charAt(i));
        }
    }

    public final void writeUnicodeString(String string) {
        if (string == null) {
            this.writeByte(0);
            return;
        }
        int n = OldBuffer.getUTFLength(string);
        this.writeCompressedUInt((n << 1) + 1);
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            int n3 = string.charAt(i) & 0xFFFF;
            if (n3 <= 127) {
                this.writeByte(n3);
                continue;
            }
            if (n3 > 2047) {
                this.writeByte(0xE0 | n3 >> 12 & 0xF);
                this.writeByte(0x80 | n3 >> 6 & 0x3F);
                this.writeByte(0x80 | n3 & 0x3F);
                continue;
            }
            this.writeByte(0xC0 | n3 >> 6 & 0x1F);
            this.writeByte(0x80 | n3 & 0x3F);
        }
    }

    public static int getStorageSizeOfString(String string) {
        if (string == null) {
            return 1;
        }
        if (OldBuffer.isAsciiString(string)) {
            int n = string.length();
            return n + OldBuffer.getStorageSizeOfCompressedUInt(n << 1);
        }
        int n = OldBuffer.getUTFLength(string);
        return n + OldBuffer.getStorageSizeOfCompressedUInt((n << 1) + 1);
    }

    public static int getUTFLength(String string) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            int n3 = string.charAt(i) & 0xFFFF;
            if (n3 <= 127) {
                ++n;
                continue;
            }
            if (n3 > 2047) {
                n += 3;
                continue;
            }
            n += 2;
        }
        return n;
    }

    public final String readString() {
        int n = this.readCompressedUInt();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return "";
        }
        boolean bl = (n & 1) == 0;
        n >>>= 1;
        if (!bl) {
            return new String(this.readUTF(n));
        }
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)(this.readByte() & 0xFF);
        }
        return new String(cArray);
    }

    public char[] readUTF(int n) {
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = this.readByte() & 0xFF;
            if (n4 >>> 7 == 0) {
                cArray[n2] = (char)n4;
            } else {
                int n5 = this.readByte() & 0xFF;
                ++n3;
                switch (n4 >> 4) {
                    case 12: 
                    case 13: {
                        if ((n5 & 0xC0) != 128) {
                            OldBuffer.onUtfReadError();
                        }
                        cArray[n2] = (char)((n4 & 0x1F) << 6 | n5 & 0x3F);
                        break;
                    }
                    case 14: {
                        int n6 = this.readByte() & 0xFF;
                        ++n3;
                        if ((n5 & 0xC0) != 128 || (n6 & 0xC0) != 128) {
                            OldBuffer.onUtfReadError();
                        }
                        cArray[n2] = (char)((n4 & 0xF) << 12 | (n5 & 0x3F) << 6 | (n6 & 0x3F) << 0);
                        break;
                    }
                    default: {
                        OldBuffer.onUtfReadError();
                    }
                }
            }
            ++n3;
            ++n2;
        }
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, 0, cArray2, 0, n2);
        return cArray2;
    }

    private static void onUtfReadError() {
        throw new RuntimeException("Inconsistent database file (error reading UTF string)");
    }

    public void skipString() {
        this.m_pos = (this.readCompressedUInt() >>> 1) + this.m_pos;
    }

    public final void writeStringArray(Object[] objectArray) {
        int n = objectArray.length;
        this.writeCompressedUInt(n);
        this.writeStringArray(objectArray, n);
    }

    public final void writeStringArray(Object[] objectArray, int n) {
        while (n > 0) {
            Object object;
            if ((object = objectArray[--n]) instanceof String) {
                this.writeString((String)object);
                continue;
            }
            if (object == null) {
                this.writeString(null);
                continue;
            }
            this.writeString(object.toString());
        }
    }

    public final String[] readStringArray() {
        return this.readStringArray(null, this.readCompressedUInt());
    }

    public final String[] readStringArray(String[] stringArray, int n) {
        if (stringArray == null || n > stringArray.length) {
            stringArray = new String[n];
        }
        while (n > 0) {
            stringArray[--n] = this.readString();
        }
        return stringArray;
    }

    public final void writeRef(OldObjectRef oldObjectRef) {
        this.writeCompressedULong2(oldObjectRef.getObjectId());
        this.writeCompressedUInt2(oldObjectRef.getPageId());
    }

    public final OldObjectRef readRef() {
        return new OldObjectRef(this.readCompressedULong2(), this.readCompressedUInt2());
    }

    public final void readRef(OldObjectRef oldObjectRef) {
        oldObjectRef.setObjectId(this.readCompressedULong2());
        oldObjectRef.setPageId(this.readCompressedUInt2());
    }

    public final void writeRefArray(OldObjectRef[] oldObjectRefArray) {
        int n = oldObjectRefArray.length;
        this.writeCompressedUInt(n);
        this.writeRefArray(oldObjectRefArray, n);
    }

    public final void writeRefArray(OldObjectRef[] oldObjectRefArray, int n) {
        while (n > 0) {
            this.writeRef(oldObjectRefArray[--n]);
        }
    }

    public final OldObjectRef[] readRefArray() {
        return this.readRefArray(null, this.readCompressedUInt());
    }

    public final OldObjectRef[] readRefArray(OldObjectRef[] oldObjectRefArray, int n) {
        if (oldObjectRefArray == null || n > oldObjectRefArray.length) {
            oldObjectRefArray = new OldObjectRef[n];
        }
        while (n-- > 0) {
            OldObjectRef oldObjectRef = oldObjectRefArray[n];
            if (oldObjectRef == null) {
                oldObjectRefArray[n] = this.readRef();
                continue;
            }
            this.readRef(oldObjectRefArray[n]);
        }
        return oldObjectRefArray;
    }

    public final void writeType(int n, int n2, boolean bl) {
        if (n2 == 0) {
            if (n <= 112) {
                this.writeByte((byte)(bl ? ~n : n));
                return;
            }
            if (n < 2048) {
                int n3 = 113 + (n >> 8);
                this.writeByte(bl ? ~n3 : n3);
                this.writeByte(n & 0xFF);
                return;
            }
        } else if (n2 == 1 && n < 1024) {
            int n4 = 121 + (n >> 8);
            this.writeByte(bl ? ~n4 : n4);
            this.writeByte(n & 0xFF);
            return;
        }
        this.writeByte(bl ? -126 : 125);
        this.writeCompressedUInt2((n << 4) + n2);
    }

    public final int readType() {
        byte by = this.readByte();
        if (by < 0) {
            return this.readType(~by);
        }
        return this.readType(by);
    }

    public final int readType(int n) {
        if (n <= 112) {
            return n << 4;
        }
        if ((n -= 113) < 8) {
            return (n << 8) + (this.readByte() & 0xFF) << 4;
        }
        if ((n -= 8) < 4) {
            return ((n << 8) + (this.readByte() & 0xFF) << 4) + 1;
        }
        if (n == 4) {
            return this.readCompressedUInt2();
        }
        if (n == 6) {
            return 0;
        }
        throw new RuntimeException("Internal Exception");
    }

    public final int analyzeFieldHeader() {
        byte by = this.readByte();
        if (by == 0) {
            return 0;
        }
        if (by < 0) {
            return ~by;
        }
        if (by > 96) {
            return 96 - by;
        }
        if (by >= 16) {
            return (by - 16 << 8) + (this.readByte() & 0xFF);
        }
        if (by == 1) {
            return this.readCompressedUInt();
        }
        throw new RuntimeException("Internal Exception");
    }

    public void jumpOnFieldValue(int n) {
        if (n > 0) {
            this.m_pos += n;
        } else if (n == -4) {
            int n2 = this.analyzeFieldHeader();
            if (n2 != 0) {
                this.m_pos += n2 < 0 ? -n2 : n2;
            }
        } else if (n == -3) {
            this.skipString();
        } else if (n == -1) {
            this.skipCompressedInt();
        } else if (n == -2) {
            this.skipCompressedLong();
        }
    }
}

