/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.conv1.store;

import com.objectdb.conv1.common.OldBuffer;
import com.objectdb.conv1.common.OldObjectRef;
import com.objectdb.conv1.store.OldClassManagerPage;
import com.objectdb.conv1.store.OldExtentPage;
import com.objectdb.conv1.store.OldIndexManager;
import com.objectdb.conv1.store.OldPageTypes;
import com.objectdb.conv1.type.OldUserTypeInfo;
import java.util.ArrayList;

public final class OldClassInfo
implements OldPageTypes {
    private OldClassManagerPage m_classManager;
    int m_classIndex;
    private OldClassInfo m_superClassInfo;
    private OldClassInfo[] m_subClassInfo;
    private String m_className;
    private String m_superClassName;
    private boolean m_isHidden;
    private OldObjectRef[] m_versionRefs;
    private int m_extentRootId;
    private OldExtentPage m_extentRoot;
    private OldIndexManager.SuperIndexInfo m_inclusiveIndexInfo;
    public OldIndexManager.SuperIndexInfo m_exclusiveIndexInfo;
    private long m_objectCount;

    OldClassInfo(OldClassManagerPage oldClassManagerPage, OldUserTypeInfo oldUserTypeInfo) {
        this.m_classManager = oldClassManagerPage;
        this.m_classIndex = -1;
        this.m_className = oldUserTypeInfo.getClassName();
        this.m_versionRefs = new OldObjectRef[]{oldUserTypeInfo};
    }

    OldClassInfo(OldClassManagerPage oldClassManagerPage, int n, OldBuffer oldBuffer) {
        this.m_classManager = oldClassManagerPage;
        this.m_classIndex = n;
        this.readFromBuffer(oldBuffer);
        this.m_objectCount = oldClassManagerPage.readObjectCount(n);
    }

    void init() {
    }

    public OldClassManagerPage getClassManager() {
        return this.m_classManager;
    }

    void setClassIndex(int n) {
        this.m_classIndex = n;
    }

    public String getClassName() {
        return this.m_className;
    }

    public int getLastVersionTypeId() {
        return (int)this.m_versionRefs[0].getObjectId();
    }

    public int getLastVersionPageId() {
        return this.m_versionRefs[0].getPageId();
    }

    OldObjectRef[] getVersionRefs() {
        return this.m_versionRefs;
    }

    int getVersionPageId(int n) {
        OldObjectRef[] oldObjectRefArray = this.m_versionRefs;
        int n2 = oldObjectRefArray.length;
        for (int i = 0; i < n2; ++i) {
            if ((int)oldObjectRefArray[i].getObjectId() != n) continue;
            return oldObjectRefArray[i].getPageId();
        }
        return 0;
    }

    String getSuperClassName() {
        return this.m_superClassName;
    }

    public OldIndexManager.SuperIndexInfo getRootIndexInfo() {
        return this.m_inclusiveIndexInfo;
    }

    public boolean isHidden() {
        return this.m_isHidden;
    }

    void setSuperClassName(String string) {
        this.m_superClassName = string == null ? "" : string;
    }

    void setHidden(boolean bl) {
        this.m_isHidden = bl;
    }

    public long getObjectCount() {
        return this.m_objectCount;
    }

    public boolean hasExtent() {
        return this.m_extentRootId != 0;
    }

    public OldExtentPage getExtent() {
        if (this.m_extentRoot == null || this.m_extentRoot.getPageId() < 0) {
            if (this.m_extentRootId == 0) {
                return null;
            }
            this.m_extentRoot = (OldExtentPage)this.m_classManager.getDataStore().openPage(this.m_extentRootId);
        }
        return this.m_extentRoot;
    }

    public OldClassInfo getSuperClassInfo() {
        if (this.m_superClassInfo == null) {
            this.m_superClassInfo = this.m_classManager.getClassInfo(this.getSuperClassName());
        }
        return this.m_superClassInfo;
    }

    public OldClassInfo[] getSubClassInfo() {
        if (this.m_subClassInfo == null) {
            ArrayList<OldClassInfo> arrayList = new ArrayList<OldClassInfo>(4);
            OldClassInfo[] oldClassInfoArray = this.m_classManager.getAllClassInfo();
            int n = oldClassInfoArray.length;
            while (n-- > 0) {
                if (!this.isSuperClassOf(oldClassInfoArray[n])) continue;
                arrayList.add(oldClassInfoArray[n]);
            }
            this.m_subClassInfo = arrayList.toArray(new OldClassInfo[arrayList.size()]);
        }
        return this.m_subClassInfo;
    }

    private boolean isSuperClassOf(OldClassInfo oldClassInfo) {
        do {
            String string;
            if ((string = oldClassInfo.getSuperClassName()) == null || string.length() == 0) {
                return false;
            }
            oldClassInfo = this.m_classManager.getClassInfo(string);
            if (oldClassInfo != null) continue;
            return false;
        } while (oldClassInfo != this);
        return true;
    }

    void reset() {
        this.m_superClassInfo = null;
        this.m_subClassInfo = null;
    }

    void writeIntoBuffer(OldBuffer oldBuffer) {
        oldBuffer.writeByte(1);
        oldBuffer.writeString(this.m_className);
        oldBuffer.writeString(this.m_superClassName);
        oldBuffer.writeCompressedUInt(this.m_extentRootId);
        oldBuffer.writeBoolean(this.m_isHidden);
        oldBuffer.writeRefArray(this.m_versionRefs);
        if (this.m_exclusiveIndexInfo != null) {
            this.m_exclusiveIndexInfo.writeIntoBuffer(oldBuffer);
        } else {
            oldBuffer.writeByte(8);
        }
        for (int i = 0; i < 4; ++i) {
            oldBuffer.writeCompressedUInt(0);
        }
    }

    void readFromBuffer(OldBuffer oldBuffer) {
        oldBuffer.readByte();
        this.m_className = oldBuffer.readString();
        this.m_superClassName = oldBuffer.readString();
        this.m_extentRootId = oldBuffer.readCompressedUInt();
        this.m_isHidden = oldBuffer.readBoolean();
        this.m_versionRefs = oldBuffer.readRefArray();
        this.m_exclusiveIndexInfo = (OldIndexManager.SuperIndexInfo)OldIndexManager.constructFromBuffer(oldBuffer, this);
        oldBuffer.skip(4);
    }
}

