/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.conv1.store;

import com.objectdb.conv.ConvertManager;
import com.objectdb.conv1.common.OldBuffer;
import com.objectdb.conv1.store.OldDataPage;
import com.objectdb.conv1.store.OldPage;
import com.objectdb.conv1.type.OldTypeInfo;
import com.objectdb.conv1.type.OldTypeManager;

public final class OldDataSinglePage
extends OldPage
implements OldDataPage {
    private int m_beginPos;
    private int m_endPos;

    public boolean locateObjectBuffer(long l) {
        int n = 6;
        int n2 = 6;
        int n3 = this.m_reservePos;
        while (n < n3) {
            this.setPos(n);
            n2 = n + this.readShortLength();
            long l2 = this.readCompressedULong2();
            if (l2 >= l) {
                this.m_beginPos = n;
                this.m_endPos = n2;
                if (l2 == l) {
                    return true;
                }
            }
            n = n2;
        }
        this.m_beginPos = n;
        this.m_endPos = n2;
        return false;
    }

    public void locateAtEnd() {
        this.m_beginPos = this.m_reservePos;
    }

    public boolean locateVersionBuffer(int n) {
        int n2 = 6;
        int n3 = 6;
        int n4 = this.m_reservePos;
        while (n2 < n4) {
            this.setPos(n2);
            n3 = n2 + this.readShortLength();
            long l = this.readCompressedULong2();
            if (l != 0L) break;
            int n5 = this.readInt();
            if (n5 >= n) {
                this.m_beginPos = n2;
                this.m_endPos = n3;
                return n5 == n;
            }
            n2 = n3;
        }
        this.m_beginPos = n2;
        this.m_endPos = n3;
        return false;
    }

    public byte[] retrieve() {
        this.setPos(this.m_beginPos);
        this.skipShortLength();
        int n = this.m_endPos - this.getPos();
        byte[] byArray = new byte[n + 4];
        OldDataSinglePage.writeInt(byArray, 0, this.m_pageId);
        System.arraycopy(this.getData(), this.getPos(), byArray, 4, n);
        return byArray;
    }

    public OldBuffer retrieveCurrent() {
        this.setPos(this.m_beginPos);
        return this;
    }

    public void convertObjects(ConvertManager convertManager, OldTypeManager oldTypeManager) {
        OldBuffer oldBuffer = new OldBuffer(this.m_data, 0);
        int n = 6;
        int n2 = this.m_reservePos;
        while (n < n2) {
            oldBuffer.setPos(n);
            int n3 = oldBuffer.readShortLength();
            n += n3;
            long l = oldBuffer.readCompressedULong2();
            if (l == 0L) continue;
            OldTypeInfo oldTypeInfo = oldTypeManager.getTypeInfo(oldBuffer.readType());
            try {
                convertManager.convertObject(l, oldTypeInfo, oldBuffer);
            }
            catch (Exception exception) {
                System.out.println("Failed to convert object " + oldTypeInfo.getClassName() + ":" + l);
                exception.printStackTrace();
            }
        }
    }
}

