/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.conv1.store;

import com.objectdb.conv1.store.OldMultiPage;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class OldFirstPage
extends OldMultiPage {
    private static final int VERSION_OFFSET = 38;
    private static final int PAGE_COUNT_OFFSET = 48;
    private static final int LAST_MODIFIED_OFFSET = 56;
    private static final int LAST_GC_OFFSET = 64;
    private static final int LAST_REORGANIZATION_OFFSET = 72;
    private static final int FREE_OBJECT_ID_OFFSET = 80;
    private static final int DELETED_COUNT_OFFSET = 88;
    private static final int TRANSACTION_COUNT_OFFSET = 96;
    private static final int BITMAP_REF_TABLE_OFFSET = 136;
    private static final String SIGNATURE = "OBJECTDB X  1.00";
    private int m_pageCount;
    private long m_lastModifiedTime;
    private long m_garbageCollectionTime;
    private long m_reorganizationTime;
    private long m_freeObjectId;
    private long m_transactionCount;

    static void checkSignature(RandomAccessFile randomAccessFile) {
        try {
            byte[] byArray = new byte[16];
            randomAccessFile.seek(28L);
            randomAccessFile.readFully(byArray);
            String string = new String(byArray);
            if (string.regionMatches(0, SIGNATURE, 0, 10)) {
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new RuntimeException("Bad ODB file format");
    }

    protected void postRead() {
        super.postRead();
        this.m_pageCount = this.getInt(48);
        float f = this.getFileVersion();
        if (f < 1.0f || f >= 2.0f) {
            throw new RuntimeException("Invalid ODB file version");
        }
        this.m_pos = 80;
        this.m_freeObjectId = this.readLong();
        this.m_pos = 88;
        this.readLong();
        this.m_pos = 96;
        this.m_transactionCount = this.readLong();
    }

    float getFileVersion() {
        try {
            return Float.parseFloat(new String(this.m_data, 38, 6));
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0f;
        }
    }

    long getLastModifiedTime() {
        if (this.m_lastModifiedTime == 0L) {
            this.readTimes();
        }
        return this.m_lastModifiedTime;
    }

    long getGarbageCollectionTime() {
        if (this.m_lastModifiedTime == 0L) {
            this.readTimes();
        }
        return this.m_garbageCollectionTime;
    }

    long getReorganizationTime() {
        if (this.m_lastModifiedTime == 0L) {
            this.readTimes();
        }
        return this.m_reorganizationTime;
    }

    public long getTransactionCount() {
        return this.m_transactionCount;
    }

    private void readTimes() {
        this.m_pos = 56;
        this.m_lastModifiedTime = this.readLong();
        this.m_pos = 64;
        this.m_garbageCollectionTime = this.readLong();
        this.m_pos = 72;
        this.m_reorganizationTime = this.readLong();
    }

    public long getNextObjectId() {
        return this.m_freeObjectId;
    }

    int getPageCount() {
        return this.m_pageCount;
    }

    boolean isAllocatedPageId(int n) {
        return (this.getFullNode(0, n >>> 3) >>> (n & 7) & 1) != 0;
    }

    private int getFullNode(int n, int n2) {
        int n3 = this.getInt(136 + (n << 2));
        return this.getExtByte(n3 + n2);
    }
}

