/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.conv1.type;

import com.objectdb.conv.ConvertManager;
import com.objectdb.conv1.common.OldBuffer;
import com.objectdb.conv1.common.OldUtils;
import com.objectdb.conv1.type.OldTypeInfo;
import com.objectdb.conv1.type.OldTypeManager;
import com.objectdb.o.TYW;

public class OldWrapperTypeInfo
extends OldTypeInfo {
    public OldWrapperTypeInfo(OldTypeManager oldTypeManager, int n, int n2) {
        super(oldTypeManager, OldUtils.getWrapperClass(n), n2);
        this.m_primitiveCode = n;
    }

    public int getTypeCode() {
        return this.m_primitiveCode;
    }

    public void skipElement(OldBuffer oldBuffer) {
        OldTypeInfo.skipPrimitive(this.m_primitiveCode, oldBuffer);
    }

    public boolean isAssignableFrom(OldTypeInfo oldTypeInfo) {
        return super.isAssignableFrom(oldTypeInfo) || this.getTypeId() - oldTypeInfo.getTypeId() == 8;
    }

    public void convertObject(OldBuffer oldBuffer, boolean bl, ConvertManager convertManager, TYW tYW) {
        switch (this.m_primitiveCode) {
            case 12: {
                tYW.writeBooleanValue(oldBuffer.readBoolean());
                break;
            }
            case 1: {
                tYW.writeSByteValue(oldBuffer.readByte());
                break;
            }
            case 2: {
                tYW.writeCharValue(oldBuffer.readChar());
                break;
            }
            case 3: {
                tYW.writeSInt16Value((short)oldBuffer.readShort());
                break;
            }
            case 4: {
                tYW.writeSInt32Value(oldBuffer.readCompressedInt());
                break;
            }
            case 5: {
                tYW.writeSInt64Value(oldBuffer.readCompressedLong());
                break;
            }
            case 6: {
                tYW.writeFloatValue(oldBuffer.readFloat());
                break;
            }
            case 7: {
                tYW.writeDoubleValue(oldBuffer.readDouble());
                break;
            }
            default: {
                throw new RuntimeException("Internal Exception");
            }
        }
    }
}

