/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.conv1.value;

import com.objectdb.conv1.common.OldBuffer;
import com.objectdb.conv1.value.OldValue;

public class OldIntValue
extends OldValue {
    int m_value;
    boolean m_isNull;

    public int getTypeCode() {
        return 4;
    }

    public void set(Object object) {
        if (object == null) {
            this.m_isNull = true;
        } else {
            if (object instanceof Number) {
                this.set(((Number)object).intValue());
            } else if (object instanceof Character) {
                this.set(((Character)object).charValue());
            } else {
                throw new ClassCastException(String.valueOf(object));
            }
            this.m_isNull = false;
        }
    }

    public void set(int n) {
        this.m_value = n;
    }

    public Object get() {
        if (this.m_isNull) {
            return null;
        }
        return this.m_value;
    }

    public boolean isNull() {
        return this.m_isNull;
    }

    public final int increase() {
        return ++this.m_value;
    }

    public final int decrease() {
        return --this.m_value;
    }

    public int intValue() {
        this.assertNotNull();
        return this.m_value;
    }

    public long longValue() {
        this.assertNotNull();
        return this.m_value;
    }

    public float floatValue() {
        this.assertNotNull();
        return this.m_value;
    }

    public double doubleValue() {
        this.assertNotNull();
        return this.m_value;
    }

    public void upgrade(OldValue oldValue, OldBuffer oldBuffer) {
        oldBuffer.writeCompressedInt(oldValue.intValue());
    }

    public void readFromBuffer(OldBuffer oldBuffer) {
        this.m_value = oldBuffer.readCompressedInt();
        this.m_isNull = false;
    }

    static final class ShortValue
    extends OldIntValue {
        ShortValue() {
        }

        public int getTypeCode() {
            return 3;
        }

        public Object get() {
            if (this.m_isNull) {
                return null;
            }
            return (short)this.m_value;
        }

        public void upgrade(OldValue oldValue, OldBuffer oldBuffer) {
            oldBuffer.writeShort((short)oldValue.intValue());
        }

        public void readFromBuffer(OldBuffer oldBuffer) {
            this.m_value = oldBuffer.readShort();
            this.m_isNull = false;
        }
    }

    static final class CharValue
    extends OldIntValue {
        CharValue() {
        }

        public int getTypeCode() {
            return 2;
        }

        public Object get() {
            if (this.m_isNull) {
                return null;
            }
            return Character.valueOf((char)this.m_value);
        }

        public void upgrade(OldValue oldValue, OldBuffer oldBuffer) {
            oldBuffer.writeChar((char)oldValue.intValue());
        }

        public void readFromBuffer(OldBuffer oldBuffer) {
            this.m_value = oldBuffer.readChar();
            this.m_isNull = false;
        }
    }

    static final class ByteValue
    extends OldIntValue {
        ByteValue() {
        }

        public int getTypeCode() {
            return 1;
        }

        public Object get() {
            if (this.m_isNull) {
                return null;
            }
            return (byte)this.m_value;
        }

        public void upgrade(OldValue oldValue, OldBuffer oldBuffer) {
            oldBuffer.writeByte((byte)oldValue.intValue());
        }

        public void readFromBuffer(OldBuffer oldBuffer) {
            this.m_value = oldBuffer.readByte();
            this.m_isNull = false;
        }
    }
}

