/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.jpa.criteria;

import com.objectdb.jpa.criteria.CriteriaElement;
import com.objectdb.jpa.criteria.Expressions;
import com.objectdb.jpa.criteria.FromImpl;
import com.objectdb.jpa.criteria.JpqlWriter;
import com.objectdb.jpa.criteria.RootImpl;
import com.objectdb.jpa.criteria.SubqueryImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;

abstract class AbstractQueryImpl<T>
extends CriteriaElement<T>
implements AbstractQuery<T> {
    final Metamodel m_metamodel;
    boolean m_distinct;
    CriteriaElement m_selection;
    final List<RootImpl<?>> m_rootList = new ArrayList(4);
    Predicate m_where;
    Expression<?>[] m_grouping;
    Predicate m_having;

    AbstractQueryImpl(Metamodel metamodel, Class<T> clazz) {
        super(clazz);
        this.m_metamodel = metamodel;
    }

    public final void setSelection(Selection<? extends T> selection) {
        this.m_selection = (CriteriaElement)selection;
    }

    public Selection<T> getSelection() {
        return this.m_selection;
    }

    public final Class<T> getResultType() {
        Class<Object> clazz = this.getJavaType();
        if (clazz == Object.class && this.m_selection.isCompoundSelection()) {
            clazz = Object[].class;
        }
        return clazz;
    }

    public AbstractQuery<T> distinct(boolean bl) {
        this.m_distinct = bl;
        return this;
    }

    public final boolean isDistinct() {
        return this.m_distinct;
    }

    public final <X> Root<X> from(EntityType<X> entityType) {
        RootImpl<X> rootImpl = new RootImpl<X>(this.m_metamodel, entityType);
        this.m_rootList.add(rootImpl);
        return rootImpl;
    }

    public final <X> Root<X> from(Class<X> clazz) {
        return this.from(this.m_metamodel.entity(clazz));
    }

    public final Set<Root<?>> getRoots() {
        return new LinkedHashSet(this.m_rootList);
    }

    public AbstractQuery<T> where(Expression<Boolean> expression) {
        this.m_where = expression != null ? Expressions.predicate(expression) : null;
        return this;
    }

    public AbstractQuery<T> where(Predicate ... predicateArray) {
        this.m_where = new Expressions.LogPredicateImpl(Predicate.BooleanOperator.AND, (Expression<Boolean>[])predicateArray);
        return this;
    }

    public final Predicate getRestriction() {
        return this.m_where;
    }

    public AbstractQuery<T> groupBy(Expression<?> ... expressionArray) {
        this.m_grouping = expressionArray != null ? (Expression[])expressionArray.clone() : null;
        return this;
    }

    public AbstractQuery<T> groupBy(List<Expression<?>> list) {
        return this.groupBy(list != null ? list.toArray(new Expression[0]) : null);
    }

    public final List<Expression<?>> getGroupList() {
        ArrayList arrayList = new ArrayList();
        if (this.m_grouping != null) {
            arrayList.addAll(Arrays.asList(this.m_grouping));
        }
        return arrayList;
    }

    public AbstractQuery<T> having(Expression<Boolean> expression) {
        this.m_having = expression != null ? Expressions.predicate(expression) : null;
        return this;
    }

    public AbstractQuery<T> having(Predicate ... predicateArray) {
        this.m_having = new Expressions.LogPredicateImpl(Predicate.BooleanOperator.AND, (Expression<Boolean>[])predicateArray);
        return this;
    }

    public final Predicate getGroupRestriction() {
        return this.m_having;
    }

    public final <U> Subquery<U> subquery(Class<U> clazz) {
        return new SubqueryImpl<U>(this, clazz);
    }

    @Override
    void writeJpql(JpqlWriter jpqlWriter) {
        Selection<T> selection = this.getSelection();
        if (selection != null) {
            jpqlWriter.write("SELECT ");
            if (this.m_distinct) {
                jpqlWriter.write("DISTINCT ");
            }
            ((CriteriaElement)selection).writeJpqlSelect(jpqlWriter);
        }
        ArrayList<FromImpl> arrayList = new ArrayList<FromImpl>();
        this.collectDeFactoRoots(arrayList);
        if (!arrayList.isEmpty()) {
            jpqlWriter.write(" FROM ");
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (i2 > 0) {
                    jpqlWriter.write(", ");
                }
                ((FromImpl)arrayList.get(i2)).writeJpqlFrom(jpqlWriter);
            }
        }
        if (this.m_where != null) {
            jpqlWriter.write(" WHERE ").write(this.m_where, false);
        }
        if (this.m_grouping != null && this.m_grouping.length > 0) {
            jpqlWriter.write(" GROUP BY ").writeList(this.m_grouping, true);
        }
        if (this.m_having != null) {
            jpqlWriter.write(" HAVING ").write(this.m_having, false);
        }
    }

    void collectDeFactoRoots(List<FromImpl> list) {
        list.addAll(this.m_rootList);
    }
}

