/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo.identity;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jdo.JDOUserException;
import javax.jdo.identity.SingleFieldIdentity;
import javax.jdo.spi.JDOImplHelper;

public class ObjectIdentity
extends SingleFieldIdentity {
    static JDOImplHelper helper = (JDOImplHelper)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return JDOImplHelper.getInstance();
        }
    });
    static final String STRING_DELIMITER = ":";

    public ObjectIdentity(Class clazz, Object object) {
        super(clazz);
        this.assertKeyNotNull(object);
        String string = null;
        String string2 = null;
        String string3 = null;
        if (object instanceof String) {
            string = (String)object;
            if (string.length() < 3) {
                throw new JDOUserException(msg.msg("EXC_ObjectIdentityStringConstructionTooShort") + msg.msg("EXC_ObjectIdentityStringConstructionUsage", string));
            }
            int n2 = string.indexOf(STRING_DELIMITER);
            if (n2 < 0) {
                throw new JDOUserException(msg.msg("EXC_ObjectIdentityStringConstructionNoDelimiter") + msg.msg("EXC_ObjectIdentityStringConstructionUsage", string));
            }
            string2 = string.substring(n2 + 1);
            string3 = string.substring(0, n2);
            this.keyAsObject = JDOImplHelper.construct(string3, string2);
        } else {
            this.keyAsObject = object;
        }
        this.hashCode = this.hashClassName() ^ this.keyAsObject.hashCode();
    }

    public ObjectIdentity() {
    }

    public Object getKey() {
        return this.keyAsObject;
    }

    public String toString() {
        return this.keyAsObject.getClass().getName() + STRING_DELIMITER + this.keyAsObject.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        ObjectIdentity objectIdentity = (ObjectIdentity)object;
        return this.keyAsObject.equals(objectIdentity.keyAsObject);
    }

    public int compareTo(Object object) {
        if (object instanceof ObjectIdentity) {
            ObjectIdentity objectIdentity = (ObjectIdentity)object;
            int n2 = super.compare(objectIdentity);
            if (n2 == 0) {
                if (objectIdentity.keyAsObject instanceof Comparable && this.keyAsObject instanceof Comparable) {
                    return ((Comparable)this.keyAsObject).compareTo(objectIdentity.keyAsObject);
                }
                throw new ClassCastException("The key class (" + this.keyAsObject.getClass().getName() + ") does not implement Comparable");
            }
            return n2;
        }
        if (object == null) {
            throw new ClassCastException("object is null");
        }
        throw new ClassCastException(this.getClass().getName() + " != " + object.getClass().getName());
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.keyAsObject);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.keyAsObject = objectInput.readObject();
    }
}

