/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.conv1.store;

import com.objectdb.conv1.store.OldLinkedPage;
import com.objectdb.conv1.store.OldPage;
import com.objectdb.conv1.value.OldStringValue;
import com.objectdb.conv1.value.OldValue;
import java.util.ArrayList;

public class OldBTreePage
extends OldLinkedPage {
    protected static final int POS = 12;
    static final int KEY_TYPE_CODE_OFFSET = 12;
    static final int VALUE_TYPE_CODE_OFFSET = 13;
    static final int FLAGS_OFFSET1 = 14;
    protected static final int HEADER_SIZE2 = 15;
    protected OldBTreePage m_parent;
    protected OldValue m_keyDelegate;
    protected OldValue m_valueDelegate;
    protected boolean m_isIndex;
    protected boolean m_isUnique;

    @Override
    protected void init() {
        super.init();
        this.m_reservePos = 15;
        this.m_isUnique = false;
        this.m_isIndex = false;
        this.m_data[14] = 0;
    }

    @Override
    protected void postRead() {
        super.postRead();
        this.initKeyAndValueDelegates();
        byte by = this.m_data[14];
        this.m_isIndex = (by & 1) != 0;
        this.m_isUnique = (by & 2) != 0;
    }

    void initKeyAndValueDelegates() {
        this.m_keyDelegate = OldValue.constructValue(this.m_data[12]);
        this.m_valueDelegate = OldValue.constructValue(this.m_data[13]);
    }

    public void setKeyValueTypes(OldValue oldValue, OldValue oldValue2) {
        this.m_data[12] = (byte)oldValue.getTypeCode();
        this.m_keyDelegate = oldValue;
        this.m_data[13] = (byte)oldValue2.getTypeCode();
        this.m_valueDelegate = oldValue2;
    }

    public final void setIndexPage(boolean bl) {
        this.m_isIndex = bl;
        this.m_data[14] = bl ? (byte)(this.m_data[14] | 1) : (byte)(this.m_data[14] & 0xFFFFFFFE);
    }

    public void setUnique(boolean bl) {
        this.m_isUnique = bl;
        this.m_data[14] = bl ? (byte)(this.m_data[14] | 2) : (byte)(this.m_data[14] & 0xFFFFFFFD);
    }

    public final OldValue getKeyDelegate() {
        return this.m_keyDelegate;
    }

    public final OldValue getValueDelegate() {
        return this.m_valueDelegate;
    }

    public Object retrieveFirstValue(OldValue oldValue, boolean bl) {
        if (this.m_isIndex) {
            return this.findChildPage(oldValue, null).retrieveFirstValue(oldValue, bl);
        }
        int n = this.findKey(oldValue);
        if (n < 0) {
            if ((n ^= 0xFFFFFFFF) >= this.m_reservePos) {
                OldBTreePage oldBTreePage = (OldBTreePage)this.openNextPage(true);
                if (oldBTreePage == null) {
                    return null;
                }
                return oldBTreePage.retrieveFirstValue(oldValue, bl);
            }
            if (bl) {
                return null;
            }
            this.m_pos = n;
            this.skipShortLength();
            oldValue.readIndexKey(this);
        }
        this.m_valueDelegate.readIndexKey(this);
        return this.m_valueDelegate;
    }

    public String[] getAllStringKeys() {
        OldStringValue oldStringValue = (OldStringValue)this.m_keyDelegate;
        ArrayList<Object> arrayList = new ArrayList<Object>(64);
        OldBTreePage oldBTreePage = this.getFirstDataPage();
        do {
            int n = oldBTreePage.m_reservePos;
            for (int i = 15; i < n; i += oldBTreePage.readShortLength()) {
                oldBTreePage.m_pos = i;
                oldStringValue.readIndexKey(oldBTreePage);
                arrayList.add(oldStringValue.get());
            }
        } while ((oldBTreePage = (OldBTreePage)oldBTreePage.openNextPage(true)) != null);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    int findKey(OldValue oldValue) {
        if (oldValue == null) {
            if (this.m_reservePos == 15) {
                return -16;
            }
            return 15;
        }
        int n = this.m_reservePos;
        this.m_pos = 15;
        while (this.m_pos < n) {
            int n2 = this.m_pos;
            int n3 = n2 + this.readShortLength();
            int n4 = oldValue.compare(this);
            if (n4 <= 0) {
                if (n4 == 0) {
                    return n2;
                }
                return ~n2;
            }
            this.m_pos = n3;
        }
        return ~n;
    }

    protected final int findValue(OldValue oldValue, int n, OldValue oldValue2) {
        this.m_pos = n;
        int n2 = n + this.readShortLength();
        oldValue.skipIndexKey(this);
        return oldValue2.search(this, n2);
    }

    protected final OldBTreePage findChildPage(OldValue oldValue, OldValue oldValue2) {
        int n;
        int n2;
        int n3;
        int n4 = this.m_reservePos;
        this.m_pos = 15;
        while (true) {
            n3 = this.m_pos;
            this.skipCompressedUNum2();
            n2 = this.m_pos;
            if (n2 >= n4) break;
            if (this.readByte() == 0) {
                if (oldValue.compare(this) >= 0) continue;
                break;
            }
            n = oldValue.compare(this);
            if (n <= 0) {
                if (n >= 0 && oldValue2 != null && oldValue2.compare(this) >= 0) continue;
                break;
            }
            this.m_valueDelegate.skipIndexKey(this);
        }
        this.m_pos = n3;
        n = this.readCompressedUInt2();
        OldPage oldPage = this.m_dataStore.openPage(n);
        OldBTreePage oldBTreePage = (OldBTreePage)oldPage;
        oldBTreePage.m_parent = this;
        this.m_pos = n2;
        return oldBTreePage;
    }

    public OldBTreePage getFirstDataPage() {
        if ((this.m_data[14] & 1) == 0) {
            return this;
        }
        this.m_pos = 15;
        OldBTreePage oldBTreePage = (OldBTreePage)this.m_dataStore.openPage(this.readCompressedUInt2());
        return oldBTreePage.getFirstDataPage();
    }

    public final int copyDataTo(byte[] byArray) {
        int n = this.m_reservePos - 15;
        System.arraycopy(this.m_data, 15, byArray, 0, n);
        return n;
    }

    public static interface KeySelector {
        public Boolean isValidKey();
    }
}

