/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.conv1.store;

import com.objectdb.conv1.common.OldBuffer;
import com.objectdb.conv1.common.OldIntToObjMap;
import com.objectdb.conv1.common.OldObjectRef;
import com.objectdb.conv1.store.OldClassInfo;
import com.objectdb.conv1.store.OldMainStoreMgr;
import com.objectdb.conv1.store.OldMultiPage;
import com.objectdb.conv1.type.OldTypeInfo;
import com.objectdb.conv1.type.OldTypeManager;
import java.util.ArrayList;
import java.util.HashMap;

public final class OldClassManagerPage
extends OldMultiPage {
    static final int OLD_OBJECT_COUNT_OFFSET = 29;
    static final int OBJECT_COUNT_OFFSET = 32;
    OldTypeManager m_typeManager;
    int m_freeVersionId;
    HashMap m_nameToClassInfo;
    OldIntToObjMap m_typeIdToClassInfo;
    OldClassInfo[] m_allClassInfo;
    OldMainStoreMgr m_tmpStoreManager;

    public void setTypeManager(OldTypeManager oldTypeManager) {
        this.m_typeManager = oldTypeManager;
    }

    public OldTypeManager getTypeManager() {
        return this.m_typeManager;
    }

    @Override
    public void postRead() {
        int n;
        super.postRead();
        OldBuffer oldBuffer = new OldBuffer().set(this.getContent(), 0);
        if (this.m_data[1] == 0) {
            oldBuffer.skip(1);
        } else {
            oldBuffer.skip(4);
        }
        this.m_freeVersionId = oldBuffer.readInt();
        int n2 = oldBuffer.readInt();
        int n3 = oldBuffer.readInt();
        oldBuffer.skip(n2 * 8);
        HashMap<String, OldClassInfo> hashMap = this.m_nameToClassInfo = new HashMap<String, OldClassInfo>(n2 * 2 + 7, 0.5f);
        OldIntToObjMap oldIntToObjMap = this.m_typeIdToClassInfo = new OldIntToObjMap(n3 * 2 + 7, 0.5f);
        this.m_allClassInfo = new OldClassInfo[n2];
        for (n = 0; n < n2; ++n) {
            OldClassInfo oldClassInfo;
            this.m_allClassInfo[n] = oldClassInfo = new OldClassInfo(this, n, oldBuffer);
            hashMap.put(oldClassInfo.getClassName(), oldClassInfo);
            OldObjectRef[] oldObjectRefArray = oldClassInfo.getVersionRefs();
            int n4 = oldObjectRefArray.length;
            while (n4-- > 0) {
                oldIntToObjMap.put((int)oldObjectRefArray[n4].getObjectId(), oldClassInfo);
            }
        }
        for (n = 0; n < n2; ++n) {
            this.m_allClassInfo[n].init();
        }
        this.m_allClassInfo = null;
    }

    public OldClassInfo getClassInfo(String string) {
        return (OldClassInfo)this.m_nameToClassInfo.get(string);
    }

    public OldClassInfo getClassInfo(int n) {
        if (!OldTypeManager.isUserTypeId(n) || (n & 0xF) != 0) {
            return null;
        }
        OldClassInfo oldClassInfo = (OldClassInfo)this.m_typeIdToClassInfo.get(n >> 4);
        if (oldClassInfo == null) {
            throw new RuntimeException("Internal Exception");
        }
        return oldClassInfo;
    }

    public int getVersionPageId(int n) {
        OldClassInfo oldClassInfo = (OldClassInfo)this.m_typeIdToClassInfo.get(n);
        if (oldClassInfo == null) {
            return 0;
        }
        return oldClassInfo.getVersionPageId(n);
    }

    public OldClassInfo[] getAllClassInfo() {
        if (this.m_allClassInfo == null) {
            int n = this.m_nameToClassInfo.size();
            this.m_allClassInfo = new OldClassInfo[n];
            int n2 = 0;
            for (OldClassInfo oldClassInfo : this.m_nameToClassInfo.values()) {
                n2 = this.addClassInfo(oldClassInfo, n2);
            }
        }
        return this.m_allClassInfo;
    }

    int addClassInfo(OldClassInfo oldClassInfo, int n) {
        for (int i = 0; i < n; ++i) {
            if (this.m_allClassInfo[i] != oldClassInfo) continue;
            return n;
        }
        OldClassInfo oldClassInfo2 = oldClassInfo.getSuperClassInfo();
        if (oldClassInfo2 != null) {
            n = this.addClassInfo(oldClassInfo2, n);
        }
        this.m_allClassInfo[n++] = oldClassInfo;
        return n;
    }

    long readObjectCount(int n) {
        int n2 = this.m_data[1] == 0 ? 29 : 32;
        return this.getExtLong(n2 + (n << 3));
    }

    public void prepareIds(OldObjectRef[] oldObjectRefArray, int n, int n2) {
        while (n < n2) {
            OldObjectRef oldObjectRef;
            if ((oldObjectRef = oldObjectRefArray[n++]).getObjectId() != 0L) continue;
            if (oldObjectRef instanceof OldTypeInfo) {
                ((OldTypeInfo)oldObjectRef).setTypeId(this.m_freeVersionId++);
            } else {
                oldObjectRef.setObjectId(this.m_freeVersionId++);
            }
            oldObjectRef.setPageId(0);
        }
    }

    public String[] getAllClassNames() {
        ArrayList<String> arrayList = new ArrayList<String>(this.m_nameToClassInfo.size());
        for (OldClassInfo oldClassInfo : this.m_nameToClassInfo.values()) {
            if (oldClassInfo.isHidden()) continue;
            arrayList.add(oldClassInfo.getClassName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

