/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.conv1.value;

import com.objectdb.conv1.common.OldBuffer;
import com.objectdb.conv1.common.OldObjectRef;
import com.objectdb.conv1.value.OldValue;

public final class OldObjRefValue
extends OldValue {
    long m_valueObjId;
    int m_valuePageId;
    transient OldBuffer m_valueBuffer = new OldBuffer(16);

    @Override
    public int getTypeCode() {
        return 15;
    }

    @Override
    public void set(Object object) {
        if (object == null) {
            super.set(object);
        } else {
            OldObjectRef oldObjectRef = (OldObjectRef)object;
            OldBuffer oldBuffer = this.m_valueBuffer;
            oldBuffer.setPos(0);
            this.m_valueObjId = oldObjectRef.getObjectId();
            oldBuffer.writeCompressedULong2(this.m_valueObjId);
            this.m_valuePageId = oldObjectRef.getPageId();
            oldBuffer.writeCompressedUInt2(this.m_valuePageId);
        }
    }

    @Override
    public Object get() {
        return new OldObjectRef(this.m_valueObjId, this.m_valuePageId);
    }

    @Override
    public void writeIndexKey(OldBuffer oldBuffer) {
        oldBuffer.writeByteArray(this.m_valueBuffer.getData(), 0, this.m_valueBuffer.getPos());
    }

    @Override
    public void readIndexKey(OldBuffer oldBuffer) {
        int n = oldBuffer.getPos();
        this.m_valueObjId = oldBuffer.readCompressedULong2();
        this.m_valuePageId = oldBuffer.readCompressedUInt2();
        OldBuffer oldBuffer2 = this.m_valueBuffer;
        oldBuffer2.setPos(0);
        oldBuffer2.writeByteArray(oldBuffer.getData(), n, oldBuffer.getPos() - n);
    }

    @Override
    public void skipIndexKey(OldBuffer oldBuffer) {
        oldBuffer.skipCompressedUNum2();
        oldBuffer.skipCompressedUNum2();
    }

    @Override
    public int getSize() {
        return this.m_valueBuffer.getPos();
    }

    @Override
    public int compare(OldBuffer oldBuffer) {
        long l = oldBuffer.readCompressedULong2();
        oldBuffer.skipCompressedUNum2();
        if (this.m_valueObjId < l) {
            return -1;
        }
        if (this.m_valueObjId == l) {
            return 0;
        }
        return 1;
    }
}

