/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.jpa.criteria;

import com.objectdb.jpa.criteria.Expressions;
import com.objectdb.jpa.criteria.JpqlWritable;
import com.objectdb.jpa.criteria.JpqlWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.persistence.criteria.CompoundSelection;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Selection;

abstract class CriteriaElement<T>
extends JpqlWritable
implements Expression<T> {
    final Class<T> m_sysType;
    protected String m_alias;

    CriteriaElement(Class<T> clazz) {
        this.m_sysType = clazz;
    }

    public final String getAlias() {
        return this.m_alias;
    }

    public final Class<? extends T> getJavaType() {
        return this.m_sysType;
    }

    public final Selection<T> alias(String string) {
        this.m_alias = string;
        return this;
    }

    public boolean isCompoundSelection() {
        return false;
    }

    public List<Selection<?>> getCompoundSelectionItems() {
        return new ArrayList<CriteriaElement>(Collections.singletonList(this));
    }

    public final <X> Expression<X> as(Class<X> clazz) {
        return Expressions.expression(clazz, "(", clazz.getName(), ")", this);
    }

    public final Predicate isNull() {
        return Expressions.predicate(this, " IS NULL");
    }

    public final Predicate isNotNull() {
        return Expressions.predicate(this, " IS NOT NULL");
    }

    public final Predicate in(Object ... objectArray) {
        if (objectArray.length == 0) {
            return Expressions.predicate(Boolean.FALSE);
        }
        Expressions.InPredicateImpl inPredicateImpl = new Expressions.InPredicateImpl(this);
        for (Object object : objectArray) {
            inPredicateImpl.value(object);
        }
        return inPredicateImpl;
    }

    public final Predicate in(Collection<?> collection) {
        return this.in(collection.toArray());
    }

    public final Predicate in(Expression<?> ... expressionArray) {
        Expressions.InPredicateImpl inPredicateImpl = new Expressions.InPredicateImpl(this);
        for (Expression<?> expression : expressionArray) {
            inPredicateImpl.value(expression);
        }
        return inPredicateImpl;
    }

    public final Predicate in(Expression<Collection<?>> expression) {
        return Expressions.predicate(this, " IN (", expression, ")");
    }

    public Predicate.BooleanOperator getOperator() {
        return null;
    }

    public List<Expression<Boolean>> getExpressions() {
        return new ArrayList<Expression<Boolean>>(Arrays.asList(this));
    }

    public boolean isNegated() {
        return false;
    }

    public Predicate not() {
        return new Expressions.NotPredicateImpl((Predicate)this);
    }

    void writeJpqlSelect(JpqlWriter jpqlWriter) {
        this.writeJpql(jpqlWriter);
        if (this.getAlias() != null) {
            jpqlWriter.write(" AS ").write(this.getAlias());
        }
    }

    static final class CompoundSelectionImpl<T>
    extends CriteriaElement<T>
    implements CompoundSelection<T> {
        final boolean m_construct;
        final CriteriaElement<?>[] m_selections;

        CompoundSelectionImpl(Class<T> clazz, boolean bl, Selection<?>[] selectionArray) {
            super(clazz);
            this.m_construct = bl;
            int n2 = selectionArray.length;
            this.m_selections = new CriteriaElement[n2];
            System.arraycopy(selectionArray, 0, this.m_selections, 0, n2);
        }

        @Override
        public boolean isCompoundSelection() {
            return true;
        }

        @Override
        public List<Selection<?>> getCompoundSelectionItems() {
            return new ArrayList(Arrays.asList(this.m_selections));
        }

        @Override
        void writeJpqlSelect(JpqlWriter jpqlWriter) {
            if (this.m_construct) {
                jpqlWriter.write("NEW ").write(this.getJavaType().getName()).write("(");
            }
            this.m_selections[0].writeJpqlSelect(jpqlWriter);
            for (int i2 = 1; i2 < this.m_selections.length; ++i2) {
                jpqlWriter.write(", ");
                this.m_selections[i2].writeJpqlSelect(jpqlWriter);
            }
            if (this.m_construct) {
                jpqlWriter.write(")");
            }
        }

        @Override
        void writeJpql(JpqlWriter jpqlWriter) {
            this.writeJpqlSelect(jpqlWriter);
        }
    }
}

