/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.jpa.criteria;

import com.objectdb.jpa.criteria.CriteriaElement;
import com.objectdb.jpa.criteria.JpqlWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;

public abstract class Expressions {
    static <T> Expression<T> literal(T t2) {
        return new LiteralImpl<Object>(t2 != null ? t2.getClass() : Object.class, t2);
    }

    static <T> CompExpressionImpl<T> expression(Class<T> clazz, Object ... objectArray) {
        return new CompExpressionImpl<T>(clazz, objectArray);
    }

    static <T> FunctionExpressionImpl function(Class<T> clazz, String string, Object ... objectArray) {
        return new FunctionExpressionImpl<T>(clazz, string, objectArray);
    }

    static Predicate predicate(Object ... objectArray) {
        if (objectArray.length == 1 && objectArray[0] instanceof Predicate) {
            return (Predicate)objectArray[0];
        }
        return new CompPredicateImpl(objectArray);
    }

    static final class NotPredicateImpl
    extends CriteriaElement<Boolean>
    implements Predicate {
        final Predicate m_childPredicate;

        NotPredicateImpl(Predicate predicate) {
            super(Boolean.class);
            this.m_childPredicate = predicate;
        }

        @Override
        public boolean isNegated() {
            return true;
        }

        @Override
        void writeJpql(JpqlWriter jpqlWriter) {
            jpqlWriter.write("NOT ");
            jpqlWriter.write(this.m_childPredicate, true);
        }
    }

    static class LogPredicateImpl
    extends CriteriaElement<Boolean>
    implements Predicate {
        final Predicate.BooleanOperator m_operator;
        final Expression<Boolean>[] m_expressions;

        LogPredicateImpl(Predicate.BooleanOperator booleanOperator, Expression<Boolean> ... expressionArray) {
            super(Boolean.class);
            this.m_operator = booleanOperator;
            this.m_expressions = expressionArray;
        }

        @Override
        public final Predicate.BooleanOperator getOperator() {
            return this.m_operator;
        }

        @Override
        public List<Expression<Boolean>> getExpressions() {
            return new ArrayList<Expression<Boolean>>(Arrays.asList(this.m_expressions));
        }

        @Override
        void writeJpql(JpqlWriter jpqlWriter) {
            jpqlWriter.write("(");
            jpqlWriter.write(this.m_expressions[0], this.m_expressions.length > 1);
            for (int i2 = 1; i2 < this.m_expressions.length; ++i2) {
                jpqlWriter.write(" ").write(this.m_operator.toString()).write(" ");
                jpqlWriter.write(this.m_expressions[i2], true);
            }
            jpqlWriter.write(")");
        }
    }

    static final class InPredicateImpl<S>
    extends CriteriaElement<Boolean>
    implements CriteriaBuilder.In<S> {
        final Expression<S> m_expression;
        final List<Expression<? extends S>> m_valueList = new ArrayList<Expression<? extends S>>();

        InPredicateImpl(Expression<S> expression) {
            super(Boolean.class);
            this.m_expression = expression;
        }

        public Expression<S> getExpression() {
            return this.m_expression;
        }

        public CriteriaBuilder.In<S> value(Expression<? extends S> expression) {
            this.m_valueList.add(expression);
            return this;
        }

        public CriteriaBuilder.In<S> value(S s2) {
            return this.value((S)Expressions.literal(s2));
        }

        @Override
        void writeJpql(JpqlWriter jpqlWriter) {
            jpqlWriter.write(this.m_expression, false);
            jpqlWriter.writeFunction(" IN ", this.m_valueList.toArray());
        }
    }

    static class CompPredicateImpl
    extends CompExpressionImpl<Boolean>
    implements Predicate {
        CompPredicateImpl(Object ... objectArray) {
            super(Boolean.class, objectArray);
        }
    }

    public static final class ParameterExpressionImpl<T>
    extends CriteriaElement<T>
    implements ParameterExpression<T> {
        String m_name;
        Integer m_pos;

        public ParameterExpressionImpl(Class<T> clazz, String string) {
            super(clazz);
            this.m_name = string;
        }

        public ParameterExpressionImpl(Class<T> clazz, int n2) {
            super(clazz);
            this.m_pos = n2;
        }

        public String getName() {
            return this.m_name;
        }

        public Integer getPosition() {
            return this.m_pos;
        }

        public Class<T> getParameterType() {
            return this.getJavaType();
        }

        @Override
        void writeJpql(JpqlWriter jpqlWriter) {
            if (this.m_name == null) {
                this.m_name = "p" + jpqlWriter.allocateParameterIx();
            }
            jpqlWriter.addParameter(this);
            jpqlWriter.write(":").write(this.m_name);
        }
    }

    static final class CoalesceImpl<R>
    extends CriteriaElement<R>
    implements CriteriaBuilder.Coalesce<R> {
        final List<Expression<? extends R>> m_valueList = new ArrayList<Expression<? extends R>>();

        CoalesceImpl(Class<R> clazz) {
            super(clazz);
        }

        public CriteriaBuilder.Coalesce<R> value(Expression<? extends R> expression) {
            this.m_valueList.add(expression);
            return this;
        }

        public CriteriaBuilder.Coalesce<R> value(R r2) {
            return this.value((R)Expressions.literal(r2));
        }

        @Override
        void writeJpql(JpqlWriter jpqlWriter) {
            jpqlWriter.writeFunction("COALESCE", this.m_valueList.toArray());
        }
    }

    static final class SimpleCaseImpl<C, R>
    extends AbstractCase<R, C>
    implements CriteriaBuilder.SimpleCase<C, R> {
        SimpleCaseImpl(Class<R> clazz, Expression<C> expression) {
            super(clazz, expression);
        }

        public CriteriaBuilder.SimpleCase<C, R> when(C c2, Expression<? extends R> expression) {
            this.addWhen(Expressions.literal(c2), expression);
            return this;
        }

        public CriteriaBuilder.SimpleCase<C, R> when(C c2, R r2) {
            return this.when(c2, (R)Expressions.literal(r2));
        }
    }

    static final class CaseImpl<R>
    extends AbstractCase<R, Object>
    implements CriteriaBuilder.Case<R> {
        CaseImpl(Class<R> clazz) {
            super(clazz, null);
        }

        public CriteriaBuilder.Case<R> when(Expression<Boolean> expression, Expression<? extends R> expression2) {
            super.addWhen(expression, expression2);
            return this;
        }

        public CriteriaBuilder.Case<R> when(Expression<Boolean> expression, R r2) {
            return this.when(expression, (R)Expressions.literal(r2));
        }
    }

    static abstract class AbstractCase<R, C>
    extends CriteriaElement<R> {
        final Expression<C> m_expression;
        final List<Object[]> m_condList = new ArrayList<Object[]>(4);
        Expression<? extends R> m_elseResult;

        AbstractCase(Class<R> clazz, Expression<C> expression) {
            super(clazz);
            this.m_expression = expression;
        }

        public final Expression<C> getExpression() {
            return this.m_expression;
        }

        final void addWhen(Expression expression, Expression<? extends R> expression2) {
            this.m_condList.add(new Object[]{expression, expression2});
        }

        public final Expression<R> otherwise(Expression<? extends R> expression) {
            this.m_elseResult = expression;
            return this.m_elseResult;
        }

        public final Expression<R> otherwise(R r2) {
            return this.otherwise((R)Expressions.literal(r2));
        }

        @Override
        final void writeJpql(JpqlWriter jpqlWriter) {
            jpqlWriter.write("CASE");
            if (this.m_expression != null) {
                jpqlWriter.write(" ").write(this.m_expression, false);
            }
            for (Object[] objectArray : this.m_condList) {
                jpqlWriter.write(" WHEN ").write(objectArray[0], false);
                jpqlWriter.write(" THEN ").write(objectArray[1], false);
            }
            if (this.m_elseResult != null) {
                jpqlWriter.write(" ELSE ").write(this.m_elseResult, false);
            }
            jpqlWriter.write(" END");
        }
    }

    static final class FunctionExpressionImpl<T>
    extends CriteriaElement<T>
    implements Expression<T> {
        final String m_funcName;
        final Object[] m_args;

        FunctionExpressionImpl(Class<T> clazz, String string, Object[] objectArray) {
            super(clazz);
            this.m_funcName = string;
            this.m_args = objectArray;
        }

        @Override
        void writeJpql(JpqlWriter jpqlWriter) {
            jpqlWriter.writeFunction(this.m_funcName, this.m_args);
        }
    }

    static class CompExpressionImpl<T>
    extends CriteriaElement<T> {
        final Object[] m_components;

        CompExpressionImpl(Class<T> clazz, Object[] objectArray) {
            super(clazz);
            this.m_components = objectArray;
        }

        @Override
        final void writeJpql(JpqlWriter jpqlWriter) {
            for (Object object : this.m_components) {
                jpqlWriter.write(object, true);
            }
        }

        @Override
        final boolean needsParenthesis() {
            return this.m_components != null && this.m_components.length > 1;
        }
    }

    static final class LiteralImpl<T>
    extends CriteriaElement<T> {
        final Object m_value;

        LiteralImpl(Class<T> clazz, T t2) {
            super(clazz);
            this.m_value = t2;
        }

        public boolean isEmpty() {
            return !(this.m_value instanceof Collection) || ((Collection)this.m_value).isEmpty();
        }

        public int size() {
            return this.m_value instanceof Collection ? ((Collection)this.m_value).size() : 0;
        }

        public boolean contains(Object object) {
            return this.m_value instanceof Collection && ((Collection)this.m_value).contains(object);
        }

        @Override
        void writeJpql(JpqlWriter jpqlWriter) {
            jpqlWriter.writeLiteral(this.m_value);
        }
    }
}

