/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.conv1.type;

import com.objectdb.conv.ConvertManager;
import com.objectdb.conv1.common.OldBuffer;
import com.objectdb.conv1.type.OldArrayTypeInfo;
import com.objectdb.conv1.type.OldTypeInfo;
import com.objectdb.conv1.type.OldTypeManager;
import com.objectdb.o.TYW;
import com.objectdb.o.UTY;

public final class OldPrmArrayTypeInfo
extends OldArrayTypeInfo {
    public OldPrmArrayTypeInfo(OldTypeManager oldTypeManager, String string, int n, OldTypeInfo oldTypeInfo) {
        super(oldTypeManager, string, oldTypeInfo);
        this.m_primitiveCode = n;
    }

    @Override
    public void skipElement(OldBuffer oldBuffer) {
        int n = oldBuffer.readCompressedUInt();
        while (n-- > 0) {
            OldTypeInfo.skipPrimitive(this.m_primitiveCode, oldBuffer);
        }
    }

    @Override
    public void convertObject(OldBuffer oldBuffer, boolean bl, ConvertManager convertManager, TYW tYW) {
        int n = oldBuffer.readCompressedUInt();
        if (n == 0 && this.tryWritingEmpty(convertManager, tYW)) {
            return;
        }
        UTY uTY = convertManager.getNewTypeManager().u();
        switch (this.m_primitiveCode) {
            case 1: {
                byte[] byArray = new byte[n];
                for (int i = 0; i < n; ++i) {
                    byArray[i] = oldBuffer.readByte();
                }
                tYW.writeElement(uTY, byArray);
                break;
            }
            case 2: {
                char[] cArray = new char[n];
                for (int i = 0; i < n; ++i) {
                    cArray[i] = oldBuffer.readChar();
                }
                tYW.writeElement(uTY, cArray);
                break;
            }
            case 3: {
                short[] sArray = new short[n];
                for (int i = 0; i < n; ++i) {
                    sArray[i] = (short)oldBuffer.readShort();
                }
                tYW.writeElement(uTY, sArray);
                break;
            }
            case 4: {
                int[] nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = oldBuffer.readCompressedInt();
                }
                tYW.writeElement(uTY, nArray);
                break;
            }
            case 5: {
                long[] lArray = new long[n];
                for (int i = 0; i < n; ++i) {
                    lArray[i] = oldBuffer.readCompressedLong();
                }
                tYW.writeElement(uTY, lArray);
                break;
            }
            case 6: {
                float[] fArray = new float[n];
                for (int i = 0; i < n; ++i) {
                    fArray[i] = oldBuffer.readFloat();
                }
                tYW.writeElement(uTY, fArray);
                break;
            }
            case 7: {
                double[] dArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    dArray[i] = oldBuffer.readDouble();
                }
                tYW.writeElement(uTY, dArray);
                break;
            }
            case 12: {
                boolean[] blArray = new boolean[n];
                for (int i = 0; i < n; ++i) {
                    blArray[i] = oldBuffer.readBoolean();
                }
                tYW.writeElement(uTY, blArray);
                break;
            }
            default: {
                throw new RuntimeException("Internal Exception");
            }
        }
    }
}

