/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.conv1.type;

import com.objectdb.conv1.common.OldBuffer;
import com.objectdb.conv1.common.OldUtils;
import com.objectdb.conv1.type.OldTypeManager;
import com.objectdb.conv1.type.OldUserFieldInfo;
import com.objectdb.conv1.type.OldUserTypeInfo;
import com.objectdb.conv1.value.OldValue;

public final class OldUpgradeProgram {
    public OldUserTypeInfo m_sourceTypeInfo;
    public OldUserTypeInfo m_targetTypeInfo;
    Operation m_operationList;
    RuntimeException m_upgradeException;

    public OldUpgradeProgram(OldUserTypeInfo oldUserTypeInfo) {
        try {
            this.prepareProgram(oldUserTypeInfo);
        }
        catch (RuntimeException runtimeException) {
            this.m_upgradeException = runtimeException;
            throw runtimeException;
        }
    }

    void prepareProgram(OldUserTypeInfo oldUserTypeInfo) {
        OldTypeManager oldTypeManager = oldUserTypeInfo.getTypeManager();
        String string = oldUserTypeInfo.getClassName();
        this.m_sourceTypeInfo = oldUserTypeInfo;
        this.m_targetTypeInfo = (OldUserTypeInfo)oldTypeManager.getTypeInfo(string, true);
        OldUserFieldInfo[] oldUserFieldInfoArray = (OldUserFieldInfo[])this.m_targetTypeInfo.getFields().clone();
        int[] nArray = this.m_targetTypeInfo.getPersistentFieldIndexes();
        OldUserFieldInfo[] oldUserFieldInfoArray2 = oldUserTypeInfo.getFields();
        int[] nArray2 = oldUserTypeInfo.getPersistentFieldIndexes();
        int n = nArray.length;
        block0: while (n-- > 0) {
            int n2;
            int n3 = nArray[n];
            OldUserFieldInfo oldUserFieldInfo = oldUserFieldInfoArray[n3];
            String string2 = oldUserFieldInfo.getName();
            int n4 = nArray2.length;
            while (n4-- > 0) {
                int n5;
                n2 = nArray2[n4];
                OldUserFieldInfo oldUserFieldInfo2 = oldUserFieldInfoArray2[n2];
                if (oldUserFieldInfo2 == null || !string2.equals(oldUserFieldInfo2.getName())) continue;
                boolean bl = oldUserFieldInfo2.isPrimitiveOrString();
                boolean bl2 = oldUserFieldInfo.isPrimitiveOrString();
                if (!bl && !bl2) {
                    this.m_operationList = CopyOperation.construct(this.m_operationList, n4);
                    continue block0;
                }
                if (!bl || !bl2) break;
                int n6 = oldUserFieldInfo2.getPrimitiveCode();
                if (n6 == (n5 = oldUserFieldInfo.getPrimitiveCode())) {
                    this.m_operationList = CopyOperation.construct(this.m_operationList, n4);
                    continue block0;
                }
                if (n6 == 0 || n5 == 0 || n6 == 12 || n5 == 12) break;
                this.m_operationList = CastingOperation.construct(this.m_operationList, n4, n6, n5);
                continue block0;
            }
            n4 = oldUserFieldInfo.getPrimitiveCode();
            n2 = 0;
            if (n4 != 0) {
                n2 = OldUtils.getSize(n4);
            }
            if (n2 == 0) {
                n2 = 1;
            }
            this.m_operationList = ResetOperation.construct(this.m_operationList, n2);
        }
    }

    public OldBuffer upgrade(OldBuffer oldBuffer, boolean bl) {
        if (this.m_upgradeException != null) {
            throw this.m_upgradeException;
        }
        OldBuffer oldBuffer2 = new OldBuffer(256);
        OldUserTypeInfo oldUserTypeInfo = this.m_sourceTypeInfo;
        byte[] byArray = oldUserTypeInfo.getJumpCodes();
        int n = byArray.length;
        int[] nArray = new int[n + 1];
        if (bl) {
            for (int i = 0; i < n; ++i) {
                nArray[i] = oldBuffer.getPos();
                oldBuffer.jumpOnFieldValue(byArray[i]);
            }
        } else {
            OldTypeManager oldTypeManager = oldUserTypeInfo.getTypeManager();
            for (int i = 0; i < n; ++i) {
                nArray[i] = oldBuffer.getPos();
                if (byArray[i] != -4) {
                    oldBuffer.jumpOnFieldValue(byArray[i]);
                    continue;
                }
                oldTypeManager.skipElement(oldBuffer);
            }
        }
        nArray[n] = oldBuffer.getPos();
        Operation operation = this.m_operationList;
        while (operation != null) {
            operation.perform(oldBuffer, oldBuffer2, nArray);
            operation = operation.m_next;
        }
        return oldBuffer2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Upgrade ").append(this.m_sourceTypeInfo.getClassName());
        stringBuffer.append(" #").append(this.m_sourceTypeInfo.getTypeId());
        stringBuffer.append("\r\n");
        Operation operation = this.m_operationList;
        while (operation != null) {
            stringBuffer.append(operation).append("\r\n");
            operation = operation.m_next;
        }
        return stringBuffer.toString();
    }

    static class CastingOperation
    extends Operation {
        int m_srcFieldIx;
        OldValue m_srcValue;
        OldValue m_tarValue;

        CastingOperation() {
        }

        static Operation construct(Operation operation, int n, int n2, int n3) {
            CastingOperation castingOperation = new CastingOperation();
            castingOperation.m_srcFieldIx = n;
            castingOperation.m_srcValue = OldValue.constructValue(n2);
            castingOperation.m_tarValue = OldValue.constructValue(n3);
            castingOperation.m_next = operation;
            return castingOperation;
        }

        @Override
        void perform(OldBuffer oldBuffer, OldBuffer oldBuffer2, int[] nArray) {
            oldBuffer.setPos(nArray[this.m_srcFieldIx]);
            this.m_srcValue.readFromBuffer(oldBuffer);
            this.m_tarValue.upgrade(this.m_srcValue, oldBuffer2);
        }

        public String toString() {
            return "CastingOperation: SrcField# " + this.m_srcFieldIx + " " + this.m_srcValue.getTypeCode() + " -> " + this.m_tarValue.getTypeCode();
        }
    }

    static class CopyOperation
    extends Operation {
        int m_fromSrcFieldIx;
        int m_toSrcFieldIx;

        CopyOperation() {
        }

        static Operation construct(Operation operation, int n) {
            CopyOperation copyOperation;
            if (operation instanceof CopyOperation) {
                copyOperation = (CopyOperation)operation;
                if (copyOperation.m_fromSrcFieldIx == n) {
                    --copyOperation.m_fromSrcFieldIx;
                    return copyOperation;
                }
            }
            copyOperation = new CopyOperation();
            copyOperation.m_fromSrcFieldIx = n;
            copyOperation.m_toSrcFieldIx = n + 1;
            copyOperation.m_next = operation;
            return copyOperation;
        }

        @Override
        void perform(OldBuffer oldBuffer, OldBuffer oldBuffer2, int[] nArray) {
            int n = nArray[this.m_fromSrcFieldIx];
            int n2 = nArray[this.m_toSrcFieldIx] - n;
            oldBuffer2.writeByteArray(oldBuffer.getData(), n, n2);
        }

        public String toString() {
            return "CopyOperation: SrcField #" + this.m_fromSrcFieldIx + " -> SrcField #" + this.m_toSrcFieldIx;
        }
    }

    static class ResetOperation
    extends Operation {
        int m_byteCount;

        ResetOperation() {
        }

        static Operation construct(Operation operation, int n) {
            if (operation instanceof ResetOperation) {
                ((ResetOperation)operation).m_byteCount += n;
                return operation;
            }
            ResetOperation resetOperation = new ResetOperation();
            resetOperation.m_byteCount = n;
            resetOperation.m_next = operation;
            return resetOperation;
        }

        @Override
        void perform(OldBuffer oldBuffer, OldBuffer oldBuffer2, int[] nArray) {
            int n = this.m_byteCount;
            while (n-- > 0) {
                oldBuffer2.writeByte(0);
            }
        }

        public String toString() {
            return "ResetOperation: " + this.m_byteCount + " bytes";
        }
    }

    static abstract class Operation {
        Operation m_next;

        Operation() {
        }

        abstract void perform(OldBuffer var1, OldBuffer var2, int[] var3);
    }
}

