/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.conv1.common;

import com.objectdb.conv1.common.OldTypeCodes;

public class OldUtils
implements OldTypeCodes {
    public static int forName(String string, boolean bl) {
        if (bl) {
            boolean bl2 = false;
            if (string.startsWith("java.lang.") || string.startsWith("java/lang/")) {
                string = string.substring(10);
                bl2 = true;
            }
            if ("Integer".equals(string)) {
                return 4;
            }
            if ("Long".equals(string)) {
                return 5;
            }
            if ("Float".equals(string)) {
                return 6;
            }
            if ("Double".equals(string)) {
                return 7;
            }
            if ("Boolean".equals(string)) {
                return 12;
            }
            if ("Byte".equals(string)) {
                return 1;
            }
            if ("Character".equals(string)) {
                return 2;
            }
            if ("Short".equals(string)) {
                return 3;
            }
            if (bl2) {
                return 0;
            }
        }
        if ("int".equals(string)) {
            return 4;
        }
        if ("long".equals(string)) {
            return 5;
        }
        if ("float".equals(string)) {
            return 6;
        }
        if ("double".equals(string)) {
            return 7;
        }
        if ("boolean".equals(string)) {
            return 12;
        }
        if ("byte".equals(string)) {
            return 1;
        }
        if ("char".equals(string)) {
            return 2;
        }
        if ("short".equals(string)) {
            return 3;
        }
        return 0;
    }

    public static int getTypeCode(String string) {
        int n = OldUtils.forName(string, true);
        if (n != 0) {
            return n;
        }
        if ("java.lang.String".equals(string)) {
            return 10;
        }
        if ("java.util.Date".equals(string)) {
            return 11;
        }
        if ("java.math.BigInteger".equals(string)) {
            return 8;
        }
        if ("java.math.BigDecimal".equals(string)) {
            return 9;
        }
        return 13;
    }

    public static Class getPrimitiveClass(int n) {
        switch (n) {
            case 1: {
                return Byte.TYPE;
            }
            case 2: {
                return Character.TYPE;
            }
            case 3: {
                return Short.TYPE;
            }
            case 4: {
                return Integer.TYPE;
            }
            case 5: {
                return Long.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 7: {
                return Double.TYPE;
            }
            case 12: {
                return Boolean.TYPE;
            }
        }
        throw new RuntimeException("Internal Exception");
    }

    public static Class getWrapperClass(int n) {
        switch (n) {
            case 1: {
                return Byte.class;
            }
            case 2: {
                return Character.class;
            }
            case 3: {
                return Short.class;
            }
            case 4: {
                return Integer.class;
            }
            case 5: {
                return Long.class;
            }
            case 6: {
                return Float.class;
            }
            case 7: {
                return Double.class;
            }
            case 12: {
                return Boolean.class;
            }
        }
        throw new RuntimeException("Internal Exception");
    }

    public static char getPrimitiveChar(int n) {
        switch (n) {
            case 1: {
                return 'B';
            }
            case 2: {
                return 'C';
            }
            case 3: {
                return 'S';
            }
            case 4: {
                return 'I';
            }
            case 5: {
                return 'J';
            }
            case 6: {
                return 'F';
            }
            case 7: {
                return 'D';
            }
            case 12: {
                return 'Z';
            }
        }
        throw new RuntimeException("Internal Exception");
    }

    public static int getSize(int n) {
        switch (n) {
            case 1: 
            case 12: {
                return 1;
            }
            case 2: 
            case 3: {
                return 2;
            }
            case 4: 
            case 5: {
                return 0;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 8;
            }
        }
        throw new RuntimeException("Internal Exception");
    }
}

