/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.conv1.value;

import com.objectdb.conv1.common.OldBuffer;
import com.objectdb.conv1.value.OldValue;

public final class OldStringValue
extends OldValue {
    private String m_value;
    private int m_size;
    private char[] m_valueAsArray = new char[256];
    private int m_valueLength;

    public int getTypeCode() {
        return 10;
    }

    public void set(Object object) {
        this.m_value = (String)object;
        this.m_size = -1;
        this.m_valueLength = -1;
    }

    public Object get() {
        return this.m_value;
    }

    public boolean isNull() {
        return this.m_value == null;
    }

    public void writeIndexKey(OldBuffer oldBuffer) {
        oldBuffer.writeString(this.m_value);
    }

    public void readIndexKey(OldBuffer oldBuffer) {
        this.readFromBuffer(oldBuffer);
    }

    public void skipIndexKey(OldBuffer oldBuffer) {
        oldBuffer.skipString();
    }

    public int getSize() {
        if (this.m_size < 0) {
            this.m_size = OldBuffer.getStorageSizeOfString(this.m_value);
        }
        return this.m_size;
    }

    public int compare(OldBuffer oldBuffer) {
        int n;
        int n2 = oldBuffer.readCompressedUInt();
        if (this.m_value == null) {
            return n2 == 0 ? 0 : -1;
        }
        if (n2 == 0) {
            return 1;
        }
        if (n2 == 1) {
            return this.m_value.length() == 0 ? 0 : 1;
        }
        if (this.m_valueLength < 0) {
            this.prepareCharArray();
        }
        char[] cArray = this.m_valueAsArray;
        int n3 = this.m_valueLength;
        if ((n2 & 1) == 0) {
            int n4 = oldBuffer.getPos();
            n = OldStringValue.compare(cArray, n3, oldBuffer.getData(), n4, n2 >>= 1);
            oldBuffer.setPos(n4 + n2);
        } else {
            char[] cArray2 = oldBuffer.readUTF(n2 >>= 1);
            n = OldStringValue.compare(cArray, n3, cArray2, cArray2.length);
        }
        return n;
    }

    private static int compare(char[] cArray, int n, char[] cArray2, int n2) {
        int n3 = n < n2 ? n : n2;
        for (int i = 0; i < n3; ++i) {
            int n4 = (cArray[i] & 0xFFFF) - (cArray2[i] & 0xFFFF);
            if (n4 == 0) continue;
            return n4;
        }
        return n - n2;
    }

    private static int compare(char[] cArray, int n, byte[] byArray, int n2, int n3) {
        int n4 = n < n3 ? n : n3;
        for (int i = 0; i < n4; ++i) {
            int n5 = (cArray[i] & 0xFFFF) - (byArray[n2 + i] & 0xFF);
            if (n5 == 0) continue;
            return n5;
        }
        return n - n3;
    }

    private void prepareCharArray() {
        if (this.m_value != null) {
            this.m_valueLength = this.m_value.length();
            if (this.m_valueLength > this.m_valueAsArray.length) {
                this.m_valueAsArray = new char[this.m_valueLength];
            }
            this.m_value.getChars(0, this.m_valueLength, this.m_valueAsArray, 0);
        }
    }

    public void readFromBuffer(OldBuffer oldBuffer) {
        int n = oldBuffer.getPos();
        this.m_value = oldBuffer.readString();
        this.m_size = oldBuffer.getPos() - n;
        this.m_valueLength = -1;
    }
}

