/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb;

import com.objectdb.o.ALS;
import com.objectdb.o.BYW;
import com.objectdb.o.CFG;
import com.objectdb.o.InternalException;
import com.objectdb.o.LFL;
import com.objectdb.o.MSS;
import com.objectdb.o.NTC;
import com.objectdb.o.OsHelper;
import com.objectdb.o.SMR;
import com.objectdb.o.SSL;
import com.objectdb.o.STH;
import com.objectdb.o.SYH;
import com.objectdb.o.UserException;
import com.objectdb.o.XMN;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;

public final class Server {
    private String m_configPath;
    private CFG m_config;
    private int m_port = -1;
    private boolean m_silent;
    private boolean m_console;
    private final ALS m_commands = new ALS(4);

    public static void main(String ... stringArray) {
        new Server().run(stringArray, false);
    }

    void run(String[] stringArray, boolean bl) {
        try {
            this.parseArgs(stringArray);
            if (this.m_commands.m() && !bl) {
                Server.printUsageMessage();
                return;
            }
            if (this.m_commands.l() > 1) {
                throw new IllegalArgumentException("Server command conflict: " + this.m_commands);
            }
            this.m_config = CFG.ae(this.m_configPath);
            if (this.m_port < 0) {
                XMN xMN = this.m_config.av().x("server", "connection");
                this.m_port = xMN.D("port");
            }
            if (this.m_commands.m()) {
                this.runCommand("run", stringArray);
            } else {
                this.runCommand((String)this.m_commands.n(0), stringArray);
            }
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void parseArgs(String[] stringArray) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2].toLowerCase();
            if (string.equalsIgnoreCase("run") || string.equalsIgnoreCase("start") || string.equalsIgnoreCase("stop") || string.equalsIgnoreCase("restart") || string.equalsIgnoreCase("dump")) {
                this.m_commands.c(string);
                continue;
            }
            if (string.equals("-conf")) {
                if (++i2 >= stringArray.length) {
                    throw MSS.u.d("<path> is missing in -conf <path>");
                }
                this.m_configPath = stringArray[i2];
                if (new LFL(this.m_configPath).b()) continue;
                throw MSS.u.d("Configuration is not found at '" + stringArray[i2] + "'");
            }
            if (string.equals("-port")) {
                if (++i2 >= stringArray.length) {
                    throw MSS.u.d("<port> is missing in -port <port>");
                }
                try {
                    this.m_port = Integer.parseInt(stringArray[i2]);
                    if (this.m_port >= 0) continue;
                    throw new NumberFormatException();
                }
                catch (NumberFormatException numberFormatException) {
                    throw MSS.u.d("Invalid server port (" + stringArray[i2] + ")");
                }
            }
            if (string.equalsIgnoreCase("-silent")) {
                this.m_silent = true;
                continue;
            }
            if (string.equalsIgnoreCase("-console")) {
                this.m_console = true;
                continue;
            }
            throw MSS.u.d("Unknown server command or argument: " + string);
        }
    }

    private void runCommand(String string, String[] stringArray) throws Exception {
        if ("run".equalsIgnoreCase(string)) {
            new SMR(this.m_config, this.m_port, null, this.m_silent, this.m_console).run();
        } else if ("start".equalsIgnoreCase(string)) {
            new SMR(this.m_config, this.m_port, null, this.m_silent, this.m_console).run();
        } else if ("restart".equalsIgnoreCase(string)) {
            if (this.m_silent) {
                this.sendSocketCommand(14);
            } else {
                this.sendSocketCommand(13);
                STH.F("ObjectDB Server restarted.");
            }
        } else if ("stop".equalsIgnoreCase(string)) {
            if (this.m_silent) {
                this.sendSocketCommand(12);
            } else {
                this.sendSocketCommand(11);
                STH.F("ObjectDB Server stopped.");
            }
        } else if ("dump".equalsIgnoreCase(string)) {
            this.sendSocketCommand(16);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSocketCommand(int n2) throws IOException {
        try {
            Socket socket;
            try {
                socket = this.newSocket(InetAddress.getLocalHost(), this.m_port);
            }
            catch (UnknownHostException unknownHostException) {
                try {
                    socket = this.newSocket("localhost", this.m_port);
                }
                catch (UnknownHostException unknownHostException2) {
                    socket = this.newSocket("127.0.0.1", this.m_port);
                }
            }
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            try {
                outputStream.write(NTC.a);
                outputStream.write(n2);
                outputStream.flush();
                int n3 = inputStream.read();
                if (n3 == 1) {
                    String string = new DataInputStream(inputStream).readUTF();
                    System.out.println(string);
                } else if (n3 != 0) {
                    throw new InternalException(String.valueOf(n3));
                }
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                socket.close();
                inputStream.close();
                outputStream.close();
                throw throwable;
            }
            socket.close();
            inputStream.close();
            outputStream.close();
            {
            }
        }
        catch (ConnectException connectException) {
            throw MSS.o.d(connectException, "127.0.0.1", String.valueOf(this.m_port), connectException.getMessage());
        }
    }

    private Socket newSocket(InetAddress inetAddress, int n2) throws IOException {
        SSL sSL = this.m_config.ab;
        if (sSL != null) {
            try {
                return sSL.i(inetAddress, n2);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new IOException(generalSecurityException);
            }
        }
        return new Socket(inetAddress, n2);
    }

    private Socket newSocket(String string, int n2) throws IOException {
        SSL sSL = this.m_config.ab;
        if (sSL != null) {
            try {
                return sSL.i(string, n2);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new IOException(generalSecurityException);
            }
        }
        return new Socket(string, n2);
    }

    private static void printUsageMessage() {
        SYH.w("ObjectDB Server");
        StringBuilder stringBuilder = new StringBuilder(1024);
        stringBuilder.append(BYW.k);
        stringBuilder.append("Usage: java com.objectdb.Server ");
        stringBuilder.append("[options] start | stop | restart");
        stringBuilder.append(BYW.k);
        stringBuilder.append("options include:").append(BYW.k);
        stringBuilder.append("  -conf <path>  :  ");
        stringBuilder.append("specify a configuration file explicitly");
        stringBuilder.append(BYW.k);
        stringBuilder.append("  -port <port>  :  ");
        stringBuilder.append("override configuration's server port");
        stringBuilder.append(BYW.k);
        stringBuilder.append("  -silent       :  ");
        stringBuilder.append("avoid printing messages to the standard output");
        stringBuilder.append(BYW.k);
        stringBuilder.append("  -console       :  ");
        stringBuilder.append("avoid showing the server tray icon");
        STH.F(stringBuilder.toString());
    }

    private void handleException(Throwable throwable) {
        if (this.m_config == null) {
            this.m_config = CFG.ae(null);
        }
        this.m_config.aA("server").g(throwable);
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append(SYH.k);
        stringBuilder.append(BYW.k);
        stringBuilder.append(throwable.getMessage());
        if (throwable instanceof UserException) {
            stringBuilder.append(" (error ").append(((UserException)throwable).l()).append(")");
        }
        stringBuilder.append(BYW.k);
        STH.L(stringBuilder.toString());
        OsHelper.u(throwable.getMessage());
        System.exit(1);
    }
}

