/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.conv;

import com.objectdb.conv1.common.OldBuffer;
import com.objectdb.conv1.store.OldClassInfo;
import com.objectdb.conv1.store.OldDataMultiPage;
import com.objectdb.conv1.store.OldDataSinglePage;
import com.objectdb.conv1.store.OldDataStore;
import com.objectdb.conv1.store.OldMainStoreMgr;
import com.objectdb.conv1.store.OldMapperPage;
import com.objectdb.conv1.store.OldPage;
import com.objectdb.conv1.type.OldTypeInfo;
import com.objectdb.conv1.type.OldTypeManager;
import com.objectdb.conv1.type.OldUserTypeInfo;
import com.objectdb.o.ALS;
import com.objectdb.o.CFG;
import com.objectdb.o.EVC;
import com.objectdb.o.HMP;
import com.objectdb.o.HTI;
import com.objectdb.o.IOM;
import com.objectdb.o.JPE;
import com.objectdb.o.LGR;
import com.objectdb.o.MST;
import com.objectdb.o.PRU;
import com.objectdb.o.QRM;
import com.objectdb.o.RFV;
import com.objectdb.o.SCM;
import com.objectdb.o.SLV;
import com.objectdb.o.STV;
import com.objectdb.o.TDF;
import com.objectdb.o.TYD;
import com.objectdb.o.TYM;
import com.objectdb.o.TYW;
import com.objectdb.o.UNI;
import com.objectdb.o.VLS;
import com.objectdb.spi.OType;

public final class ConvertManager
extends ClassLoader {
    OldMainStoreMgr m_oldStore;
    OldTypeManager m_oldTypeManager;
    HMP m_cachedTypeMap = new HMP(19, 0.5f);
    MST m_newStore;
    TYM m_newTypeManager;
    HMP m_typeNameToIdMap = new HMP(101, 0.5f);
    IOM m_oldToNewTypeIdMap = new IOM(301, 0.5f);
    EVC m_updateCollector;
    long m_maxObjectId;
    TYW m_writer;
    String m_currentTypeName;
    long m_currentObjectId;
    ALS m_currentPathStack = new ALS(4);
    HMP m_brokenRefMap = new HMP(11, 0.5f);
    final CFG m_config = CFG.f(null);
    final LGR m_logger = this.m_config.i().b();

    public static void main(String[] stringArray) {
        if (stringArray.length < 2 || stringArray.length > 3 || stringArray.length == 3 && !"verify".equals(stringArray[2])) {
            System.err.println("Usage: java -jar Converter.jar <old-db-file> <new-db-file>");
            System.exit(1);
        }
        new ConvertManager().run(stringArray);
    }

    void run(String[] stringArray) {
        System.out.println("ObjectDB 1.0 -> 2.0 file conversion");
        long l = System.currentTimeMillis();
        this.m_oldStore = new OldMainStoreMgr(stringArray[0], stringArray[0], null, false, false, true);
        this.m_oldTypeManager = this.m_oldStore.getTypeManager();
        this.m_newStore = MST.ap(this.m_config, QRM.c, stringArray[1], 2);
        SCM sCM = new SCM(this.m_config, UNI.a, this);
        TYM tYM = new TYM(this.m_newStore, this, sCM, UNI.a, null, new JPE(this.m_config), false);
        this.m_newStore.aD(tYM);
        this.m_newTypeManager = this.m_newStore.YJ();
        this.m_writer = new TYW(this.m_newTypeManager, false);
        this.convertAllTypes();
        this.convertAllObjects();
        this.convertRoots();
        TYD tYD = this.m_newStore.ZC(0);
        long l2 = this.m_maxObjectId;
        int[] nArray = new int[]{22, (int)(l2 & 0xFFFFFFFFFFFFFFFFL), 23, (int)(l2 >> 32)};
        this.m_newStore.ZB(null, true, null, null, nArray, tYD.f(), true);
        this.m_newStore.ZS();
        this.m_oldStore.close();
        long l3 = System.currentTimeMillis();
        int n = (int)((l3 - l) / 1000L);
        System.out.print("File has been converted successfully");
        System.out.println(" (Time: " + n + " seconds)");
        System.out.flush();
        System.out.flush();
        if (!this.m_brokenRefMap.j()) {
            this.reoprtBrokenRefs();
        }
    }

    void commitUpdates() {
        VLS vLS = this.m_updateCollector.g();
        try {
            this.m_newStore.Zh(null, vLS, -1L);
        }
        finally {
            vLS.Z8();
            this.m_updateCollector.Z8();
            this.m_updateCollector = new EVC(this.m_config, this.m_newStore.ZE(), "Converter1_");
        }
    }

    void convertAllTypes() {
        OldClassInfo[] oldClassInfoArray = this.m_oldStore.getClassManager().getAllClassInfo();
        int n = oldClassInfoArray.length;
        for (int i = 0; i < n; ++i) {
            this.m_typeNameToIdMap.u(oldClassInfoArray[i].getClassName(), i + 1);
        }
        for (OldClassInfo oldClassInfo : oldClassInfoArray) {
            String string = oldClassInfo.getClassName();
            try {
                Class<?> clazz = this.loadClass(string);
                this.m_newTypeManager.S(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException("Cannot build class " + string);
            }
        }
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        Class clazz = (Class)this.m_cachedTypeMap.t(string);
        if (clazz != null) {
            return clazz;
        }
        OldClassInfo oldClassInfo = this.m_oldStore.getClassManager().getClassInfo(string);
        if (oldClassInfo == null) {
            throw new ClassNotFoundException(string);
        }
        boolean bl = oldClassInfo.getObjectCount() > 0L || oldClassInfo.m_exclusiveIndexInfo != null;
        int n = oldClassInfo.getLastVersionTypeId();
        OldUserTypeInfo oldUserTypeInfo = (OldUserTypeInfo)this.m_oldTypeManager.getTypeInfo(n << 4, true);
        TDF tDF = oldUserTypeInfo.convertType(bl, this);
        if (tDF.u() != null) {
            this.loadClass(tDF.u());
        }
        clazz = this.m_newTypeManager.b(string, tDF, false);
        this.m_cachedTypeMap.u(string, clazz);
        this.m_newTypeManager.v().p(clazz, tDF);
        return clazz;
    }

    public TYM getNewTypeManager() {
        return this.m_newTypeManager;
    }

    public OType getNewType(String string) {
        return this.m_newTypeManager.Q(string);
    }

    int getNewObjectTypeId(int n, long l) {
        return this.getNewObjectTypeId(l);
    }

    int getNewObjectTypeId(long l) {
        OldBuffer oldBuffer = this.retrieveOldObject(l);
        if (oldBuffer == null) {
            return 0;
        }
        int n = oldBuffer.readType();
        int n2 = this.getNewTypeId(n);
        return n2;
    }

    public int getNewTypeId(int n) {
        Integer n2 = (Integer)this.m_oldToNewTypeIdMap.s(n);
        if (n2 == null) {
            OldTypeInfo oldTypeInfo = this.m_oldTypeManager.getTypeInfo(n);
            String string = oldTypeInfo.getClassName();
            OType oType = this.m_newTypeManager.Q(string);
            n2 = oType.getId();
            this.m_oldToNewTypeIdMap.t(n, n2);
        }
        return n2;
    }

    void convertAllObjects() {
        this.m_updateCollector = new EVC(this.m_config, this.m_newStore.ZE(), "Converter2_");
        OldDataStore oldDataStore = this.m_oldStore.getDataStore();
        int n = oldDataStore.getPageCount();
        for (int i = 1; i < n; ++i) {
            OldPage oldPage;
            if (i > 0 && i % 2048 == 0) {
                this.m_newStore.N(i / 2);
                this.commitUpdates();
            }
            if (!oldDataStore.isAllocatedPageId(i) || (oldPage = oldDataStore.openPage(i)) == null) continue;
            int n2 = oldPage.getPageType();
            if (n2 == 8) {
                ((OldDataSinglePage)oldPage).convertObjects(this, this.m_oldTypeManager);
                continue;
            }
            if (n2 != 9) continue;
            ((OldDataMultiPage)oldPage).convertObjects(this, this.m_oldTypeManager);
        }
        long l = 1024L;
        System.out.println(" " + (long)n / l + "MB (total)");
        this.commitUpdates();
    }

    public void convertObject(long l, OldTypeInfo oldTypeInfo, OldBuffer oldBuffer) {
        if (!(oldTypeInfo instanceof OldUserTypeInfo)) {
            return;
        }
        this.m_currentTypeName = oldTypeInfo.getClassName();
        this.m_currentObjectId = l;
        this.m_currentPathStack.d();
        this.m_maxObjectId = Math.max(l, this.m_maxObjectId);
        int n = this.getNewObjectTypeId(oldTypeInfo.getTypeIdAndDim(), l);
        this.m_writer.g(0);
        this.m_writer.u(0);
        this.m_writer.u(0);
        oldTypeInfo.convertObject(oldBuffer, true, this, this.m_writer);
        OldMapperPage oldMapperPage = this.m_oldStore.getObjectMapper();
        try {
            oldMapperPage.getLocation(l);
        }
        catch (RuntimeException runtimeException) {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append("Unexpected object ");
            stringBuffer.append(this.m_currentTypeName);
            stringBuffer.append('#').append(this.m_currentObjectId);
            this.m_logger.e(stringBuffer.toString());
            return;
        }
        PRU pRU = new PRU(1, new SLV(l), 1L, this.m_writer.s());
        this.m_updateCollector.e(n, pRU, false);
    }

    public void convertElement(OldBuffer oldBuffer, boolean bl, TYW tYW) {
        int n;
        if (bl) {
            n = oldBuffer.analyzeFieldHeader();
            if (n == 0) {
                tYW.u(0);
                return;
            }
            if (n < 0) {
                long l = oldBuffer.readCompressedULong2();
                int n2 = this.getNewObjectTypeId(l);
                this.writeRef(n2, l, tYW);
                return;
            }
        }
        byte by = oldBuffer.readByte();
        n = by;
        if (by >= 0) {
            if (n == 0) {
                tYW.u(0);
            } else {
                int n3 = oldBuffer.readType(n);
                long l = oldBuffer.readCompressedULong2();
                int n4 = this.getNewObjectTypeId(n3, l);
                this.writeRef(n4, l, tYW);
            }
        } else {
            int n5 = oldBuffer.readType(~n);
            OldTypeInfo oldTypeInfo = this.m_oldTypeManager.getTypeInfo(n5);
            oldTypeInfo.convertObject(oldBuffer, false, this, tYW);
        }
    }

    void writeRef(int n, long l, TYW tYW) {
        if (n == 0) {
            tYW.u(0);
        } else {
            OType oType = this.m_newTypeManager.y(n);
            if (oType.isEntity()) {
                RFV.ZJ(n, new SLV(l), tYW);
            } else {
                OldBuffer oldBuffer = this.retrieveOldObject(l);
                int n2 = oldBuffer.readType();
                OldTypeInfo oldTypeInfo = this.m_oldTypeManager.getTypeInfo(n2);
                oldTypeInfo.convertObject(oldBuffer, false, this, tYW);
            }
        }
    }

    OldBuffer retrieveOldObject(long l) {
        byte[] byArray;
        try {
            byArray = this.m_oldStore.retrieveObject(l);
        }
        catch (RuntimeException runtimeException) {
            byArray = null;
        }
        if (byArray == null) {
            this.collectBrokenReference(l);
            return null;
        }
        OldBuffer oldBuffer = new OldBuffer(byArray, 4);
        long l2 = oldBuffer.readCompressedULong2();
        if (l2 != l) {
            throw new RuntimeException("Unexpected object ID expected: " + l + ", actual: " + l2);
        }
        return oldBuffer;
    }

    void convertRoots() {
        for (String string : this.m_oldStore.getRootNames()) {
            byte[] byArray = this.m_oldStore.retrieveObject(string);
            OldBuffer oldBuffer = new OldBuffer(byArray, 4);
            long l = oldBuffer.readCompressedULong2();
            int n = oldBuffer.readType();
            int n2 = this.getNewTypeId(n);
            this.m_writer.g(0);
            RFV.ZJ(n2, new SLV(l), this.m_writer);
            PRU pRU = new PRU(1, new STV(string), 0L, this.m_writer.s());
            this.m_updateCollector.e(-2, pRU, false);
        }
        this.commitUpdates();
    }

    public void pushPath(String string) {
        this.m_currentPathStack.p(string);
    }

    public void popPath() {
        this.m_currentPathStack.r();
    }

    String getPath() {
        StringBuffer stringBuffer = new StringBuffer(32);
        int n = this.m_currentPathStack.j();
        for (int i = 0; i < n; ++i) {
            String string = (String)this.m_currentPathStack.g(i);
            if (i > 0 && string.charAt(0) != '#') {
                stringBuffer.append('.');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    void collectBrokenReference(long l) {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("Type ").append(this.m_currentTypeName);
        String string = this.getPath();
        stringBuffer.append(", field \"").append(string).append("\"");
        String string2 = stringBuffer.toString();
        Integer n = (Integer)this.m_brokenRefMap.t(string2);
        n = n == null ? Integer.valueOf(1) : Integer.valueOf(n + 1);
        this.m_brokenRefMap.u(string2, n);
        stringBuffer = new StringBuffer(64);
        stringBuffer.append("Broken ref: ");
        stringBuffer.append(string).append('@');
        stringBuffer.append(this.m_currentTypeName);
        stringBuffer.append('#').append(this.m_currentObjectId);
        stringBuffer.append(" -> ").append(l);
        this.m_logger.e(stringBuffer.toString());
    }

    void reoprtBrokenRefs() {
        HMP.f f2;
        System.out.println("Broken references have been found:");
        HTI hTI = new HTI(this.m_brokenRefMap);
        while ((f2 = (HMP.f)hTI.a()) != null) {
            int n = (Integer)f2._d;
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append("  ").append(f2._b);
            stringBuffer.append(" -> ").append(n).append(" broken reference");
            stringBuffer.append(n == 1 ? "" : "s");
            System.out.println(stringBuffer.toString());
        }
        System.out.println("More information can be found in the log");
        System.out.flush();
    }
}

