/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.conv1.type;

import com.objectdb.conv.ConvertManager;
import com.objectdb.conv1.common.OldBuffer;
import com.objectdb.conv1.type.OldTypeInfo;
import com.objectdb.conv1.type.OldTypeManager;
import com.objectdb.o.TYW;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class OldMathTypeInfo
extends OldTypeInfo {
    public OldMathTypeInfo(OldTypeManager oldTypeManager, String string, int n) {
        super(oldTypeManager, string, n);
    }

    @Override
    public int getTypeCode() {
        if (this.m_typeId == 16) {
            return 8;
        }
        return 9;
    }

    @Override
    public void skipElement(OldBuffer oldBuffer) {
        oldBuffer.skipByteArray();
        if (this.m_typeId == 17) {
            oldBuffer.skipCompressedInt();
        }
    }

    @Override
    public void convertObject(OldBuffer oldBuffer, boolean bl, ConvertManager convertManager, TYW tYW) {
        BigInteger bigInteger = new BigInteger(oldBuffer.readByteArray());
        if (this.m_typeId == 16) {
            tYW.writeBigIntValue(bigInteger);
        } else {
            BigDecimal bigDecimal = new BigDecimal(bigInteger, oldBuffer.readCompressedInt());
            tYW.writeDecimalValue(bigDecimal);
        }
    }
}

