/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.conv1.type;

import com.objectdb.conv1.common.OldBuffer;
import com.objectdb.conv1.common.OldIntToObjMap;
import com.objectdb.conv1.common.OldObjectRef;
import com.objectdb.conv1.common.OldTypeCodes;
import com.objectdb.conv1.common.OldUtils;
import com.objectdb.conv1.store.OldMainStoreMgr;
import com.objectdb.conv1.type.OldCollectionTypeInfo;
import com.objectdb.conv1.type.OldComponentTypeInfo;
import com.objectdb.conv1.type.OldDateTypeInfo;
import com.objectdb.conv1.type.OldLocaleTypeInfo;
import com.objectdb.conv1.type.OldMapTypeInfo;
import com.objectdb.conv1.type.OldMathTypeInfo;
import com.objectdb.conv1.type.OldPrimitiveTypeInfo;
import com.objectdb.conv1.type.OldStringTypeInfo;
import com.objectdb.conv1.type.OldTypeIds;
import com.objectdb.conv1.type.OldTypeInfo;
import com.objectdb.conv1.type.OldUserTypeInfo;
import com.objectdb.conv1.type.OldWrapperTypeInfo;
import java.util.HashMap;

public final class OldTypeManager
implements OldTypeIds,
OldTypeCodes {
    ClassLoader m_classLoader;
    ClassLoader m_tempClassLoader;
    OldMainStoreMgr m_storeManager;
    OldIntToObjMap m_typeIdToInfo = new OldIntToObjMap(101, 0.5f);
    HashMap m_classToInfo = new HashMap(101, 0.5f);
    HashMap m_nameToInfo = new HashMap(101, 0.5f);
    OldTypeInfo m_stringTypeInfo;
    OldTypeInfo m_utfStringTypeInfo;
    OldBuffer m_assistantBuffer = new OldBuffer();
    HashMap m_classCache = new HashMap(101);

    public OldTypeManager(OldMainStoreMgr oldMainStoreMgr, ClassLoader classLoader) {
        this.m_storeManager = oldMainStoreMgr;
        this.setClassLoader(classLoader);
        this.m_stringTypeInfo = new OldStringTypeInfo(this, 9);
        this.m_utfStringTypeInfo = new OldStringTypeInfo(this, 10);
    }

    public OldMainStoreMgr getStoreManager() {
        return this.m_storeManager;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.m_classLoader = classLoader;
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
    }

    public ClassLoader getClassLoader() {
        return this.m_classLoader;
    }

    public ClassLoader setTempClassLoader(ClassLoader classLoader) {
        ClassLoader classLoader2 = this.m_tempClassLoader;
        this.m_tempClassLoader = classLoader;
        return classLoader2;
    }

    public void resetTempContextClass() {
        this.m_tempClassLoader = null;
    }

    public Class loadPersistentClass(String string) {
        if (this.m_tempClassLoader != null) {
            try {
                return Class.forName(string, true, this.m_tempClassLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            return Class.forName(string, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return Class.forName(string, true, this.m_classLoader);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                try {
                    return Class.forName(string, true, this.getClass().getClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException3) {
                    return null;
                }
            }
        }
    }

    public void skipElement(OldBuffer oldBuffer) {
        byte by = oldBuffer.readByte();
        if (by >= 0) {
            if (by == 0) {
                return;
            }
            oldBuffer.readType(by);
            oldBuffer.skipCompressedUNum2();
        } else {
            int n;
            if (by == -1) {
                oldBuffer.skip(1);
            }
            if ((n = oldBuffer.readType(~by)) != 0) {
                this.getTypeInfo(n).skipElement(oldBuffer);
            }
        }
    }

    public OldTypeInfo getTypeInfo(int n) {
        return this.getTypeInfo(n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OldTypeInfo getTypeInfo(int n, boolean bl) {
        OldMainStoreMgr oldMainStoreMgr = this.m_storeManager;
        synchronized (oldMainStoreMgr) {
            OldTypeInfo oldTypeInfo = (OldTypeInfo)this.m_typeIdToInfo.get(n);
            if (oldTypeInfo != null) {
                return oldTypeInfo;
            }
            int n2 = n >> 4;
            int n3 = n & 0xF;
            if (n3 != 0) {
                return this.getTypeInfo(n - 1).getArrayTypeInfo();
            }
            if (OldTypeManager.isUserTypeId(n)) {
                byte[] byArray = this.m_storeManager.retrieveClassVersion(n2);
                if (byArray == null) {
                    throw new RuntimeException("Class scheme #" + n2 + " cannot be found.");
                }
                OldBuffer oldBuffer = new OldBuffer(byArray, 0);
                oldTypeInfo = new OldUserTypeInfo(oldBuffer, this, bl);
            } else {
                oldTypeInfo = this.createSystemTypeInfo(n2);
                if (oldTypeInfo == null) {
                    System.out.println("Failed to convert type " + n2);
                    throw new RuntimeException();
                }
            }
            this.keepTypeInCache(oldTypeInfo);
            return oldTypeInfo;
        }
    }

    public OldTypeInfo getTypeInfoByObj(Object object) {
        if (object instanceof String) {
            if (OldBuffer.isAsciiString((String)object)) {
                return this.m_stringTypeInfo;
            }
            return this.m_utfStringTypeInfo;
        }
        return this.getTypeInfo(object.getClass(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OldTypeInfo getTypeInfo(Class clazz, boolean bl) {
        OldMainStoreMgr oldMainStoreMgr = this.m_storeManager;
        synchronized (oldMainStoreMgr) {
            String string = clazz.getName();
            OldTypeInfo oldTypeInfo = (OldTypeInfo)this.m_classToInfo.get(clazz);
            if (oldTypeInfo != null) {
                return oldTypeInfo;
            }
            if (clazz.isArray()) {
                Class<?> clazz2 = clazz.getComponentType();
                OldTypeInfo oldTypeInfo2 = this.getTypeInfo(clazz2, bl);
                if (oldTypeInfo2 == null) {
                    oldTypeInfo2 = new OldComponentTypeInfo(this, clazz2, 0);
                    this.keepTypeInCache(oldTypeInfo2);
                    oldTypeInfo2.setTypeId(36);
                }
                return oldTypeInfo2.getArrayTypeInfo();
            }
            if (clazz.isPrimitive() || string.startsWith("java.")) {
                oldTypeInfo = this.createSystemTypeInfo(clazz, string);
                if (oldTypeInfo == null) {
                    return null;
                }
            } else {
                oldTypeInfo = this.loadUserTypeVersion(string);
                if (oldTypeInfo == null || !oldTypeInfo.isUpToDate()) {
                    throw new RuntimeException();
                }
            }
            this.keepTypeInCache(oldTypeInfo);
            return oldTypeInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OldTypeInfo getTypeInfo(String string, boolean bl) {
        OldMainStoreMgr oldMainStoreMgr = this.m_storeManager;
        synchronized (oldMainStoreMgr) {
            if (string.length() == 0) {
                return null;
            }
            OldTypeInfo oldTypeInfo = (OldTypeInfo)this.m_nameToInfo.get(string);
            if (oldTypeInfo != null) {
                return oldTypeInfo;
            }
            int n = OldUtils.forName(string, false);
            if (n != 0) {
                return this.getTypeInfo(OldUtils.getPrimitiveClass(n), bl);
            }
            Class clazz = this.findClass(string);
            if (clazz != null) {
                try {
                    return this.getTypeInfo(clazz, bl);
                }
                catch (RuntimeException runtimeException) {}
            } else {
                oldTypeInfo = this.loadUserTypeVersion(string);
                this.keepTypeInCache(oldTypeInfo);
                return oldTypeInfo;
            }
            return null;
        }
    }

    public OldUserTypeInfo getPersistentTypeInfo(String string) {
        OldTypeInfo oldTypeInfo = this.getTypeInfo(string, true);
        if (oldTypeInfo instanceof OldUserTypeInfo) {
            return (OldUserTypeInfo)oldTypeInfo;
        }
        return null;
    }

    OldUserTypeInfo loadUserTypeVersion(String string) {
        byte[] byArray = this.m_storeManager.retrieveClassVersion(string);
        if (byArray == null) {
            return null;
        }
        OldBuffer oldBuffer = new OldBuffer(byArray, 0);
        return new OldUserTypeInfo(oldBuffer, this, true);
    }

    public static boolean isUserTypeId(int n) {
        return n > 1039;
    }

    public OldUserTypeInfo isntallNewVersion(OldObjectRef oldObjectRef, byte[] byArray, int n) {
        byte[] byArray2 = new byte[byArray.length + 4];
        System.arraycopy(byArray, 0, byArray2, 4, byArray.length);
        byArray = byArray2;
        if (oldObjectRef instanceof OldUserTypeInfo) {
            OldUserTypeInfo oldUserTypeInfo = (OldUserTypeInfo)oldObjectRef;
            this.m_typeIdToInfo.put(oldUserTypeInfo.getTypeIdAndDim(), oldUserTypeInfo);
            return oldUserTypeInfo;
        }
        OldUserTypeInfo oldUserTypeInfo = new OldUserTypeInfo(this.m_assistantBuffer.set(byArray, n), this, true);
        oldUserTypeInfo.setTypeId((int)oldObjectRef.getObjectId());
        this.keepTypeInCache(oldUserTypeInfo);
        return oldUserTypeInfo;
    }

    void keepTypeInCache(OldTypeInfo oldTypeInfo) {
        if (oldTypeInfo.isUpToDate()) {
            this.m_nameToInfo.put(oldTypeInfo.getClassName(), oldTypeInfo);
            this.m_classToInfo.put(oldTypeInfo.getTypeClass(), oldTypeInfo);
        }
        if (oldTypeInfo.getTypeId() != 0) {
            this.m_typeIdToInfo.put(oldTypeInfo.getTypeIdAndDim(), oldTypeInfo);
        }
    }

    OldTypeInfo createSystemTypeInfo(int n) {
        switch (n) {
            case 18: {
                return new OldPrimitiveTypeInfo(this, 12, n);
            }
            case 19: {
                return new OldPrimitiveTypeInfo(this, 1, n);
            }
            case 20: {
                return new OldPrimitiveTypeInfo(this, 2, n);
            }
            case 21: {
                return new OldPrimitiveTypeInfo(this, 3, n);
            }
            case 22: {
                return new OldPrimitiveTypeInfo(this, 4, n);
            }
            case 23: {
                return new OldPrimitiveTypeInfo(this, 5, n);
            }
            case 24: {
                return new OldPrimitiveTypeInfo(this, 6, n);
            }
            case 25: {
                return new OldPrimitiveTypeInfo(this, 7, n);
            }
            case 1: {
                return new OldWrapperTypeInfo(this, 12, n);
            }
            case 2: {
                return new OldWrapperTypeInfo(this, 1, n);
            }
            case 3: {
                return new OldWrapperTypeInfo(this, 2, n);
            }
            case 4: {
                return new OldWrapperTypeInfo(this, 3, n);
            }
            case 5: {
                return new OldWrapperTypeInfo(this, 4, n);
            }
            case 6: {
                return new OldWrapperTypeInfo(this, 5, n);
            }
            case 7: {
                return new OldWrapperTypeInfo(this, 6, n);
            }
            case 8: {
                return new OldWrapperTypeInfo(this, 7, n);
            }
            case 9: {
                return this.m_stringTypeInfo;
            }
            case 10: {
                return this.m_utfStringTypeInfo;
            }
            case 11: {
                return new OldLocaleTypeInfo(this);
            }
            case 12: {
                return new OldDateTypeInfo(this, "java.util.Date", n);
            }
            case 13: {
                return new OldDateTypeInfo(this, "java.sql.Date", n);
            }
            case 14: {
                return new OldDateTypeInfo(this, "java.sql.Time", n);
            }
            case 15: {
                return new OldDateTypeInfo(this, "java.sql.Timestamp", n);
            }
            case 26: {
                return new OldCollectionTypeInfo(this, "java.util.Vector", n);
            }
            case 27: {
                return new OldCollectionTypeInfo(this, "java.util.ArrayList", n);
            }
            case 28: {
                return new OldCollectionTypeInfo(this, "java.util.LinkedList", n);
            }
            case 29: {
                return new OldCollectionTypeInfo(this, "java.util.HashSet", n);
            }
            case 30: {
                return new OldCollectionTypeInfo(this, "java.util.TreeSet", n);
            }
            case 31: {
                return new OldMapTypeInfo(this, "java.util.Hashtable", n);
            }
            case 32: {
                return new OldMapTypeInfo(this, "java.util.HashMap", n);
            }
            case 33: {
                return new OldMapTypeInfo(this, "java.util.TreeMap", n);
            }
            case 16: {
                return new OldMathTypeInfo(this, "java.math.BigInteger", n);
            }
            case 17: {
                return new OldMathTypeInfo(this, "java.math.BigDecimal", n);
            }
            case 36: {
                return new OldComponentTypeInfo(this, "java.lang.Object", n);
            }
        }
        return null;
    }

    OldTypeInfo createSystemTypeInfo(Class clazz, String string) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return this.createSystemTypeInfo(18);
            }
            if (clazz == Byte.TYPE) {
                return this.createSystemTypeInfo(19);
            }
            if (clazz == Character.TYPE) {
                return this.createSystemTypeInfo(20);
            }
            if (clazz == Short.TYPE) {
                return this.createSystemTypeInfo(21);
            }
            if (clazz == Integer.TYPE) {
                return this.createSystemTypeInfo(22);
            }
            if (clazz == Long.TYPE) {
                return this.createSystemTypeInfo(23);
            }
            if (clazz == Float.TYPE) {
                return this.createSystemTypeInfo(24);
            }
            if (clazz == Double.TYPE) {
                return this.createSystemTypeInfo(25);
            }
        } else if (string.startsWith("java.lang.")) {
            if (string.equals("java.lang.Boolean")) {
                return this.createSystemTypeInfo(1);
            }
            if (string.equals("java.lang.Byte")) {
                return this.createSystemTypeInfo(2);
            }
            if (string.equals("java.lang.Character")) {
                return this.createSystemTypeInfo(3);
            }
            if (string.equals("java.lang.Short")) {
                return this.createSystemTypeInfo(4);
            }
            if (string.equals("java.lang.Integer")) {
                return this.createSystemTypeInfo(5);
            }
            if (string.equals("java.lang.Long")) {
                return this.createSystemTypeInfo(6);
            }
            if (string.equals("java.lang.Float")) {
                return this.createSystemTypeInfo(7);
            }
            if (string.equals("java.lang.Double")) {
                return this.createSystemTypeInfo(8);
            }
            if (string.equals("java.lang.Object")) {
                return this.createSystemTypeInfo(36);
            }
            if (string.equals("java.lang.String")) {
                return this.createSystemTypeInfo(9);
            }
            if (string.equals("java.lang.Locale")) {
                return this.createSystemTypeInfo(11);
            }
        } else if (string.startsWith("java.util.")) {
            if (string.equals("java.util.Date")) {
                return this.createSystemTypeInfo(12);
            }
            if (string.equals("java.util.Locale")) {
                return this.createSystemTypeInfo(11);
            }
            if (string.equals("java.util.Vector")) {
                return this.createSystemTypeInfo(26);
            }
            if (string.equals("java.util.ArrayList") || string.equals("java.util.Arrays$ArrayList")) {
                return this.createSystemTypeInfo(27);
            }
            if (string.equals("java.util.LinkedList")) {
                return this.createSystemTypeInfo(28);
            }
            if (string.equals("java.util.HashSet")) {
                return this.createSystemTypeInfo(29);
            }
            if (string.equals("java.util.TreeSet")) {
                return this.createSystemTypeInfo(30);
            }
            if (string.equals("java.util.Hashtable")) {
                return this.createSystemTypeInfo(31);
            }
            if (string.equals("java.util.HashMap")) {
                return this.createSystemTypeInfo(32);
            }
            if (string.equals("java.util.TreeMap")) {
                return this.createSystemTypeInfo(33);
            }
        } else if (string.startsWith("java.math.")) {
            if (string.equals("java.math.BigInteger")) {
                return this.createSystemTypeInfo(16);
            }
            if (string.equals("java.math.BigDecimal")) {
                return this.createSystemTypeInfo(17);
            }
        } else if (string.startsWith("java.sql.")) {
            if (string.equals("java.sql.Date")) {
                return this.createSystemTypeInfo(13);
            }
            if (string.equals("java.sql.Time")) {
                return this.createSystemTypeInfo(14);
            }
            if (string.equals("java.sql.Timestamp")) {
                return this.createSystemTypeInfo(15);
            }
        }
        return null;
    }

    public Class findClass(String string) {
        Object v = this.m_classCache.get(string);
        if (v != null) {
            if (v instanceof Class) {
                return (Class)v;
            }
            return null;
        }
        try {
            Class<?> clazz = string.startsWith("java.") ? Class.forName(string, true, this.m_classLoader) : this.loadPersistentClass(string);
            this.m_classCache.put(string, clazz);
            return clazz;
        }
        catch (Throwable throwable) {
            this.m_classCache.put(string, string);
            return null;
        }
    }
}

