/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.conv1.type;

import com.objectdb.conv.ConvertManager;
import com.objectdb.conv1.common.OldBuffer;
import com.objectdb.conv1.common.OldUtils;
import com.objectdb.conv1.type.OldUserTypeInfo;
import com.objectdb.o.CTR;
import com.objectdb.o.MDF;
import com.objectdb.o.MTH;
import com.objectdb.o.MTR;
import com.objectdb.o.STR;
import com.objectdb.o.TRF;
import com.objectdb.o.UTR;
import com.objectdb.o.VUT;
import java.util.Collection;
import java.util.Map;

public final class OldUserFieldInfo {
    int m_fieldIndex;
    int m_newFieldIndex;
    String m_name;
    String m_typeName;
    int m_primitiveCode;
    byte m_flags;
    boolean m_isNullForbidden;
    Boolean m_embedded;
    Boolean m_elementEmbedded;
    Boolean m_keyEmbedded;

    OldUserFieldInfo(int n, OldBuffer oldBuffer, OldUserTypeInfo oldUserTypeInfo) {
        this.m_fieldIndex = n;
        this.readFromBuffer(oldBuffer);
    }

    public int getFieldIndex() {
        return this.m_fieldIndex;
    }

    public void setNewFieldIndex(int n) {
        this.m_newFieldIndex = n;
    }

    public int getNewFieldIndex() {
        return this.m_newFieldIndex;
    }

    public String getName() {
        return this.m_name;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public int getPrimitiveCode() {
        return this.m_primitiveCode;
    }

    public boolean isPersistent() {
        return this.m_flags != 4;
    }

    public boolean isPrimitiveOrString() {
        return this.m_primitiveCode != 0 || "java.lang.String".equals(this.m_typeName);
    }

    public boolean isInDefaultFetchGroup() {
        return this.m_flags == 5;
    }

    void readFromBuffer(OldBuffer oldBuffer) {
        this.m_name = oldBuffer.readString();
        this.m_typeName = oldBuffer.readString();
        oldBuffer.readString();
        oldBuffer.readString();
        this.m_flags = oldBuffer.readByte();
        this.setMiscFlags(oldBuffer.readInt());
        oldBuffer.skip(4);
    }

    void setMiscFlags(int n) {
        if ((n & 0x100) != 0) {
            this.m_primitiveCode = OldUtils.forName(this.m_typeName, false);
        }
        Boolean bl = (n & 0x400) != 0 ? null : (this.m_embedded = (n & 0x800) != 0 ? Boolean.TRUE : Boolean.FALSE);
        Boolean bl2 = (n & 0x1000) != 0 ? null : (this.m_elementEmbedded = (n & 0x2000) != 0 ? Boolean.TRUE : Boolean.FALSE);
        this.m_keyEmbedded = (n & 0x4000) != 0 ? null : ((n & 0x8000) != 0 ? Boolean.TRUE : Boolean.FALSE);
        this.m_isNullForbidden = (n & 1) != 0;
    }

    public MDF convert(ConvertManager convertManager) {
        TRF tRF;
        int n;
        int n2;
        block17: {
            String string;
            n2 = this.isPersistent() ? 3 : 5;
            n = 0;
            if (this.isInDefaultFetchGroup()) {
                n |= 0x10;
            }
            if (this.m_embedded != null) {
                n |= 0x100;
            } else {
                if (this.m_elementEmbedded != null) {
                    n |= 0x100;
                }
                if (this.m_keyEmbedded != null) {
                    n |= 0x200;
                }
            }
            if (this.m_isNullForbidden) {
                n |= 4;
            }
            if ((string = this.m_typeName).startsWith("[")) {
                tRF = TRF.b(Object.class);
            } else if (this.m_primitiveCode != 0) {
                Class clazz = OldUtils.getPrimitiveClass(this.m_primitiveCode);
                tRF = new STR(clazz, VUT.d(clazz));
            } else if (string.startsWith("java.")) {
                try {
                    Class<?> clazz = Class.forName(string);
                    if (Collection.class.isAssignableFrom(clazz)) {
                        int n3 = MTH.c(clazz);
                        tRF = new CTR(n3, null);
                        break block17;
                    }
                    if (Map.class.isAssignableFrom(clazz)) {
                        int n4 = MTH.c(clazz);
                        tRF = new MTR(n4, null, null);
                        break block17;
                    }
                    if (string.startsWith("java.lang.")) {
                        tRF = TRF.b(clazz);
                        break block17;
                    }
                    tRF = TRF.b(Object.class);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    tRF = TRF.b(Object.class);
                }
            } else {
                tRF = new UTR(string);
            }
        }
        return new MDF(this.getName(), tRF, n2, n, null, null);
    }
}

