/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo.identity;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jdo.identity.SingleFieldIdentity;

public class IntIdentity
extends SingleFieldIdentity {
    int key;

    void construct(int n2) {
        this.key = n2;
        this.hashCode = this.hashClassName() ^ n2;
    }

    public IntIdentity(Class clazz, int n2) {
        super(clazz);
        this.construct(n2);
    }

    public IntIdentity(Class clazz, Integer n2) {
        super(clazz);
        this.setKeyAsObject(n2);
        this.construct(n2);
    }

    public IntIdentity(Class clazz, String string) {
        super(clazz);
        this.assertKeyNotNull(string);
        this.construct(Integer.parseInt(string));
    }

    public IntIdentity() {
    }

    public int getKey() {
        return this.key;
    }

    public String toString() {
        return Integer.toString(this.key);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        IntIdentity intIdentity = (IntIdentity)object;
        return this.key == intIdentity.key;
    }

    public int compareTo(Object object) {
        if (object instanceof IntIdentity) {
            IntIdentity intIdentity = (IntIdentity)object;
            int n2 = super.compare(intIdentity);
            if (n2 == 0) {
                return this.key - intIdentity.key;
            }
            return n2;
        }
        if (object == null) {
            throw new ClassCastException("object is null");
        }
        throw new ClassCastException(this.getClass().getName() + " != " + object.getClass().getName());
    }

    @Override
    protected Object createKeyAsObject() {
        return this.key;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this.key);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.key = objectInput.readInt();
    }
}

