/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo.identity;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDONullIdentityException;
import javax.jdo.spi.I18NHelper;

public abstract class SingleFieldIdentity
implements Externalizable,
Comparable {
    protected static I18NHelper msg = I18NHelper.getInstance("javax.jdo.Bundle");
    transient Class targetClass;
    String targetClassName;
    protected int hashCode;
    protected Object keyAsObject;

    protected SingleFieldIdentity(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        this.targetClass = clazz;
        this.targetClassName = clazz.getName();
    }

    public SingleFieldIdentity() {
    }

    protected void setKeyAsObject(Object object) {
        this.assertKeyNotNull(object);
        this.keyAsObject = object;
    }

    protected void assertKeyNotNull(Object object) {
        if (object == null) {
            throw new JDONullIdentityException(msg.msg("EXC_SingleFieldIdentityNullParameter"));
        }
    }

    public Class getTargetClass() {
        return this.targetClass;
    }

    public String getTargetClassName() {
        return this.targetClassName;
    }

    public synchronized Object getKeyAsObject() {
        if (this.keyAsObject == null) {
            this.keyAsObject = this.createKeyAsObject();
        }
        return this.keyAsObject;
    }

    protected Object createKeyAsObject() {
        throw new JDOFatalInternalException(msg.msg("EXC_CreateKeyAsObjectMustNotBeCalled"));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SingleFieldIdentity singleFieldIdentity = (SingleFieldIdentity)object;
        if (this.targetClass != null && this.targetClass == singleFieldIdentity.targetClass) {
            return true;
        }
        return this.targetClassName.equals(singleFieldIdentity.targetClassName);
    }

    protected int hashClassName() {
        return this.targetClassName.hashCode();
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.targetClassName);
        objectOutput.writeInt(this.hashCode);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.targetClass = null;
        this.targetClassName = (String)objectInput.readObject();
        this.hashCode = objectInput.readInt();
    }

    protected int compare(SingleFieldIdentity singleFieldIdentity) {
        return this.targetClassName.compareTo(singleFieldIdentity.targetClassName);
    }
}

