/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo.spi;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOUserException;
import javax.jdo.LegacyJava;
import javax.jdo.spi.I18NHelper;
import javax.jdo.spi.JDOPermission;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.RegisterClassEvent;
import javax.jdo.spi.RegisterClassListener;
import javax.jdo.spi.StateInterrogation;
import javax.jdo.spi.StateManager;
import javax.xml.parsers.DocumentBuilderFactory;
import org.xml.sax.ErrorHandler;

public class JDOImplHelper {
    static Map<Class, Meta> registeredClasses = Collections.synchronizedMap(new HashMap());
    static final Map<Class, Class> authorizedStateManagerClasses = new WeakHashMap<Class, Class>();
    static final List<RegisterClassListener> listeners = new ArrayList<RegisterClassListener>();
    static List<StateInterrogation> stateInterrogations = new ArrayList<StateInterrogation>();
    static JDOImplHelper jdoImplHelper = new JDOImplHelper();
    static final I18NHelper msg = I18NHelper.getInstance("javax.jdo.Bundle");
    static String dateFormatPattern;
    static DateFormat dateFormat;
    static DocumentBuilderFactory documentBuilderFactory;
    static ErrorHandler errorHandler;
    public static final Set<String> USER_CONFIGURABLE_STANDARD_PROPERTIES;
    static final String JAVAX_JDO_PREFIX_LOWER_CASED;
    static final String PROPERTY_PREFIX_INSTANCE_LIFECYCLE_LISTENER_LOWER_CASED;
    static final Set<String> USER_CONFIGURABLE_STANDARD_PROPERTIES_LOWER_CASED;
    static final Map<Class, StringConstructor> stringConstructorMap;

    static Set<String> createUserConfigurableStandardProperties() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("javax.jdo.option.ConnectionDriverName");
        hashSet.add("javax.jdo.option.ConnectionFactory2Name");
        hashSet.add("javax.jdo.option.ConnectionFactoryName");
        hashSet.add("javax.jdo.option.ConnectionPassword");
        hashSet.add("javax.jdo.option.ConnectionURL");
        hashSet.add("javax.jdo.option.ConnectionUserName");
        hashSet.add("javax.jdo.option.CopyOnAttach");
        hashSet.add("javax.jdo.option.DatastoreReadTimeoutMillis");
        hashSet.add("javax.jdo.option.DatastoreWriteTimeoutMillis");
        hashSet.add("javax.jdo.option.DetachAllOnCommit");
        hashSet.add("javax.jdo.option.IgnoreCache");
        hashSet.add("javax.jdo.listener.InstanceLifecycleListener");
        hashSet.add("javax.jdo.option.Mapping");
        hashSet.add("javax.jdo.mapping.Catalog");
        hashSet.add("javax.jdo.mapping.Schema");
        hashSet.add("javax.jdo.option.Multithreaded");
        hashSet.add("javax.jdo.option.Name");
        hashSet.add("javax.jdo.option.NontransactionalRead");
        hashSet.add("javax.jdo.option.NontransactionalWrite");
        hashSet.add("javax.jdo.option.Optimistic");
        hashSet.add("javax.jdo.PersistenceManagerFactoryClass");
        hashSet.add("javax.jdo.option.PersistenceUnitName");
        hashSet.add("javax.jdo.option.ReadOnly");
        hashSet.add("javax.jdo.option.RestoreValues");
        hashSet.add("javax.jdo.option.RetainValues");
        hashSet.add("javax.jdo.option.ServerTimeZoneID");
        hashSet.add("javax.jdo.option.spi.ResourceName");
        hashSet.add("javax.jdo.option.TransactionIsolationLevel");
        hashSet.add("javax.jdo.option.TransactionType");
        return Collections.unmodifiableSet(hashSet);
    }

    static Set<String> createUserConfigurableStandardPropertiesLowerCased() {
        Set<String> set = JDOImplHelper.createUserConfigurableStandardProperties();
        HashSet<String> hashSet = new HashSet<String>(set.size());
        for (String string : set) {
            hashSet.add(string.toLowerCase());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    JDOImplHelper() {
    }

    public static JDOImplHelper getInstance() throws SecurityException {
        LegacyJava.SecurityManager securityManager = LegacyJava.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(JDOPermission.GET_METADATA);
        }
        return jdoImplHelper;
    }

    public String[] getFieldNames(Class clazz) {
        Meta meta = JDOImplHelper.getMeta(clazz);
        return meta.getFieldNames();
    }

    public Class[] getFieldTypes(Class clazz) {
        Meta meta = JDOImplHelper.getMeta(clazz);
        return meta.getFieldTypes();
    }

    public byte[] getFieldFlags(Class clazz) {
        Meta meta = JDOImplHelper.getMeta(clazz);
        return meta.getFieldFlags();
    }

    public Class getPersistenceCapableSuperclass(Class clazz) {
        Meta meta = JDOImplHelper.getMeta(clazz);
        return meta.getPersistenceCapableSuperclass();
    }

    public PersistenceCapable newInstance(Class clazz, StateManager stateManager) {
        Meta meta = JDOImplHelper.getMeta(clazz);
        PersistenceCapable persistenceCapable = meta.getPC();
        return persistenceCapable == null ? null : persistenceCapable.jdoNewInstance(stateManager);
    }

    public PersistenceCapable newInstance(Class clazz, StateManager stateManager, Object object) {
        Meta meta = JDOImplHelper.getMeta(clazz);
        PersistenceCapable persistenceCapable = meta.getPC();
        return persistenceCapable == null ? null : persistenceCapable.jdoNewInstance(stateManager, object);
    }

    public Object newObjectIdInstance(Class clazz) {
        Meta meta = JDOImplHelper.getMeta(clazz);
        PersistenceCapable persistenceCapable = meta.getPC();
        return persistenceCapable == null ? null : persistenceCapable.jdoNewObjectIdInstance();
    }

    public Object newObjectIdInstance(Class clazz, Object object) {
        Meta meta = JDOImplHelper.getMeta(clazz);
        PersistenceCapable persistenceCapable = meta.getPC();
        return persistenceCapable == null ? null : persistenceCapable.jdoNewObjectIdInstance(object);
    }

    public void copyKeyFieldsToObjectId(Class clazz, PersistenceCapable.ObjectIdFieldSupplier objectIdFieldSupplier, Object object) {
        Meta meta = JDOImplHelper.getMeta(clazz);
        PersistenceCapable persistenceCapable = meta.getPC();
        if (persistenceCapable == null) {
            throw new JDOFatalInternalException(msg.msg("ERR_AbstractClassNoIdentity", clazz.getName()));
        }
        persistenceCapable.jdoCopyKeyFieldsToObjectId(objectIdFieldSupplier, object);
    }

    public void copyKeyFieldsFromObjectId(Class clazz, PersistenceCapable.ObjectIdFieldConsumer objectIdFieldConsumer, Object object) {
        Meta meta = JDOImplHelper.getMeta(clazz);
        PersistenceCapable persistenceCapable = meta.getPC();
        if (persistenceCapable == null) {
            throw new JDOFatalInternalException(msg.msg("ERR_AbstractClassNoIdentity", clazz.getName()));
        }
        persistenceCapable.jdoCopyKeyFieldsFromObjectId(objectIdFieldConsumer, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerClass(Class clazz, String[] stringArray, Class[] classArray, byte[] byArray, Class clazz2, PersistenceCapable persistenceCapable) {
        if (clazz == null) {
            throw new NullPointerException(msg.msg("ERR_NullClass"));
        }
        Meta meta = new Meta(stringArray, classArray, byArray, clazz2, persistenceCapable);
        registeredClasses.put(clazz, meta);
        List<RegisterClassListener> list = listeners;
        synchronized (list) {
            if (!listeners.isEmpty()) {
                RegisterClassEvent registerClassEvent = new RegisterClassEvent(jdoImplHelper, clazz, stringArray, classArray, byArray, clazz2);
                for (RegisterClassListener registerClassListener : listeners) {
                    if (registerClassListener == null) continue;
                    registerClassListener.registerClass(registerClassEvent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterClasses(ClassLoader classLoader) {
        LegacyJava.SecurityManager securityManager = LegacyJava.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(JDOPermission.MANAGE_METADATA);
        }
        Map<Class, Meta> map = registeredClasses;
        synchronized (map) {
            Iterator<Class> iterator = registeredClasses.keySet().iterator();
            while (iterator.hasNext()) {
                Class clazz = iterator.next();
                if (clazz == null || clazz.getClassLoader() != classLoader) continue;
                iterator.remove();
            }
        }
    }

    public void unregisterClass(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException(msg.msg("ERR_NullClass"));
        }
        LegacyJava.SecurityManager securityManager = LegacyJava.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(JDOPermission.MANAGE_METADATA);
        }
        registeredClasses.remove(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRegisterClassListener(RegisterClassListener registerClassListener) {
        HashSet<Class> hashSet = null;
        List<RegisterClassListener> list = listeners;
        synchronized (list) {
            listeners.add(registerClassListener);
            hashSet = new HashSet<Class>(registeredClasses.keySet());
        }
        for (Class clazz : hashSet) {
            Meta meta = JDOImplHelper.getMeta(clazz);
            RegisterClassEvent registerClassEvent = new RegisterClassEvent(this, clazz, meta.getFieldNames(), meta.getFieldTypes(), meta.getFieldFlags(), meta.getPersistenceCapableSuperclass());
            registerClassListener.registerClass(registerClassEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRegisterClassListener(RegisterClassListener registerClassListener) {
        List<RegisterClassListener> list = listeners;
        synchronized (list) {
            listeners.remove(registerClassListener);
        }
    }

    public Collection<Class> getRegisteredClasses() {
        return Collections.unmodifiableCollection(registeredClasses.keySet());
    }

    static Meta getMeta(Class clazz) {
        Meta meta = registeredClasses.get(clazz);
        if (meta == null) {
            throw new JDOFatalUserException(msg.msg("ERR_NoMetadata", clazz.getName()));
        }
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerAuthorizedStateManagerClass(Class clazz) throws SecurityException {
        if (clazz == null) {
            throw new NullPointerException(msg.msg("ERR_NullClass"));
        }
        LegacyJava.SecurityManager securityManager = LegacyJava.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(JDOPermission.SET_STATE_MANAGER);
        }
        Map<Class, Class> map = authorizedStateManagerClasses;
        synchronized (map) {
            authorizedStateManagerClasses.put(clazz, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerAuthorizedStateManagerClasses(Collection collection) throws SecurityException {
        LegacyJava.SecurityManager securityManager = LegacyJava.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(JDOPermission.SET_STATE_MANAGER);
            Map<Class, Class> map = authorizedStateManagerClasses;
            synchronized (map) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Object e2 = iterator.next();
                    if (!(e2 instanceof Class)) {
                        throw new ClassCastException(msg.msg("ERR_StateManagerClassCast", e2.getClass().getName()));
                    }
                    JDOImplHelper.registerAuthorizedStateManagerClass((Class)iterator.next());
                }
            }
        }
    }

    public synchronized void registerDocumentBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        JDOImplHelper.documentBuilderFactory = documentBuilderFactory;
    }

    public static DocumentBuilderFactory getRegisteredDocumentBuilderFactory() {
        return documentBuilderFactory;
    }

    public synchronized void registerErrorHandler(ErrorHandler errorHandler) {
        JDOImplHelper.errorHandler = errorHandler;
    }

    public static ErrorHandler getRegisteredErrorHandler() {
        return errorHandler;
    }

    public static void checkAuthorizedStateManager(StateManager stateManager) {
        JDOImplHelper.checkAuthorizedStateManagerClass(stateManager.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkAuthorizedStateManagerClass(Class clazz) {
        LegacyJava.SecurityManager securityManager = LegacyJava.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        Map<Class, Class> map = authorizedStateManagerClasses;
        synchronized (map) {
            if (authorizedStateManagerClasses.containsKey(clazz)) {
                return;
            }
        }
        securityManager.checkPermission(JDOPermission.SET_STATE_MANAGER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object registerStringConstructor(Class clazz, StringConstructor stringConstructor) {
        Map<Class, StringConstructor> map = stringConstructorMap;
        synchronized (map) {
            return stringConstructorMap.put(clazz, stringConstructor);
        }
    }

    static Locale getLocale(String string) {
        String string2 = string;
        int n2 = string.indexOf(95);
        if (n2 == -1) {
            return new Locale(string2);
        }
        string2 = string.substring(0, n2);
        int n3 = string.indexOf(95, n2 + 1);
        if (n3 == -1) {
            String string3 = string.substring(n2 + 1);
            return new Locale(string2, string3);
        }
        String string4 = string.substring(n2 + 1, n3);
        String string5 = string.substring(n3 + 1);
        return new Locale(string2, string4, string5);
    }

    static boolean isClassLoadable(String string) {
        try {
            Class.forName(string);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object construct(String string, String string2) {
        try {
            StringConstructor stringConstructor;
            Class<?> clazz = Class.forName(string);
            Object object = stringConstructorMap;
            synchronized (object) {
                stringConstructor = stringConstructorMap.get(clazz);
            }
            if (stringConstructor != null) {
                return stringConstructor.construct(string2);
            }
            object = clazz.getConstructor(String.class);
            return ((Constructor)object).newInstance(string2);
        }
        catch (JDOException jDOException) {
            throw jDOException;
        }
        catch (Exception exception) {
            throw new JDOUserException(msg.msg("EXC_ObjectIdentityStringConstruction", new Object[]{exception.toString(), string, string2}), exception);
        }
    }

    static DateFormat getDateTimeInstance() {
        DateFormat dateFormat = null;
        try {
            dateFormat = JDOImplHelper.doPrivileged(new PrivilegedAction<DateFormat>(){

                @Override
                public DateFormat run() {
                    return DateFormat.getDateTimeInstance();
                }
            });
        }
        catch (Exception exception) {
            dateFormat = DateFormat.getInstance();
        }
        return dateFormat;
    }

    static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
        try {
            return (T)LegacyJava.doPrivilegedAction.invoke(null, privilegedAction);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            if (reflectiveOperationException.getCause() instanceof RuntimeException) {
                throw (RuntimeException)reflectiveOperationException.getCause();
            }
            throw new JDOFatalInternalException(reflectiveOperationException.getMessage());
        }
    }

    public synchronized void registerDateFormat(DateFormat dateFormat) {
        JDOImplHelper.dateFormat = dateFormat;
        dateFormatPattern = dateFormat instanceof SimpleDateFormat ? ((SimpleDateFormat)dateFormat).toPattern() : msg.msg("MSG_unknown");
    }

    public synchronized void addStateInterrogation(StateInterrogation stateInterrogation) {
        ArrayList<StateInterrogation> arrayList = new ArrayList<StateInterrogation>(stateInterrogations);
        arrayList.add(stateInterrogation);
        stateInterrogations = arrayList;
    }

    public synchronized void removeStateInterrogation(StateInterrogation stateInterrogation) {
        ArrayList<StateInterrogation> arrayList = new ArrayList<StateInterrogation>(stateInterrogations);
        arrayList.remove(stateInterrogation);
        stateInterrogations = arrayList;
    }

    synchronized Iterator getStateInterrogationIterator() {
        return stateInterrogations.iterator();
    }

    public void nonBinaryCompatibleMakeDirty(Object object, String string) {
        Iterator iterator = this.getStateInterrogationIterator();
        while (iterator.hasNext()) {
            StateInterrogation stateInterrogation = (StateInterrogation)iterator.next();
            try {
                if (!stateInterrogation.makeDirty(object, string)) continue;
                return;
            }
            catch (Throwable throwable) {
            }
        }
    }

    public boolean nonBinaryCompatibleIs(Object object, StateInterrogationBooleanReturn stateInterrogationBooleanReturn) {
        Iterator iterator = this.getStateInterrogationIterator();
        while (iterator.hasNext()) {
            Boolean bl;
            StateInterrogation stateInterrogation = (StateInterrogation)iterator.next();
            try {
                bl = stateInterrogationBooleanReturn.is(object, stateInterrogation);
            }
            catch (Throwable throwable) {
                continue;
            }
            if (bl == null) continue;
            return bl;
        }
        return false;
    }

    public Object nonBinaryCompatibleGet(Object object, StateInterrogationObjectReturn stateInterrogationObjectReturn) {
        Iterator iterator = this.getStateInterrogationIterator();
        while (iterator.hasNext()) {
            Object object2;
            StateInterrogation stateInterrogation = (StateInterrogation)iterator.next();
            try {
                object2 = stateInterrogationObjectReturn.get(object, stateInterrogation);
            }
            catch (Throwable throwable) {
                continue;
            }
            if (object2 == null) continue;
            return object2;
        }
        return null;
    }

    public static void assertOnlyKnownStandardProperties(Map<?, ?> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        ArrayList<JDOUserException> arrayList = new ArrayList<JDOUserException>();
        StringBuilder stringBuilder = new StringBuilder();
        for (Object obj : map.keySet()) {
            String string;
            if (!(obj instanceof String) || !(string = ((String)obj).toLowerCase()).startsWith(JAVAX_JDO_PREFIX_LOWER_CASED) || string.startsWith(PROPERTY_PREFIX_INSTANCE_LIFECYCLE_LISTENER_LOWER_CASED) || USER_CONFIGURABLE_STANDARD_PROPERTIES_LOWER_CASED.contains(string)) continue;
            arrayList.add(new JDOUserException(msg.msg("EXC_UnknownStandardProperty", string)));
            if (arrayList.size() > 1) {
                stringBuilder.append(",");
            }
            stringBuilder.append(string);
        }
        if (arrayList.size() == 1) {
            throw (JDOUserException)arrayList.get(0);
        }
        if (arrayList.size() > 1) {
            throw new JDOUserException(msg.msg("EXC_UnknownStandardProperties", stringBuilder.toString()), arrayList.toArray(new JDOUserException[0]));
        }
    }

    static {
        USER_CONFIGURABLE_STANDARD_PROPERTIES = JDOImplHelper.createUserConfigurableStandardProperties();
        JAVAX_JDO_PREFIX_LOWER_CASED = "javax.jdo.".toLowerCase();
        PROPERTY_PREFIX_INSTANCE_LIFECYCLE_LISTENER_LOWER_CASED = "javax.jdo.listener.InstanceLifecycleListener.".toLowerCase();
        USER_CONFIGURABLE_STANDARD_PROPERTIES_LOWER_CASED = JDOImplHelper.createUserConfigurableStandardPropertiesLowerCased();
        jdoImplHelper.registerDateFormat(JDOImplHelper.getDateTimeInstance());
        stringConstructorMap = new HashMap<Class, StringConstructor>();
        if (JDOImplHelper.isClassLoadable("java.util.Currency")) {
            jdoImplHelper.registerStringConstructor(Currency.class, new StringConstructor(){

                @Override
                public Object construct(String string) {
                    try {
                        return Currency.getInstance(string);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new JDOUserException(msg.msg("EXC_CurrencyStringConstructorIllegalArgument", string), illegalArgumentException);
                    }
                    catch (Exception exception) {
                        throw new JDOUserException(msg.msg("EXC_CurrencyStringConstructorException"), exception);
                    }
                }
            });
        }
        jdoImplHelper.registerStringConstructor(Locale.class, new StringConstructor(){

            @Override
            public Object construct(String string) {
                try {
                    return JDOImplHelper.getLocale(string);
                }
                catch (Exception exception) {
                    throw new JDOUserException(msg.msg("EXC_LocaleStringConstructorException"), exception);
                }
            }
        });
        jdoImplHelper.registerStringConstructor(Date.class, new StringConstructor(){

            @Override
            public synchronized Object construct(String string) {
                try {
                    return new Date(Long.parseLong(string));
                }
                catch (NumberFormatException numberFormatException) {
                    ParsePosition parsePosition = new ParsePosition(0);
                    Date date = dateFormat.parse(string, parsePosition);
                    if (date == null) {
                        throw new JDOUserException(msg.msg("EXC_DateStringConstructor", new Object[]{string, parsePosition.getErrorIndex(), dateFormatPattern}));
                    }
                    return date;
                }
            }
        });
    }

    static class Meta {
        String[] fieldNames;
        Class[] fieldTypes;
        byte[] fieldFlags;
        Class persistenceCapableSuperclass;
        PersistenceCapable pc;

        Meta(String[] stringArray, Class[] classArray, byte[] byArray, Class clazz, PersistenceCapable persistenceCapable) {
            this.fieldNames = stringArray;
            this.fieldTypes = classArray;
            this.fieldFlags = byArray;
            this.persistenceCapableSuperclass = clazz;
            this.pc = persistenceCapable;
        }

        String[] getFieldNames() {
            return this.fieldNames;
        }

        Class[] getFieldTypes() {
            return this.fieldTypes;
        }

        byte[] getFieldFlags() {
            return this.fieldFlags;
        }

        Class getPersistenceCapableSuperclass() {
            return this.persistenceCapableSuperclass;
        }

        PersistenceCapable getPC() {
            return this.pc;
        }

        public String toString() {
            return "Meta-" + this.pc.getClass().getName();
        }
    }

    public static interface StringConstructor {
        public Object construct(String var1);
    }

    public static interface StateInterrogationBooleanReturn {
        public Boolean is(Object var1, StateInterrogation var2);
    }

    public static interface StateInterrogationObjectReturn {
        public Object get(Object var1, StateInterrogation var2);
    }
}

