/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.jdo;

import com.objectdb.OID;
import com.objectdb.jdo.JdoListenerManager;
import com.objectdb.jdo.JdoQuery;
import com.objectdb.jdo.PMF;
import com.objectdb.jpa.EMF;
import com.objectdb.jpa.EMImpl;
import com.objectdb.o.ALS;
import com.objectdb.o.EDC;
import com.objectdb.o.ENT;
import com.objectdb.o.ERM;
import com.objectdb.o.ETR;
import com.objectdb.o.EVC;
import com.objectdb.o.EXT;
import com.objectdb.o.FGS;
import com.objectdb.o.FPL;
import com.objectdb.o.GEN;
import com.objectdb.o.HMP;
import com.objectdb.o.InternalException;
import com.objectdb.o.JDE;
import com.objectdb.o.LRQ;
import com.objectdb.o.MSS;
import com.objectdb.o.OMF;
import com.objectdb.o.PHL;
import com.objectdb.o.QUD;
import com.objectdb.o.STA;
import com.objectdb.o.STO;
import com.objectdb.o.TYM;
import com.objectdb.o.UMR;
import com.objectdb.o.UTY;
import com.objectdb.o.UserException;
import com.objectdb.o.VAL;
import com.objectdb.spi.OType;
import com.objectdb.spi.Trackable;
import jakarta.persistence.CacheRetrieveMode;
import java.lang.reflect.Constructor;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import javax.jdo.Extent;
import javax.jdo.FetchGroup;
import javax.jdo.JDOException;
import javax.jdo.JDOHelper;
import javax.jdo.JDOQLTypedQuery;
import javax.jdo.JDOUnsupportedOptionException;
import javax.jdo.ObjectState;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.Transaction;
import javax.jdo.datastore.JDOConnection;
import javax.jdo.datastore.Sequence;
import javax.jdo.identity.ByteIdentity;
import javax.jdo.identity.CharIdentity;
import javax.jdo.identity.IntIdentity;
import javax.jdo.identity.LongIdentity;
import javax.jdo.identity.ObjectIdentity;
import javax.jdo.identity.ShortIdentity;
import javax.jdo.identity.SingleFieldIdentity;
import javax.jdo.identity.StringIdentity;
import javax.jdo.listener.AttachCallback;
import javax.jdo.listener.ClearCallback;
import javax.jdo.listener.DeleteCallback;
import javax.jdo.listener.DetachCallback;
import javax.jdo.listener.InstanceLifecycleListener;
import javax.jdo.listener.LoadCallback;
import javax.jdo.listener.StoreCallback;
import javax.jdo.spi.JDOImplHelper;

public final class PMImpl
extends EMImpl
implements PersistenceManager,
Transaction {
    JdoListenerManager m_listenerManager;
    Object m_userObject;
    HMP m_userMap;
    FPL m_pureAllFetchPlan;

    public PMImpl(OMF oMF, STO sTO, TYM tYM) {
        super(oMF, sTO, tYM);
        JdoListenerManager jdoListenerManager;
        if (oMF != null && oMF instanceof PMF && (jdoListenerManager = ((PMF)oMF).m_listenerManager) != null) {
            this.m_listenerManager = new JdoListenerManager(jdoListenerManager);
        }
    }

    @Override
    public boolean h() {
        return this.h instanceof JDE;
    }

    @Override
    public PersistenceManagerFactory getPersistenceManagerFactory() {
        return (PersistenceManagerFactory)((Object)this.X);
    }

    @Override
    public Transaction currentTransaction() {
        try {
            this.n("obtain a transaction");
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
        return this;
    }

    @Override
    public JDOConnection getDataStoreConnection() {
        throw new JDOUnsupportedOptionException();
    }

    public synchronized <TOBJ> TOBJ newInstance(Class<TOBJ> clazz) {
        try {
            this.n("construct a transient object");
            OType oType = this.T.S(clazz);
            return (TOBJ)oType.newInstance();
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <TOBJ> TOBJ makePersistent(TOBJ TOBJ) {
        try {
            this.k("persist an object");
            if (TOBJ == null) {
                return null;
            }
            TOBJ TOBJ2 = TOBJ;
            synchronized (TOBJ2) {
                return (TOBJ)super.aQ(TOBJ, 1);
            }
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    public synchronized <TOBJ> TOBJ[] makePersistentAll(TOBJ ... TOBJArray) {
        try {
            this.k("persist entities");
            int n2 = TOBJArray.length;
            Object[] objectArray = new Object[n2];
            ALS aLS = null;
            for (int i2 = 0; i2 < n2; ++i2) {
                try {
                    TOBJ TOBJ = TOBJArray[i2];
                    if (TOBJ == null) continue;
                    objectArray[i2] = this.aQ(TOBJ, 1);
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    aLS = PMImpl.addException(aLS, runtimeException);
                }
            }
            if (aLS != null) {
                throw PMImpl.newMultiOperationException("persist multiple entities", aLS);
            }
            return objectArray;
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    public <TOBJ> Collection<TOBJ> makePersistentAll(Collection<TOBJ> collection) {
        Object[] objectArray = this.makePersistentAll((TOBJ[])collection.toArray());
        return Arrays.asList(objectArray);
    }

    @Override
    public synchronized void deletePersistent(Object object) {
        try {
            this.k("delete persistent object");
            super.aI(object);
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void deletePersistentAll(Object ... objectArray) {
        try {
            Object object;
            int n2;
            this.k("delete persistent entities");
            int n3 = objectArray.length;
            ALS<Object> aLS = new ALS<Object>(n3);
            ALS aLS2 = null;
            this.au();
            try {
                for (n2 = 0; n2 < n3; ++n2) {
                    try {
                        ENT eNT;
                        object = objectArray[n2];
                        if (object == null || !this.aB(object, eNT = this.P(object))) continue;
                        aLS.a(object);
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                        aLS2 = PMImpl.addException(aLS2, runtimeException);
                    }
                }
                this.H(5);
            }
            finally {
                this.av();
            }
            n3 = aLS.j();
            for (n2 = 0; n2 < n3; ++n2) {
                try {
                    object = aLS.g(n2);
                    new ERM(this).b(object);
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    aLS2 = PMImpl.addException(aLS2, runtimeException);
                }
            }
            if (aLS2 != null) {
                throw PMImpl.newMultiOperationException("delete multiple entities", aLS2);
            }
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    @Override
    public void deletePersistentAll(Collection collection) {
        this.deletePersistentAll(collection.toArray());
    }

    @Override
    public synchronized <T> T getObjectById(Class<T> clazz, Object object) {
        try {
            if (clazz == null && object instanceof String) {
                return (T)this.p((String)object);
            }
            return (T)super.q(clazz, object, true);
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    @Override
    public synchronized Object getObjectById(Object object, boolean bl) {
        try {
            if (object instanceof OID) {
                OID oID = (OID)object;
                OType oType = this.T.y(oID.getTypeId());
                return super.q(oType, oID.getObjectId(), bl);
            }
            if (object instanceof SingleFieldIdentity) {
                SingleFieldIdentity singleFieldIdentity = (SingleFieldIdentity)object;
                return super.q(singleFieldIdentity.getTargetClass(), singleFieldIdentity.getKeyAsObject(), bl);
            }
            return super.q(null, object, bl);
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    @Override
    public Object getObjectById(Object object) {
        return this.getObjectById(object, true);
    }

    public synchronized Object[] getObjectsById(Object[] objectArray, boolean bl) {
        try {
            int n2;
            ALS aLS = null;
            int n3 = objectArray.length;
            Object[] objectArray2 = new Object[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                try {
                    objectArray2[n2] = this.getObjectById(objectArray[n2], bl);
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    aLS = PMImpl.addException(aLS, runtimeException);
                }
            }
            this.Yy();
            for (n2 = 0; n2 < n3; ++n2) {
                try {
                    if (objectArray2[n2] == null) continue;
                    PMImpl.M(objectArray2[n2]).e();
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    aLS = PMImpl.addException(aLS, runtimeException);
                }
            }
            if (aLS != null) {
                throw PMImpl.newMultiOperationException("find multiple entities", aLS);
            }
            return objectArray2;
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    @Override
    public Object[] getObjectsById(boolean bl, Object ... objectArray) {
        return this.getObjectsById(objectArray, bl);
    }

    @Override
    public Object[] getObjectsById(Object ... objectArray) {
        return this.getObjectsById(objectArray, true);
    }

    @Override
    public Collection getObjectsById(Collection collection, boolean bl) {
        if (collection == null) {
            return null;
        }
        return Arrays.asList(this.getObjectsById(collection.toArray()));
    }

    @Override
    public Collection getObjectsById(Collection collection) {
        return this.getObjectsById(collection, true);
    }

    @Override
    public final synchronized Object getObjectId(Object object) {
        try {
            ENT eNT = this.P(object);
            if (eNT == null) {
                return null;
            }
            PMImpl pMImpl = (PMImpl)eNT.r();
            return pMImpl.getObjectIdByInfo(eNT);
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    @Override
    public Object getTransactionalObjectId(Object object) {
        return this.getObjectId(object);
    }

    public final Object getObjectIdByInfo(ENT eNT) {
        STA sTA = eNT.v();
        if (!sTA.x()) {
            return null;
        }
        VAL vAL = eNT.obtainPrimaryKey();
        UTY uTY = eNT.getType();
        return uTY.K(vAL, this);
    }

    @Override
    public synchronized Class getObjectIdClass(Class clazz) {
        try {
            if (clazz == null) {
                return null;
            }
            UTY uTY = (UTY)this.T.S(clazz);
            if (!uTY.isEntity()) {
                return null;
            }
            Class clazz2 = uTY.t().o();
            if (clazz2 != null) {
                return clazz2;
            }
            UMR[] uMRArray = uTY.t().t().n();
            if (uMRArray.length == 0) {
                return OID.class;
            }
            if (uMRArray.length > 1) {
                return null;
            }
            int n2 = uMRArray[0].getType().getId();
            switch (n2) {
                case -5: 
                case -4: {
                    return ByteIdentity.class;
                }
                case -9: 
                case -8: {
                    return ShortIdentity.class;
                }
                case -6: {
                    return CharIdentity.class;
                }
                case -11: 
                case -10: {
                    return IntIdentity.class;
                }
                case -13: 
                case -12: {
                    return LongIdentity.class;
                }
                case -25: {
                    return StringIdentity.class;
                }
            }
            return ObjectIdentity.class;
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    @Override
    public synchronized Object newObjectIdInstance(Class clazz, Object object) {
        try {
            Object object2;
            Class clazz2 = this.getObjectIdClass(clazz);
            if (clazz2 == null) {
                return null;
            }
            if (clazz2 == OID.class && ((OType)(object2 = this.T.S(clazz))).isEntity()) {
                long l = object instanceof Number ? ((Number)object).longValue() : Long.parseLong(String.valueOf(object));
                return new OID(((OType)object2).getId(), l);
            }
            try {
                object2 = clazz2.getConstructor(Class.class, String.class);
                return ((Constructor)object2).newInstance(clazz, object.toString());
            }
            catch (Exception exception) {
                try {
                    Constructor constructor = clazz2.getConstructor(String.class);
                    return constructor.newInstance(object.toString());
                }
                catch (Exception exception2) {
                    throw MSS.ak.a(clazz.getName());
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    @Override
    public synchronized void retrieve(Object object, boolean bl) {
        try {
            this.n("retrieve an object");
            ENT eNT = this.P(object);
            if (eNT == null) {
                return;
            }
            STA sTA = eNT.v();
            if (sTA.A() || sTA.r()) {
                return;
            }
            if (sTA.q()) {
                throw eNT.I("retrieve a detached object");
            }
            if (sTA.v() || sTA.B() || sTA.x() && sTA != this.y) {
                LRQ lRQ = new LRQ(eNT);
                lRQ.g = bl ? this.C : this.getPureAllFetchPlan();
                this.ab(lRQ);
                this.A.Yy();
            }
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    @Override
    public void retrieve(Object object) {
        this.retrieve(object, false);
    }

    public synchronized void retrieveAll(Object[] objectArray, boolean bl) {
        try {
            this.n("retrieve entities");
            FPL fPL = bl ? this.C : this.getPureAllFetchPlan();
            ALS aLS = null;
            for (Object object : objectArray) {
                STA sTA;
                ENT eNT;
                if (object == null || (eNT = this.P(object)) == null || (sTA = eNT.v()).A() || sTA.r()) continue;
                if (sTA.q()) {
                    aLS = PMImpl.addException(aLS, eNT.I("retrieve a detached object"));
                    continue;
                }
                if (!sTA.v() && !sTA.B() && (!sTA.x() || sTA == this.y)) continue;
                LRQ lRQ = new LRQ(eNT);
                lRQ.g = fPL;
                this.ab(lRQ);
            }
            this.A.Yy();
            if (aLS != null) {
                throw PMImpl.newMultiOperationException("retrieve multiple entities", aLS);
            }
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    @Override
    public void retrieveAll(boolean bl, Object ... objectArray) {
        this.retrieveAll(objectArray, bl);
    }

    @Override
    public void retrieveAll(Object ... objectArray) {
        this.retrieveAll(objectArray, false);
    }

    @Override
    public void retrieveAll(Collection collection, boolean bl) {
        this.retrieveAll(collection.toArray(), bl);
    }

    @Override
    public void retrieveAll(Collection collection) {
        this.retrieveAll(collection.toArray());
    }

    FPL getPureAllFetchPlan() {
        if (this.m_pureAllFetchPlan == null || this.m_pureAllFetchPlan.c() != this.B) {
            this.m_pureAllFetchPlan = new FPL(this, this.B);
            this.m_pureAllFetchPlan.addGroup("all");
        }
        return this.m_pureAllFetchPlan;
    }

    @Override
    public synchronized void refresh(Object object) {
        if (this.isJpa()) {
            super.refresh(object);
        } else {
            try {
                super.aj(object);
            }
            catch (RuntimeException runtimeException) {
                throw this.onObjectDBError(runtimeException);
            }
        }
    }

    boolean isJpa() {
        return this.X instanceof EMF;
    }

    @Override
    public synchronized void refreshAll(Object ... objectArray) {
        try {
            this.n("refresh entities");
            if (objectArray == null) {
                throw new NullPointerException("");
            }
            ALS aLS = null;
            for (Object object : objectArray) {
                STA sTA;
                if (object == null) continue;
                ENT eNT = this.P(object);
                if (eNT == null || !(sTA = eNT.v()).x()) {
                    aLS = PMImpl.addException(aLS, PMImpl.newExceptionStateMismatch("refresh a transient object", object));
                    continue;
                }
                if (sTA.w() || sTA.p()) continue;
                LRQ lRQ = new LRQ(eNT);
                lRQ.c = CacheRetrieveMode.BYPASS;
                if (!sTA.A()) {
                    lRQ.p = sTA;
                }
                lRQ.g = this.C;
                this.ab(lRQ);
            }
            this.A.Yy();
            if (aLS != null) {
                throw PMImpl.newMultiOperationException("refresh multiple entities", aLS);
            }
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    @Override
    public void refreshAll(Collection collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        this.refreshAll(collection.toArray());
    }

    @Override
    public void refreshAll(JDOException jDOException) {
        ArrayList arrayList = new ArrayList(4);
        PMImpl.collectExceptionObjects(jDOException, arrayList);
        this.refreshAll(arrayList);
    }

    static void collectExceptionObjects(JDOException jDOException, ArrayList arrayList) {
        Throwable[] throwableArray;
        Object object = jDOException.getFailedObject();
        if (object != null) {
            arrayList.add(object);
        }
        if ((throwableArray = jDOException.getNestedExceptions()) != null) {
            for (Throwable throwable : throwableArray) {
                if (!(throwable instanceof JDOException)) continue;
                PMImpl.collectExceptionObjects((JDOException)throwable, arrayList);
            }
        }
    }

    @Override
    public synchronized void refreshAll() {
        try {
            this.n("refresh entities");
            if (!this.J) {
                return;
            }
            this.Q.e();
            this.A.Yy();
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    @Override
    public synchronized void evict(Object object) {
        try {
            this.n("evict an object");
            if (object != null) {
                this.evict0(object);
            }
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    void evict0(Object object) {
        ENT eNT = this.P(object);
        if (eNT == null) {
            throw PMImpl.newExceptionStateMismatch("evict a transient object", object);
        }
        STA sTA = eNT.v();
        if (sTA == null || !sTA.x() || sTA.p() || sTA.r()) {
            return;
        }
        this.B(object);
        eNT.h();
        eNT.Y(this.Q.d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void evictAll(Object ... objectArray) {
        try {
            this.n("evict entities");
            if (objectArray == null) {
                throw new NullPointerException();
            }
            ALS aLS = null;
            this.au();
            try {
                for (Object object : objectArray) {
                    if (object == null) continue;
                    try {
                        this.evict0(object);
                    }
                    catch (RuntimeException runtimeException) {
                        aLS = PMImpl.addException(aLS, runtimeException);
                    }
                }
                this.H(7);
            }
            finally {
                this.av();
            }
            if (aLS != null) {
                throw PMImpl.newMultiOperationException("evict multiple entities", aLS);
            }
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    @Override
    public void evictAll(Collection collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        this.evictAll(collection.toArray());
    }

    public synchronized void evictAll(Class clazz, boolean bl) {
        ALS aLS = new ALS(4);
        this.Q.g.c(clazz, bl, aLS);
        this.Q.a.c(clazz, bl, aLS);
        this.evictAll(aLS.u());
    }

    @Override
    public void evictAll(boolean bl, Class clazz) {
        this.evictAll(clazz, bl);
    }

    @Override
    public synchronized void evictAll() {
        try {
            this.n("evict entities");
            if (!this.J) {
                return;
            }
            this.Q.g.M(false);
            this.Q.a.M(false);
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    @Override
    public synchronized void makeTransactional(Object object) {
        try {
            this.n("make an object transactional");
            this.makeTransactional0(object, true);
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    void makeTransactional0(Object object, boolean bl) {
        if (object == null) {
            return;
        }
        ENT eNT = this.P(object);
        if (eNT == null) {
            UTY uTY = this.T.L(object);
            eNT = new ENT(this, uTY);
            eNT.c(object);
            PMImpl.aa(object, eNT);
            eNT.Y(object instanceof Trackable ? this.Q.s : this.Q.u);
            if (eNT.getPrimaryKey() != null) {
                this.O.q(eNT);
            }
            eNT.f(null, false);
        } else {
            this.k("make object transactional");
            if (!eNT.isDirty() && !eNT.v().A()) {
                LRQ lRQ = new LRQ(eNT);
                lRQ.p = this.Q.g;
                lRQ.g = this.C;
                this.ab(lRQ);
                if (bl) {
                    this.A.Yy();
                }
            }
        }
    }

    @Override
    public synchronized void makeTransactionalAll(Object ... objectArray) {
        try {
            this.n("make entities transactional");
            for (Object object : objectArray) {
                this.makeTransactional0(object, false);
            }
            this.Yy();
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    @Override
    public void makeTransactionalAll(Collection collection) {
        this.makeTransactionalAll(collection.toArray());
    }

    @Override
    public synchronized void makeNontransactional(Object object) {
        try {
            this.n("make an object non transactional");
            if (object != null) {
                this.makeNontransactional0(object);
            }
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    void makeNontransactional0(Object object) {
        ENT eNT = this.P(object);
        if (eNT == null) {
            throw PMImpl.newExceptionStateMismatch("make a transient object nontransactional", object);
        }
        STA sTA = eNT.v();
        if (eNT.isDirty()) {
            throw eNT.I("make a dirty object nontransactional");
        }
        if (sTA.A()) {
            if (!sTA.x()) {
                eNT.X(false);
            } else if (eNT.D()) {
                eNT.Y(this.Q.e);
            } else {
                eNT.Y(this.Q.a);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void makeNontransactionalAll(Object ... objectArray) {
        try {
            this.n("make entities non transactional");
            ALS aLS = null;
            this.au();
            try {
                for (Object object : objectArray) {
                    if (object == null) continue;
                    try {
                        this.makeNontransactional0(object);
                    }
                    catch (RuntimeException runtimeException) {
                        aLS = PMImpl.addException(aLS, runtimeException);
                    }
                }
                this.H(7);
            }
            finally {
                this.av();
            }
            if (aLS != null) {
                throw PMImpl.newMultiOperationException("make multiple entities nontransactional", aLS);
            }
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    @Override
    public void makeNontransactionalAll(Collection collection) {
        this.makeNontransactionalAll(collection.toArray());
    }

    @Override
    public synchronized void makeTransient(Object object, boolean bl) {
        try {
            this.n("make an object transient");
            if (object == null) {
                return;
            }
            ENT eNT = this.P(object);
            if (eNT == null) {
                this.T.L(object);
                return;
            }
            if (bl) {
                if (this.J || this.n) {
                    this.ac(object);
                    this.A.Yy();
                }
                this.makeTransient0(eNT);
                new ETR(this).cascade(object, eNT.getType());
            } else {
                this.makeTransient0(eNT);
            }
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    public void makeTransient0(ENT eNT) {
        if (eNT == null) {
            return;
        }
        STA sTA = eNT.v();
        if (sTA == null || !sTA.x()) {
            return;
        }
        if (eNT.v().r()) {
            throw eNT.I("make a dirty object transient");
        }
        if (sTA.q()) {
            throw eNT.I("make a detached object transient");
        }
        eNT.X(false);
    }

    @Override
    public synchronized void makeTransient(Object object) {
        this.makeTransient(object, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void makeTransientAll(Object[] objectArray, boolean bl) {
        try {
            this.n("make entities transient");
            int n2 = objectArray.length;
            ALS<Object> aLS = new ALS<Object>(n2);
            ALS aLS2 = null;
            this.au();
            try {
                int n3;
                for (n3 = 0; n3 < n2; ++n3) {
                    try {
                        Object object = objectArray[n3];
                        if (object == null) continue;
                        if (this.P(object) == null) {
                            this.T.L(object);
                            continue;
                        }
                        aLS.a(object);
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                        aLS2 = PMImpl.addException(aLS2, runtimeException);
                    }
                }
                n2 = aLS.j();
                if (bl) {
                    if (this.J || this.n) {
                        for (n3 = 0; n3 < n2; ++n3) {
                            try {
                                this.ac(aLS.g(n3));
                                continue;
                            }
                            catch (RuntimeException runtimeException) {
                                aLS2 = PMImpl.addException(aLS2, runtimeException);
                            }
                        }
                        this.A.Yy();
                    }
                    ETR eTR = new ETR(this);
                    for (int i2 = 0; i2 < n2; ++i2) {
                        try {
                            Object t2 = aLS.g(i2);
                            ENT eNT = PMImpl.M(t2);
                            this.makeTransient0(eNT);
                            eTR.cascade(t2, eNT.getType());
                            continue;
                        }
                        catch (RuntimeException runtimeException) {
                            aLS2 = PMImpl.addException(aLS2, runtimeException);
                        }
                    }
                }
                for (n3 = 0; n3 < n2; ++n3) {
                    try {
                        this.makeTransient0(PMImpl.M(aLS.g(n3)));
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                        aLS2 = PMImpl.addException(aLS2, runtimeException);
                    }
                }
                this.H(7);
            }
            finally {
                this.av();
            }
            if (aLS2 != null) {
                throw PMImpl.newMultiOperationException("make multiple entities transient", aLS2);
            }
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    @Override
    public void makeTransientAll(boolean bl, Object ... objectArray) {
        this.makeTransientAll(objectArray, bl);
    }

    @Override
    public void makeTransientAll(Object ... objectArray) {
        this.makeTransientAll(objectArray, false);
    }

    @Override
    public void makeTransientAll(Collection collection, boolean bl) {
        this.makeTransientAll(collection.toArray(), bl);
    }

    @Override
    public void makeTransientAll(Collection collection) {
        this.makeTransientAll(collection.toArray());
    }

    public synchronized <TOBJ> TOBJ detachCopy(TOBJ TOBJ) {
        try {
            this.n("detach an object");
            if (TOBJ == null) {
                return null;
            }
            if (!this.J && !this.n) {
                throw PMImpl.newExceptionStateMismatch("detach an object with no active transaction when NontransactionalRead is disabled", TOBJ);
            }
            return (TOBJ)new EDC(this).s(TOBJ);
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    public synchronized <TOBJ> TOBJ[] detachCopyAll(TOBJ ... TOBJArray) {
        try {
            this.n("detach entities");
            if (!this.J && !this.n) {
                throw PMImpl.newExceptionStateMismatch("detach entities with no active transaction when NontransactionalRead is disabled", TOBJArray);
            }
            return new EDC(this).r(TOBJArray);
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    public <TOBJ> Collection<TOBJ> detachCopyAll(Collection<TOBJ> collection) {
        Object[] objectArray = this.detachCopyAll((TOBJ[])collection.toArray());
        return Arrays.asList(objectArray);
    }

    @Override
    public final synchronized Sequence getSequence(String string) {
        try {
            GEN gEN = this.T.s(string);
            if (gEN == null) {
                throw MSS.aP.a("sequence '" + string + "'");
            }
            return gEN;
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    @Override
    public Query newQuery() {
        try {
            return this.newObjectQuery();
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    @Override
    public Query newQuery(Object object) {
        try {
            this.n("create a query");
            JdoQuery jdoQuery = ((JdoQuery)object).newQuery();
            jdoQuery.f(this);
            return jdoQuery;
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    @Override
    public Query newQuery(String string, Object object) {
        try {
            if (!"javax.jdo.query.JDOQL".equals(string)) {
                throw new JDOUnsupportedOptionException("Unsupported query language: " + string);
            }
            return this.newQuery(object);
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    public Query newQuery(Class clazz) {
        try {
            JdoQuery jdoQuery = this.newObjectQuery();
            jdoQuery.setClass(clazz);
            return jdoQuery;
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    public Query newQuery(Extent extent) {
        try {
            return this.newQuery(extent, (String)null);
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    public Query newQuery(Extent extent, String string) {
        try {
            JdoQuery jdoQuery = this.newObjectQuery();
            jdoQuery.setCandidates(extent);
            jdoQuery.setFilter(string);
            return jdoQuery;
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    public Query newQuery(Class clazz, Collection collection) {
        try {
            JdoQuery jdoQuery = this.newObjectQuery();
            jdoQuery.setClass(clazz);
            jdoQuery.setCandidates(collection);
            return jdoQuery;
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    public Query newQuery(Class clazz, String string) {
        try {
            JdoQuery jdoQuery = this.newObjectQuery();
            jdoQuery.setClass(clazz);
            jdoQuery.setFilter(string);
            return jdoQuery;
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    public Query newQuery(Class clazz, Collection collection, String string) {
        try {
            JdoQuery jdoQuery = this.newObjectQuery();
            jdoQuery.setClass(clazz);
            jdoQuery.setCandidates(collection);
            jdoQuery.setFilter(string);
            return jdoQuery;
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    public Query newQuery(Class clazz, Extent extent, String string) {
        try {
            JdoQuery jdoQuery = this.newObjectQuery();
            jdoQuery.setClass(clazz);
            jdoQuery.setCandidates(extent);
            jdoQuery.setFilter(string);
            return jdoQuery;
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    @Override
    public Query newQuery(String string) {
        try {
            JdoQuery jdoQuery = this.newObjectQuery();
            jdoQuery.setSingleString(string);
            return jdoQuery;
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    public Query newNamedQuery(Class clazz, String string) {
        try {
            String string2;
            JdoQuery jdoQuery = this.newObjectQuery();
            if (clazz != null) {
                string2 = clazz.getName();
                this.T.S(clazz);
                jdoQuery.setCandidateType(string2);
                jdoQuery.setIncludeSubtypes(true);
            } else {
                string2 = null;
            }
            QUD qUD = this.T.l(string, string2);
            jdoQuery.setSingleString(qUD.j());
            String string3 = qUD.i("objectdb.jdo.unmodifiable");
            if ("true".equalsIgnoreCase(string3)) {
                jdoQuery.setUnmodifiable();
            }
            jdoQuery.compile();
            return jdoQuery;
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    protected JdoQuery newObjectQuery() {
        this.n("create a query");
        JdoQuery jdoQuery = new JdoQuery();
        jdoQuery.f(this);
        return jdoQuery;
    }

    @Override
    public <T> Extent<T> getExtent(Class<T> clazz, boolean bl) {
        try {
            this.n("obtain an extent");
            return new EXT(this, clazz, bl);
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    @Override
    public <T> Extent<T> getExtent(Class<T> clazz) {
        return this.getExtent(clazz, true);
    }

    @Override
    public Date getServerDate() {
        Query query = this.newQuery("SELECT UNIQUE CURRENT_TIMESTAMP");
        query.addExtension("objectdb.query-language", "odbql");
        Timestamp timestamp = (Timestamp)query.execute();
        TimeZone timeZone = this.X.p();
        if (timeZone != null) {
            long l = timestamp.getTime();
            int n2 = timestamp.getNanos();
            long l2 = timeZone.getOffset(l / 1000L * 1000L);
            timestamp = new Timestamp(l - l2);
            timestamp.setNanos(n2);
        }
        return timestamp;
    }

    @Override
    public void setUserObject(Object object) {
        this.m_userObject = object;
    }

    @Override
    public Object getUserObject() {
        return this.m_userObject;
    }

    @Override
    public Object putUserObject(Object object, Object object2) {
        if (this.m_userMap == null) {
            this.m_userMap = new HMP(11, 0.5f);
        }
        return this.m_userMap.u(object, object2);
    }

    @Override
    public Object removeUserObject(Object object) {
        if (this.m_userMap == null) {
            return null;
        }
        return this.m_userMap.x(object);
    }

    @Override
    public Object getUserObject(Object object) {
        if (this.m_userMap == null) {
            return null;
        }
        return this.m_userMap.t(object);
    }

    @Override
    protected void aG(EVC eVC) {
        super.aG(eVC);
    }

    @Override
    public synchronized void checkConsistency() {
        this.flush();
    }

    @Override
    public void addInstanceLifecycleListener(InstanceLifecycleListener instanceLifecycleListener, Class ... classArray) {
        if (this.m_listenerManager == null) {
            JdoListenerManager jdoListenerManager = this.X instanceof PMF ? ((PMF)this.X).m_listenerManager : null;
            this.m_listenerManager = new JdoListenerManager(jdoListenerManager);
        }
        this.m_listenerManager.addListener(instanceLifecycleListener, classArray);
    }

    @Override
    public void removeInstanceLifecycleListener(InstanceLifecycleListener instanceLifecycleListener) {
        if (this.m_listenerManager != null) {
            this.m_listenerManager.removeListener(instanceLifecycleListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FetchGroup getFetchGroup(Class clazz, String string) {
        try {
            PMImpl pMImpl = this;
            synchronized (pMImpl) {
                if (this.B.u() == null) {
                    this.B = new FGS(this.B, this.T);
                    this.C = this.ag(this);
                }
                return this.B.v(clazz, string);
            }
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    @Override
    public Set getManagedObjects() {
        return this.getManagedObjects(EnumSet.allOf(ObjectState.class), Object.class);
    }

    @Override
    public Set getManagedObjects(EnumSet<ObjectState> enumSet) {
        return this.getManagedObjects(enumSet, Object.class);
    }

    @Override
    public Set getManagedObjects(Class ... classArray) {
        return this.getManagedObjects(EnumSet.allOf(ObjectState.class), classArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getManagedObjects(EnumSet<ObjectState> enumSet, Class ... classArray) {
        try {
            PMImpl pMImpl = this;
            synchronized (pMImpl) {
                Object[] objectArray = this.Q.c();
                HashSet<Object> hashSet = new HashSet<Object>(11, 0.5f);
                block5: for (Object object : objectArray) {
                    if (!enumSet.contains((Object)JDOHelper.getObjectState(object))) continue;
                    for (Class clazz : classArray) {
                        if (!clazz.isAssignableFrom(object.getClass())) continue;
                        hashSet.add(object);
                        continue block5;
                    }
                }
                return hashSet;
            }
        }
        catch (RuntimeException runtimeException) {
            throw this.onObjectDBError(runtimeException);
        }
    }

    @Override
    public void A(Object object) {
        try {
            if (this.m_listenerManager != null) {
                this.m_listenerManager.firePreAttach(object);
            }
            if (object instanceof AttachCallback) {
                ((AttachCallback)object).jdoPreAttach();
            }
        }
        catch (Throwable throwable) {
            throw MSS.cD.a(throwable, "pre-attach");
        }
    }

    @Override
    public void r(Object object, Object object2) {
        try {
            if (object instanceof AttachCallback) {
                ((AttachCallback)object).jdoPostAttach(object2);
            }
            if (this.m_listenerManager != null) {
                this.m_listenerManager.firePostAttach(object, object2);
            }
        }
        catch (Throwable throwable) {
            throw MSS.cD.a(throwable, "post-attach");
        }
    }

    @Override
    public void B(Object object) {
        try {
            if (this.m_listenerManager != null) {
                this.m_listenerManager.firePreClear(object);
            }
            if (object instanceof ClearCallback) {
                ((ClearCallback)object).jdoPreClear();
            }
        }
        catch (Throwable throwable) {
            throw MSS.cD.a(throwable, "pre-clear");
        }
    }

    @Override
    public void s(Object object) {
        try {
            if (this.m_listenerManager != null) {
                this.m_listenerManager.firePostClear(object);
            }
        }
        catch (Throwable throwable) {
            throw MSS.cD.a(throwable, "post-clear");
        }
    }

    @Override
    public void C(Object object, UTY uTY) {
        try {
            if (this.m_listenerManager != null) {
                this.m_listenerManager.firePreDelete(object);
            }
            if (object instanceof DeleteCallback) {
                ((DeleteCallback)object).jdoPreDelete();
            }
        }
        catch (Throwable throwable) {
            throw MSS.cD.a(throwable, "pre-delete");
        }
        super.C(object, uTY);
    }

    @Override
    public void u(Object object, UTY uTY) {
        try {
            if (this.m_listenerManager != null) {
                this.m_listenerManager.firePostDelete(object);
            }
        }
        catch (Throwable throwable) {
            throw MSS.cD.a(throwable, "post-delete");
        }
        super.u(object, uTY);
    }

    @Override
    public void t(Object object) {
        if (this.m_listenerManager != null) {
            try {
                this.m_listenerManager.firePostCreate(object);
            }
            catch (Throwable throwable) {
                throw MSS.cD.a(throwable, "post-create");
            }
        }
    }

    @Override
    public void D(Object object) {
        try {
            if (this.m_listenerManager != null) {
                this.m_listenerManager.firePreDetach(object);
            }
            if (object instanceof DetachCallback) {
                ((DetachCallback)object).jdoPreDetach();
            }
        }
        catch (Throwable throwable) {
            throw MSS.cD.a(throwable, "pre-detach");
        }
    }

    @Override
    public void v(Object object, Object object2) {
        try {
            if (object instanceof DetachCallback) {
                ((DetachCallback)object).jdoPostDetach(object2);
            }
            if (this.m_listenerManager != null) {
                this.m_listenerManager.firePostDetach(object, object2);
            }
        }
        catch (Throwable throwable) {
            throw MSS.cD.a(throwable, "post-detach");
        }
    }

    @Override
    public void E(Object object, UTY uTY) {
        try {
            if (this.m_listenerManager != null) {
                this.m_listenerManager.firePreDirty(object);
            }
        }
        catch (Throwable throwable) {
            throw MSS.cD.a(throwable, "pre-dirty");
        }
        super.E(object, uTY);
    }

    @Override
    public void w(Object object, UTY uTY) {
        try {
            if (this.m_listenerManager != null) {
                this.m_listenerManager.firePostDirty(object);
            }
        }
        catch (Throwable throwable) {
            throw MSS.cD.a(throwable, "post-dirty");
        }
        super.w(object, uTY);
    }

    @Override
    public void x(Object object, UTY uTY, boolean bl) {
        try {
            if (bl) {
                if (object instanceof LoadCallback) {
                    ((LoadCallback)object).jdoPostLoad();
                }
                if (this.m_listenerManager != null) {
                    this.m_listenerManager.firePostLoad(object);
                }
            }
        }
        catch (Throwable throwable) {
            throw MSS.cD.a(throwable, "post-load");
        }
        super.x(object, uTY, bl);
    }

    @Override
    public void G(Object object) {
        try {
            if (this.m_listenerManager != null) {
                this.m_listenerManager.firePreStore(object);
            }
            if (object instanceof StoreCallback) {
                ((StoreCallback)object).jdoPreStore();
            }
        }
        catch (Throwable throwable) {
            throw MSS.cD.a(throwable, "pre-store");
        }
    }

    @Override
    public void z(Object object) {
        try {
            if (this.m_listenerManager != null) {
                this.m_listenerManager.firePostStore(object);
            }
        }
        catch (Throwable throwable) {
            throw MSS.cD.a(throwable, "post-store");
        }
    }

    @Override
    protected void f() {
        if (this.ae) {
            throw MSS.aZ.a(new String[0]);
        }
    }

    public static UserException newMultiOperationException(String string, ALS aLS) {
        return MSS.aS.a(PMImpl.getExceptionArray(aLS), string);
    }

    static ALS addException(ALS aLS, RuntimeException runtimeException) {
        if (aLS == null) {
            aLS = new ALS<RuntimeException>(4);
        }
        aLS.a(runtimeException);
        return aLS;
    }

    static RuntimeException[] getExceptionArray(ALS aLS) {
        if (aLS == null) {
            throw new InternalException();
        }
        int n2 = aLS.j();
        Object[] objectArray = new RuntimeException[n2];
        aLS.f(objectArray);
        return objectArray;
    }

    @Override
    public <T> JDOQLTypedQuery<T> newJDOQLTypedQuery(Class<T> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDatastoreReadTimeoutMillis(Integer n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer getDatastoreReadTimeoutMillis() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDatastoreWriteTimeoutMillis(Integer n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer getDatastoreWriteTimeoutMillis() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getSupportedProperties() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PersistenceManager getPersistenceManager() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSerializeRead(Boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean getSerializeRead() {
        throw new UnsupportedOperationException();
    }

    static {
        try {
            JDOImplHelper.getInstance().addStateInterrogation(PHL.a);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

