package src;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceException;
import javax.persistence.Query;

import model.EntityA;

public class Inserter {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		EntityManagerFactory emf = Persistence.createEntityManagerFactory("UtcNullHandlingPU");
		EntityManager em = emf.createEntityManager();

		em.getTransaction().begin();

		try {
		Query query = em.createQuery("SELECT a FROM EntityA a");
		List<EntityA> resultList = query.getResultList();
		if (resultList != null) {
			for (EntityA a : resultList) {
				em.remove(a);
			}
		}
		} catch (PersistenceException e) {
			//ignore
		}

		for (int x = 1; x < 100; x++) {
			EntityA a = new EntityA();
			a.setId(x);

			if (Math.random() < 0.5) {
				a.setSimpleField(new Double(Math.random() * 1000).intValue());
			}
			em.persist(a);
		}
		em.getTransaction().commit();

		em.close();
		emf.close();

	}

}
