/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.jpa;

import com.objectdb.jpa.type.BasicTypeImpl;
import com.objectdb.jpa.type.EmbeddableTypeImpl;
import com.objectdb.jpa.type.EntityTypeImpl;
import com.objectdb.jpa.type.ManagedTypeImpl;
import com.objectdb.jpa.type.MappedSuperclassTypeImpl;
import com.objectdb.jpa.type.TypeImpl;
import com.objectdb.o.ERR;
import com.objectdb.o.HMP;
import com.objectdb.o.MSS;
import com.objectdb.o.TYM;
import com.objectdb.o.UTY;
import com.objectdb.spi.OType;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetamodelImpl
implements Metamodel {
    private final TYM m_typeManager;
    private final ERR m_errorManager;
    private final HMP m_sysTypeToType = new HMP(11, 0.5f);
    private int m_typeUpdateCount = -1;
    private List<ManagedType<?>> m_managedTypeList;
    private List<EntityType<?>> m_entityTypeList;
    private List<EmbeddableType<?>> m_embeddableTypeList;

    public MetamodelImpl(TYM tYM) {
        this.m_typeManager = tYM;
        this.m_errorManager = this.m_typeManager.Z();
    }

    public TYM getTypeManager() {
        return this.m_typeManager;
    }

    @Override
    public Set<ManagedType<?>> getManagedTypes() {
        this.prepareTypeLists();
        return new LinkedHashSet(this.m_managedTypeList);
    }

    @Override
    public Set<EntityType<?>> getEntities() {
        this.prepareTypeLists();
        return new LinkedHashSet(this.m_entityTypeList);
    }

    @Override
    public Set<EmbeddableType<?>> getEmbeddables() {
        this.prepareTypeLists();
        return new LinkedHashSet(this.m_embeddableTypeList);
    }

    @Override
    public <X> ManagedType<X> managedType(Class<X> clazz) {
        ERR.assertNotNull(clazz);
        try {
            Type type = this.obtainType(clazz);
            if (!(type instanceof ManagedType)) {
                throw MSS.aA.d(clazz.getName(), "a managed type");
            }
            return (ManagedType)type;
        }
        catch (RuntimeException runtimeException) {
            throw this.m_errorManager.f(runtimeException);
        }
    }

    @Override
    public <X> EntityType<X> entity(Class<X> clazz) {
        ERR.assertNotNull(clazz);
        try {
            Type type = this.obtainType(clazz);
            if (!(type instanceof EntityType)) {
                throw MSS.aA.d(clazz.getName(), "an entity type");
            }
            return (EntityType)type;
        }
        catch (RuntimeException runtimeException) {
            throw this.m_errorManager.f(runtimeException);
        }
    }

    @Override
    public <X> EmbeddableType<X> embeddable(Class<X> clazz) {
        ERR.assertNotNull(clazz);
        try {
            Type type = this.obtainType(clazz);
            if (!(type instanceof EmbeddableType)) {
                throw MSS.aA.d(clazz.getName(), "an embeddable type");
            }
            return (EmbeddableType)type;
        }
        catch (RuntimeException runtimeException) {
            throw this.m_errorManager.f(runtimeException);
        }
    }

    private void prepareTypeLists() {
        UTY[] uTYArray;
        int n = this.m_typeManager.aa();
        if (n == this.m_typeUpdateCount) {
            return;
        }
        this.m_typeUpdateCount = n;
        ArrayList arrayList = new ArrayList(12);
        ArrayList arrayList2 = new ArrayList(8);
        ArrayList arrayList3 = new ArrayList(4);
        this.m_typeManager.ac(null);
        block4: for (UTY uTY : uTYArray = this.m_typeManager.aj(7)) {
            Type type = this.obtainType(uTY);
            if (!(type instanceof ManagedType)) continue;
            ManagedType managedType = (ManagedType)type;
            arrayList.add(managedType);
            switch (managedType.getPersistenceType()) {
                case ENTITY: {
                    arrayList2.add((EntityType)managedType);
                    continue block4;
                }
                case EMBEDDABLE: {
                    arrayList3.add((EmbeddableType)managedType);
                }
            }
        }
        this.m_managedTypeList = arrayList;
        this.m_entityTypeList = arrayList2;
        this.m_embeddableTypeList = arrayList3;
    }

    public Type obtainType(Class clazz) {
        Type type = (Type)this.m_sysTypeToType.z(clazz);
        if (type == null) {
            OType oType = this.m_typeManager.an(clazz);
            type = this.obtainType(oType);
        }
        return type;
    }

    public Type obtainType(OType oType) {
        if (oType.isObject()) {
            return null;
        }
        Class clazz = oType.getSysType();
        TypeImpl typeImpl = (TypeImpl)this.m_sysTypeToType.z(clazz);
        if (typeImpl == null) {
            typeImpl = this.buildType(oType);
            this.m_sysTypeToType.w(clazz, typeImpl);
            if (typeImpl instanceof ManagedTypeImpl) {
                UTY uTY = (UTY)oType;
                ManagedTypeImpl managedTypeImpl = (ManagedTypeImpl)this.obtainType(uTY.al());
                ((ManagedTypeImpl)typeImpl).init(uTY, managedTypeImpl, this);
            }
        }
        return typeImpl;
    }

    private TypeImpl buildType(OType oType) {
        if (oType instanceof UTY) {
            UTY uTY = (UTY)oType;
            if (oType.isEmbeddable()) {
                return new EmbeddableTypeImpl(uTY);
            }
            if (oType.isEntity()) {
                ManagedTypeImpl managedTypeImpl = (ManagedTypeImpl)this.obtainType(uTY.al());
                if (uTY.ad().Z()) {
                    return new MappedSuperclassTypeImpl(uTY, managedTypeImpl);
                }
                return new EntityTypeImpl(uTY, managedTypeImpl);
            }
        }
        return new BasicTypeImpl(oType.getSysType());
    }
}

