/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.jpa.criteria;

import com.objectdb.jpa.criteria.Expressions;
import com.objectdb.jpa.criteria.JpqlWritable;
import com.objectdb.jpa.criteria.JpqlWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.persistence.criteria.CompoundSelection;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Selection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CriteriaElement<T>
extends JpqlWritable
implements Expression<T> {
    private final Class<T> m_sysType;
    private String m_alias;

    CriteriaElement(Class<T> clazz) {
        this.m_sysType = clazz;
    }

    @Override
    public final String getAlias() {
        return this.m_alias;
    }

    @Override
    public final Class<? extends T> getJavaType() {
        return this.m_sysType;
    }

    @Override
    public final Selection<T> alias(String string) {
        this.m_alias = string;
        return this;
    }

    @Override
    public boolean isCompoundSelection() {
        return false;
    }

    @Override
    public List<Selection<?>> getCompoundSelectionItems() {
        return new ArrayList(Collections.singletonList(this));
    }

    @Override
    public final <X> Expression<X> as(Class<X> clazz) {
        return Expressions.expression(clazz, this);
    }

    @Override
    public final Predicate isNull() {
        return Expressions.predicate(this, " IS NULL");
    }

    @Override
    public final Predicate isNotNull() {
        return Expressions.predicate(this, " IS NOT NULL");
    }

    @Override
    public final Predicate in(Object ... objectArray) {
        Expressions.j j2 = new Expressions.j(this);
        for (Object object : objectArray) {
            j2.value(object);
        }
        return j2;
    }

    @Override
    public final Predicate in(Collection<?> collection) {
        return this.in(collection.toArray());
    }

    @Override
    public final Predicate in(Expression<?> ... expressionArray) {
        Expressions.j j2 = new Expressions.j(this);
        for (Expression<?> expression : expressionArray) {
            j2.value(expression);
        }
        return j2;
    }

    @Override
    public final Predicate in(Expression<Collection<?>> expression) {
        return Expressions.predicate(this, " IN (", expression, ")");
    }

    public Predicate.BooleanOperator getOperator() {
        return null;
    }

    public List<Expression<Boolean>> getExpressions() {
        return new ArrayList<Expression<Boolean>>(Arrays.asList(this));
    }

    public boolean isNegated() {
        return false;
    }

    public Predicate not() {
        return new Expressions.l((Predicate)((Object)this));
    }

    void writeJpqlSelect(JpqlWriter jpqlWriter) {
        this.writeJpql(jpqlWriter);
        if (this.getAlias() != null) {
            jpqlWriter.write(" AS ").write(this.getAlias());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class a<T>
    extends CriteriaElement<T>
    implements CompoundSelection<T> {
        private final boolean _a;
        private final CriteriaElement<?>[] _b;

        a(Class<T> clazz, boolean bl, Selection<?>[] selectionArray) {
            super(clazz);
            this._a = bl;
            int n = selectionArray.length;
            this._b = new CriteriaElement[n];
            System.arraycopy(selectionArray, 0, this._b, 0, n);
        }

        @Override
        public boolean isCompoundSelection() {
            return true;
        }

        @Override
        public List<Selection<?>> getCompoundSelectionItems() {
            return new ArrayList(Arrays.asList(this._b));
        }

        @Override
        void writeJpqlSelect(JpqlWriter jpqlWriter) {
            if (this._a) {
                jpqlWriter.write("NEW ").write(this.getJavaType().getName()).write("(");
            }
            this._b[0].writeJpqlSelect(jpqlWriter);
            for (int i2 = 1; i2 < this._b.length; ++i2) {
                jpqlWriter.write(", ");
                this._b[i2].writeJpqlSelect(jpqlWriter);
            }
            if (this._a) {
                jpqlWriter.write(")");
            }
        }

        @Override
        void writeJpql(JpqlWriter jpqlWriter) {
            this.writeJpqlSelect(jpqlWriter);
        }
    }
}

