/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.o;

import com.objectdb.o.BGV;
import com.objectdb.o.BLV;
import com.objectdb.o.InternalException;
import com.objectdb.o.NLT;
import com.objectdb.o.SMT;
import com.objectdb.o.VAL;
import com.objectdb.o.VUT;
import com.objectdb.spi.OReader;
import com.objectdb.spi.OWriter;
import java.math.BigInteger;

public final class BGT
extends SMT {
    public BGT() {
        super(-16, BigInteger.class);
        this.k = new NLT(BigInteger.class, this);
    }

    public void writeStrictly(Object object, OWriter oWriter) {
        oWriter.writeBigIntValue((BigInteger)object);
    }

    public Object readAndAdjust(OReader oReader) {
        return this.m(oReader);
    }

    public BigInteger m(OReader oReader) {
        int n = oReader.A();
        switch (n) {
            case 41: {
                return BGV.ab;
            }
            case 42: {
                return BGV.ae(oReader.T(1));
            }
            case 43: {
                return BGV.ae(oReader.T(2));
            }
            case 44: {
                return BGV.ae(oReader.T(3));
            }
            case 45: {
                return BGV.ae(oReader.T(4));
            }
            case 46: {
                return BGV.ae(oReader.T());
            }
        }
        if (n >= 129 && n < 192) {
            return BGT.n(oReader.R(n - 128), oReader);
        }
        VAL vAL = VUT.k(n, oReader);
        if (vAL.l() || vAL == BLV.N) {
            return BigInteger.ZERO;
        }
        if (vAL == BLV.O) {
            return BigInteger.ONE;
        }
        return BGT.o(vAL, oReader);
    }

    private static BigInteger n(String string, OReader oReader) {
        try {
            return new BigInteger(string);
        }
        catch (Exception exception) {
            InternalException.g(exception);
            oReader.addFailurePoint();
            return BigInteger.ZERO;
        }
    }

    private static BigInteger o(VAL vAL, OReader oReader) {
        try {
            BigInteger bigInteger = vAL.x();
            if (vAL.compareTo(BGV.ac(bigInteger)) != 0) {
                oReader.addFailurePoint();
            }
            return bigInteger;
        }
        catch (Exception exception) {
            oReader.addFailurePoint();
            return BigInteger.ZERO;
        }
    }

    public Object newInstance() {
        return BigInteger.valueOf(0L);
    }

    public boolean checkFirstByte(int n) {
        return n >= 41 && n <= 46;
    }
}

