/*
 * Decompiled with CFR 0.152.
 */
package com.cbr.model.enums;

public enum Accommodation {
    HOLIDAYFLAT(0),
    ONESTAR(1),
    TWOSTARS(2),
    THREESTARS(3),
    FOURSTARS(4),
    FIVESTARS(5);

    private static final long serialVersionUID = 1L;
    public int index;

    private Accommodation(int index) {
        this.index = index;
    }

    public static Accommodation make(int accIndex) {
        for (Accommodation acc : Accommodation.values()) {
            if (acc.index != accIndex) continue;
            return acc;
        }
        throw new IllegalArgumentException("Invalid Accommodation index, must be between 0 - 5 but was: " + accIndex);
    }

    public static Accommodation convert(String value) {
        value = value.trim();
        for (Accommodation acc : Accommodation.values()) {
            if (!acc.toString().equals(value)) continue;
            return acc;
        }
        try {
            return Accommodation.make(Integer.parseInt(value));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("No Enum specified for this string: " + value);
        }
    }
}

