/*
 * Decompiled with CFR 0.152.
 */
package com.cbr.model.enums;

import java.text.DateFormatSymbols;

public enum Month {
    JANUARY(1),
    FEBRUARY(2),
    MARCH(3),
    APRIL(4),
    MAY(5),
    JUNE(6),
    JULY(7),
    AUGUST(8),
    SEPTEMBER(9),
    OCTOBER(10),
    NOVEMBER(11),
    DECEMBER(12);

    private static DateFormatSymbols dateFormatSymbols;
    private static final int[] LAST_DAY_OF_MONTH;
    public int index;

    private Month(int index) {
        this.index = index;
    }

    public static Month make(int monthIndex) {
        for (Month m : Month.values()) {
            if (m.index != monthIndex) continue;
            return m;
        }
        throw new IllegalArgumentException("Invalid month index, month index must be between 1 - 12 but  " + monthIndex);
    }

    public int lastDay() {
        return LAST_DAY_OF_MONTH[this.index];
    }

    public int quarter() {
        return 1 + (this.index - 1) / 3;
    }

    public String toString() {
        return dateFormatSymbols.getMonths()[this.index - 1];
    }

    public String toShortString() {
        return dateFormatSymbols.getShortMonths()[this.index - 1];
    }

    public static Month parse(String s) {
        s = s.trim();
        for (Month m : Month.values()) {
            if (!m.matches(s)) continue;
            return m;
        }
        try {
            return Month.make(Integer.parseInt(s));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid month " + s);
        }
    }

    private boolean matches(String s) {
        return s.equalsIgnoreCase(this.toString()) || s.equalsIgnoreCase(this.toShortString());
    }

    static {
        dateFormatSymbols = new DateFormatSymbols();
        LAST_DAY_OF_MONTH = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    }
}

