/*
 * Decompiled with CFR 0.152.
 */
package com.cbr.model.enums;

public enum Weight {
    HIGH(5.0),
    LOW(3.0),
    NORMAL(1.0);

    private static final long serialVersionUID = 1L;
    public double value;

    private Weight(double value) {
        this.value = value;
    }

    public static Weight make(double index) {
        for (Weight w : Weight.values()) {
            if (w.value != index) continue;
            return w;
        }
        throw new IllegalArgumentException("Invalid Accommodation index, must be between 0 - 5 but was: " + index);
    }

    public static Weight convert(String value) {
        value = value.trim();
        for (Weight w : Weight.values()) {
            if (!w.toString().equals(value)) continue;
            return w;
        }
        try {
            return Weight.make(Integer.parseInt(value));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("No Enum specified for this string: " + value);
        }
    }
}

