/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.cbr.model.beans;


import java.io.Serializable;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Id;
import com.cbr.model.enums.Accommodation;
import com.cbr.model.enums.HolidayType;
import com.cbr.model.enums.Month;
import com.cbr.model.enums.Transportation;
import javax.persistence.OneToOne;



/**
 * @author Marvin Hansen Mail: marvin.hansen@gmail.com Web:
 * www.marvin-hansen.tel Created: Apr 12, 2012
 * @version 0.3
 */
@Entity
public class Case implements Serializable, Comparable<Case> {
    private static final long serialVersionUID = 1L;

    @Id
    private int journeyCode;
    private String caseId;
    private HolidayType holidayType;
    private int price; 
    private short numberOfPersons;
     @OneToOne
    private Country country;
    private String region;
    private Transportation transportation;
    private short duration;
    private Month season;
    private Accommodation accommodation;
    //@Embedded
     @OneToOne
    private Hotel hotel;

  
 



    /**
     *
     * @return
     */
    @Override
    public int hashCode() {

        return getJourneyCode();
    }

    /**
     *
     * @param obj
     * @return
     */
    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final Case other = (Case) obj;
        if (this.getJourneyCode() != other.journeyCode) {
            return false;
        }
        if (this.getPrice() != other.price) {
            return false;
        }
        if (this.getDuration() != other.duration) {
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(Case o1) {
        if (this.getJourneyCode() == o1.journeyCode) {
            return 0;
        } else if ((this.getJourneyCode()) > o1.journeyCode) {
            return 1;
        } else {
            return -1;
        }
    }

        /**
         * @return the journeyCode
         */
        public int getJourneyCode() {
            return journeyCode;
        }

        /**
         * @param journeyCode the journeyCode to set
         */
        public void setJourneyCode(int journeyCode) {
            this.journeyCode = journeyCode;
        }

        /**
         * @return the caseId
         */
        public String getCaseId() {
            return caseId;
        }

        /**
         * @param caseId the caseId to set
         */
        public void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        /**
         * @return the holidayType
         */
        public HolidayType getHolidayType() {
            return holidayType;
        }

        /**
         * @param holidayType the holidayType to set
         */
        public void setHolidayType(HolidayType holidayType) {
            this.holidayType = holidayType;
        }

        /**
         * @return the price
         */
        public int getPrice() {
            return price;
        }

        /**
         * @param price the price to set
         */
        public void setPrice(int price) {
            this.price = price;
        }

        /**
         * @return the numberOfPersons
         */
        public short getNumberOfPersons() {
            return numberOfPersons;
        }

        /**
         * @param numberOfPersons the numberOfPersons to set
         */
        public void setNumberOfPersons(short numberOfPersons) {
            this.numberOfPersons = numberOfPersons;
        }

        /**
         * @return the country
         */
        public Country getCountry() {
            return country;
        }

        /**
         * @param country the country to set
         */
        public void setCountry(Country country) {
            this.country = country;
        }

        /**
         * @return the region
         */
        public String getRegion() {
            return region;
        }

        /**
         * @param region the region to set
         */
        public void setRegion(String region) {
            this.region = region;
        }

        /**
         * @return the transportation
         */
        public Transportation getTransportation() {
            return transportation;
        }

        /**
         * @param transportation the transportation to set
         */
        public void setTransportation(Transportation transportation) {
            this.transportation = transportation;
        }

        /**
         * @return the duration
         */
        public short getDuration() {
            return duration;
        }

        /**
         * @param duration the duration to set
         */
        public void setDuration(short duration) {
            this.duration = duration;
        }

        /**
         * @return the season
         */
        public Month getSeason() {
            return season;
        }

        /**
         * @param season the season to set
         */
        public void setSeason(Month season) {
            this.season = season;
        }

        /**
         * @return the accommodation
         */
        public Accommodation getAccommodation() {
            return accommodation;
        }

        /**
         * @param accommodation the accommodation to set
         */
        public void setAccommodation(Accommodation accommodation) {
            this.accommodation = accommodation;
        }

        /**
         * @return the hotel
         */
        public Hotel getHotel() {
            return hotel;
        }

        /**
         * @param hotel the hotel to set
         */
        public void setHotel(Hotel hotel) {
            this.hotel = hotel;
        }
    }

