/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.cbr.model.beans;

import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Embeddable;

/**
 * @author Marvin Hansen Mail: marvin.hansen@gmail.com Web:
 * www.marvin-hansen.tel Created: Apr 13, 2012
 * @version 0.4
 */
@Embeddable 
public class Country implements Serializable {
    private static final long serialVersionUID = 1L;
    
    private String countryCode;
    private String countryName;

    public Country() {
    }

    /**
     * Constructor
     *
     * @param countryCode
     * @param countryName
     */
    public Country(String countryCode,   String countryName) {
        this.countryCode = countryCode;
        this.countryName = countryName;
    }
    
    @Override
    public int hashCode(){
       return countryCode.hashCode() * countryName.hashCode() * 42;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final Country other = (Country) obj;
        if (!Objects.equals(this.countryCode, other.countryCode)) {
            return false;
        }
        if (!Objects.equals(this.countryName, other.countryName)) {
            return false;
        }
        return true;
    }
}
