/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.cbr.model.beans;

//add lombock to your pom.xml 
import com.cbr.model.enums.Weight;

/**
 * @author Marvin Hansen Mail: marvin.hansen@gmail.com Web:
 * www.marvin-hansen.tel Created: Apr 20, 2012
 * @version 0.1
 */
public class FeatureWeights {

    private boolean durationSet;
    private boolean nrOfPersonsSet;
    private boolean regionSet;
    private boolean priceSet;
    private boolean seasonSet;
    private boolean accommodationSet;
    private boolean holidayTypeSet;
    private boolean transportationSet;
    //
    private Weight durationWeight;
    private Weight nrOfPersonsWeight;
    private Weight regionWeight;
    private Weight priceWeight;
    private Weight seasonWeight;
    private Weight accommodationWeight;
    private Weight holidayTypeWeight;
    private Weight transportationWeight;
    //
    private final Weight defaultWeight = Weight.HIGH;
    private final boolean defaultSet = true;

    /**
     * creates a new instance with all weights set to the default value 1.0.
     *
     */
    public FeatureWeights() {

        initDefaultWeights();
    }

    /**
     *
     */
    private void initDefaultWeights() {

        setDurationWeight(defaultWeight);
        setNrOfPersonsWeight(defaultWeight);
        setRegionWeight(defaultWeight);
        setPriceWeight(defaultWeight);
        setSeasonWeight(defaultWeight);
        setAccommodationWeight(defaultWeight);
        setHolidayTypeWeight(defaultWeight);
        setNrOfPersonsWeight(defaultWeight);
        setTransportationWeight(defaultWeight);
    }

    /**
     *
     */
    public void initDefaultSets() {

        setDurationSet(defaultSet);
        setNrOfPersonsSet(defaultSet);
        setRegionSet(defaultSet);
        setPriceSet(defaultSet);
        setSeasonSet(defaultSet);
        setAccommodationSet(defaultSet);
        setHolidayTypeSet(defaultSet);
        setTransportationSet(defaultSet);


    }

    /**
     * @return the durationWeight
     */
    public double getDurationValue() {
        return durationWeight.value;
    }

    /**
     * @return the nrOfPersonsWeight
     */
    public double getNrOfPersonsValue() {
        return nrOfPersonsWeight.value;
    }

    /**
     *
     * @return
     */
    public double getRegionValue() {
        return regionWeight.value;
    }

    /**
     * @return the priceWeight
     */
    public double getPriceValue() {
        return priceWeight.value;
    }

    /**
     * @return the seasonWeight
     */
    public double getSeasonValue() {
        return seasonWeight.value;
    }

    /**
     * @return the accommodationWeight
     */
    public double getAccommodationValue() {
        return accommodationWeight.value;
    }

    /**
     * @return the holidayTypeWeight
     */
    public double getHolidayTypeValue() {
        return holidayTypeWeight.value;
    }

    /**
     *
     * @return
     */
    public double getTransportationValue() {

        return transportationWeight.value;
    }

    /**
     *
     * @param durationWeight
     * @param b
     */
    public void setDurationWeight(Weight durationWeight, boolean b) {
        this.setDurationWeight(durationWeight);
        this.setDurationSet(b);
    }

    /**
     *
     * @param nrOfPersonsWeight
     * @param b
     */
    public void setNrOfPersonsWeight(Weight nrOfPersonsWeight, boolean b) {
        this.setNrOfPersonsWeight(nrOfPersonsWeight);
        this.setNrOfPersonsSet(b);
    }

    /**
     *
     * @param regionWeight
     * @param b
     */
    public void setRegionWeight(Weight regionWeight, boolean b) {
        this.setRegionWeight(regionWeight);
        this.setRegionSet(b);
    }

    /**
     *
     * @param priceWeight
     * @param b
     */
    public void setPriceWeight(Weight priceWeight, boolean b) {
        this.setPriceWeight(priceWeight);
        this.setPriceSet(b);
    }

    /**
     *
     * @param seasonWeight
     * @param b
     */
    public void setSeasonWeight(Weight seasonWeight, boolean b) {
        this.setSeasonWeight(seasonWeight);
        this.setSeasonSet(b);
    }

    /**
     *
     * @param accommodationWeight
     * @param b
     */
    public void setAccommodationWeight(Weight accommodationWeight, boolean b) {
        this.setAccommodationWeight(accommodationWeight);
        this.setAccommodationSet(b);
    }

    /**
     *
     * @param holidayTypeWeight
     * @param b
     */
    public void setHolidayTypeWeight(Weight holidayTypeWeight, boolean b) {
        this.setHolidayTypeWeight(holidayTypeWeight);
        this.setHolidayTypeSet(b);
    }

    /**
     *
     * @param transportationWeight
     * @param b
     */
    public void setTransportationWeight(Weight transportationWeight, boolean b) {
        this.setTransportationWeight(transportationWeight);
        this.setTransportationSet(b);

    }

    /**
     * @param durationSet the durationSet to set
     */
    public void setDurationSet(boolean durationSet) {
        this.durationSet = durationSet;
    }

    /**
     * @param nrOfPersonsSet the nrOfPersonsSet to set
     */
    public void setNrOfPersonsSet(boolean nrOfPersonsSet) {
        this.nrOfPersonsSet = nrOfPersonsSet;
    }

    /**
     * @param regionSet the regionSet to set
     */
    public void setRegionSet(boolean regionSet) {
        this.regionSet = regionSet;
    }

    /**
     * @param priceSet the priceSet to set
     */
    public void setPriceSet(boolean priceSet) {
        this.priceSet = priceSet;
    }

    /**
     * @param seasonSet the seasonSet to set
     */
    public void setSeasonSet(boolean seasonSet) {
        this.seasonSet = seasonSet;
    }

    /**
     * @param accommodationSet the accommodationSet to set
     */
    public void setAccommodationSet(boolean accommodationSet) {
        this.accommodationSet = accommodationSet;
    }

    /**
     * @param holidayTypeSet the holidayTypeSet to set
     */
    public void setHolidayTypeSet(boolean holidayTypeSet) {
        this.holidayTypeSet = holidayTypeSet;
    }

    /**
     * @param transportationSet the transportationSet to set
     */
    public void setTransportationSet(boolean transportationSet) {
        this.transportationSet = transportationSet;
    }

    /**
     * @param durationWeight the durationWeight to set
     */
    public void setDurationWeight(Weight durationWeight) {
        this.durationWeight = durationWeight;
    }

    /**
     * @param nrOfPersonsWeight the nrOfPersonsWeight to set
     */
    public void setNrOfPersonsWeight(Weight nrOfPersonsWeight) {
        this.nrOfPersonsWeight = nrOfPersonsWeight;
    }

    /**
     * @param regionWeight the regionWeight to set
     */
    public void setRegionWeight(Weight regionWeight) {
        this.regionWeight = regionWeight;
    }

    /**
     * @param priceWeight the priceWeight to set
     */
    public void setPriceWeight(Weight priceWeight) {
        this.priceWeight = priceWeight;
    }

    /**
     * @param seasonWeight the seasonWeight to set
     */
    public void setSeasonWeight(Weight seasonWeight) {
        this.seasonWeight = seasonWeight;
    }

    /**
     * @param accommodationWeight the accommodationWeight to set
     */
    public void setAccommodationWeight(Weight accommodationWeight) {
        this.accommodationWeight = accommodationWeight;
    }

    /**
     * @param holidayTypeWeight the holidayTypeWeight to set
     */
    public void setHolidayTypeWeight(Weight holidayTypeWeight) {
        this.holidayTypeWeight = holidayTypeWeight;
    }

    /**
     * @param transportationWeight the transportationWeight to set
     */
    public void setTransportationWeight(Weight transportationWeight) {
        this.transportationWeight = transportationWeight;
    }

   
}
