/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.cbr.model.beans;

import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Embeddable;

/**
 * @author Marvin Hansen Mail: marvin.hansen@gmail.com Web:
 * www.marvin-hansen.tel Created: Apr 12, 2012
 * @version 0.3
 */


@Embeddable 
public class Hotel implements Serializable {
    private static final long serialVersionUID = 1L;
    
    
    private String hotelName;
    private String hotelLocation;

    public Hotel() {
    }

    /**
     *
     * @param hotelName
     * @param hotelLocation
     */
    public Hotel( String hotelName,  String hotelLocation) {
        this.hotelName = hotelName;
        this.hotelLocation = hotelLocation;
    }
    
    @Override
    public int hashCode(){
        return hotelLocation.hashCode() * hotelName.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final Hotel other = (Hotel) obj;
        if (!Objects.equals(this.hotelName, other.hotelName)) {
            return false;
        }
        if (!Objects.equals(this.hotelLocation, other.hotelLocation)) {
            return false;
        }
        return true;
    }
}
