/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.cbr.model.enums;

/**
 * @author Marvin Hansen Mail: marvin.hansen@gmail.com Web:
 * www.marvin-hansen.tel Created: Apr 12, 2012
 * @version 0.3
 */
public enum Accommodation {

    HOLIDAYFLAT(0),
    ONESTAR(1),
    TWOSTARS(2),
    THREESTARS(3),
    FOURSTARS(4),
    FIVESTARS(5);
    /*
     *
     */
    @SuppressWarnings("compatibility:-2269050693367296675")
    private static final long serialVersionUID = 1L;
    //private final String value;
    public int index;

    /**
     * Constructor
     *
     * @param value - String
     */
    Accommodation(int index) {
        this.index = index;
    }

    /**
     *
     * @param accIndex
     * @return
     */
    public static Accommodation make(int accIndex) {

        for (Accommodation acc : Accommodation.values()) {

            if (acc.index == accIndex) {
                return acc;
            }
        }
        throw new IllegalArgumentException("Invalid Accommodation index, must be between 0 - 5 but was: " + accIndex);
    }

    /**
     *
     * @param value
     * @return Status
     */
    public static Accommodation convert(String value) {

        value = value.trim();

        for (Accommodation acc : values()) {
            if (acc.toString().equals(value)) {
                return acc;
            }
        }

        try {

            return make(Integer.parseInt(value));

        } catch (NumberFormatException e) {}

        throw new IllegalArgumentException("No Enum specified for this string: " + value);
        //return null;
    }
}
