/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.cbr.model.enums;

/**
 * @author Marvin Hansen Mail: marvin.hansen@gmail.com Web:
 * www.marvin-hansen.tel Created: Apr 12, 2012
 * @version 0.1
 */
public enum HolidayType {

    ACTIVE("ACTIVE"),
    BATHING("BATHING"),
    CITY("CITY"),
    EDUCATION("EDUCATION"),
    LANGUAGE("LANGUAGE"),
    RECREATION("RECREATION"),
    SKIING("SKIING"),
    WANDERING("WANDERING");
    /*
     *
     */
    @SuppressWarnings("compatibility:-2269050693367296675")
    private static final long serialVersionUID = 1L;
    private final String value;

    /**
     * Constructor
     *
     * @param value - String
     */
    private HolidayType(String value) {
        this.value = value;
    }

    /**
     *
     * @return String
     */
    @Override
    public String toString() {
        return value;
    }

    /**
     *
     * @param value
     * @return Status
     */
     public static HolidayType convert(String value) {
        for (HolidayType ht : values()) {
            if (ht.toString().equalsIgnoreCase(value)) {
                return ht;
            }
        }
        throw new IllegalArgumentException("No Enum specified for this string: " + value);
        //return null;
    }
}
