/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.cbr.model.enums;

/**
 * @author Marvin Hansen 
 * Mail: marvin.hansen@gmail.com 
 * Web: www.marvin-hansen.tel 
 * Created: Apr 12, 2012
 * @version 0.1
 */
public enum Transportation {

    CAR("CAR"),
    COACH("COACH"),
    PLANE("PLANE"),
    TRAIN("TRAIN");

    /*
     * 
     */
    @SuppressWarnings("compatibility:-2269050693367296675")
    private static final long serialVersionUID = 1L;
    private final String value;

    /**
     * Constructor
     *
     * @param value - String
     */
    private Transportation(String value) {
        this.value = value;
    }

    /**
     *
     * @return String
     */
    @Override
    public String toString() {
        return value;
    }

    /**
     *
     * @param value
     * @return Status
     */
    public static Transportation convert(String value) {
        for (Transportation transp : values()) {
            if (transp.toString().equals(value)) {
                return transp;
            }
        }
        throw new IllegalArgumentException("No Enum specified for this string: " + value);
        //return null;
    }
}
