/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.cbr.model.enums;

/**
 * @author Marvin Hansen Mail: marvin.hansen@gmail.com Web:
 * www.marvin-hansen.tel Created: Apr 22, 2012
 * @version 0.1
 */
public enum Weight {

    HIGH(5),
    LOW(3),
    NORMAL(1);
    @SuppressWarnings("compatibility:-2269050693367296675")
    private static final long serialVersionUID = 1L;
    //private final String value;
    public double value;

    /**
     * Constructor
     *
     * @param value - String
     */
    Weight(double value) {
        this.value = value;
    }

    /**
     *
     * @param value
     * @return
     */
    public static Weight make(double index) {

        for (Weight w : Weight.values()) {

            if (w.value == index) {
                return w;
            }
        }
        throw new IllegalArgumentException("Invalid Accommodation index, must be between 0 - 5 but was: " + index);
    }

    /**
     *
     * @param value
     * @return Status
     */
    public static Weight convert(String value) {

        value = value.trim();

        for (Weight w : values()) {
            if (w.toString().equals(value)) {
                return w;
            }
        }

        try {

            return make(Integer.parseInt(value));

        } catch (NumberFormatException e) {
        }

        throw new IllegalArgumentException("No Enum specified for this string: " + value);
        //return null;
    }
}
