/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.conv1.store;

import com.objectdb.conv1.common.OldObjectRef;
import com.objectdb.conv1.store.OldBTreePage;
import com.objectdb.conv1.store.OldClassInfo;
import com.objectdb.conv1.store.OldClassManagerPage;
import com.objectdb.conv1.store.OldDataManagerPage;
import com.objectdb.conv1.store.OldDataStore;
import com.objectdb.conv1.store.OldFirstPage;
import com.objectdb.conv1.store.OldMapperPage;
import com.objectdb.conv1.store.OldPageTypes;
import com.objectdb.conv1.type.OldTypeManager;
import com.objectdb.conv1.value.OldObjRefValue;
import com.objectdb.conv1.value.OldStringValue;

public final class OldMainStoreMgr
implements OldPageTypes {
    protected OldDataStore m_dataStore;
    OldTypeManager m_typeManager;
    public OldFirstPage m_firstPage;
    OldClassManagerPage m_classManager;
    OldMapperPage m_objectMapper;
    OldBTreePage m_objectNames;
    OldDataManagerPage m_dataManager;

    public OldMapperPage getObjectMapper() {
        return this.m_objectMapper;
    }

    public OldMainStoreMgr(String string, String string2, ClassLoader classLoader, boolean bl, boolean bl2, boolean bl3) {
        this.m_dataStore = new OldDataStore(string, bl);
        this.m_firstPage = this.m_dataStore.getFirstPage();
        this.m_classManager = (OldClassManagerPage)this.m_dataStore.openPageWithoutCache(1);
        this.m_dataManager = (OldDataManagerPage)this.m_dataStore.openPageWithoutCache(2);
        this.m_objectNames = (OldBTreePage)this.m_dataStore.openPageWithoutCache(3);
        this.m_objectMapper = (OldMapperPage)this.m_dataStore.openPageWithoutCache(4);
        this.m_typeManager = new OldTypeManager(this, classLoader);
        this.m_classManager.setTypeManager(this.m_typeManager);
    }

    public byte[] retrieveClassVersion(int n) {
        int n2 = this.m_classManager.getVersionPageId(n);
        if (n2 == 0) {
            return null;
        }
        return this.m_dataManager.retrieveVersion(n, n2);
    }

    public byte[] retrieveClassVersion(String string) {
        OldClassInfo oldClassInfo = this.m_classManager.getClassInfo(string);
        if (oldClassInfo == null) {
            return null;
        }
        return this.m_dataManager.retrieveVersion(oldClassInfo.getLastVersionTypeId(), oldClassInfo.getLastVersionPageId());
    }

    public int getClassVersionId(String string) {
        OldClassInfo oldClassInfo = this.m_classManager.getClassInfo(string);
        if (oldClassInfo == null) {
            return 0;
        }
        return oldClassInfo.getLastVersionTypeId();
    }

    public byte[] retrieveObject(long l) {
        return this.m_dataManager.retrieveObject(l, 0, this.m_objectMapper, this.m_typeManager);
    }

    public byte[] retrieveObject(String string) {
        OldStringValue oldStringValue = (OldStringValue)this.m_objectNames.getKeyDelegate();
        oldStringValue.set(string);
        OldObjRefValue oldObjRefValue = (OldObjRefValue)this.m_objectNames.retrieveFirstValue(oldStringValue, true);
        if (oldObjRefValue == null) {
            return null;
        }
        OldObjectRef oldObjectRef = (OldObjectRef)oldObjRefValue.get();
        return this.m_dataManager.retrieveObject(oldObjectRef.getObjectId(), oldObjectRef.getPageId(), this.m_objectMapper, this.m_typeManager);
    }

    public String[] getRootNames() {
        return this.m_objectNames.getAllStringKeys();
    }

    public void close() {
        if (this.m_dataStore != null) {
            this.m_dataStore.close();
            this.m_dataStore = null;
        }
    }

    public OldTypeManager getTypeManager() {
        return this.m_typeManager;
    }

    public OldClassManagerPage getClassManager() {
        return this.m_classManager;
    }

    public OldDataStore getDataStore() {
        return this.m_dataStore;
    }
}

