/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.conv1.store;

import com.objectdb.conv1.common.OldBuffer;
import com.objectdb.conv1.store.OldClassInfo;
import com.objectdb.conv1.value.OldValue;
import java.util.HashMap;
import java.util.Iterator;

public final class OldIndexManager {
    public static final int INDEX_VALUE = 1;
    public static final int INDEX_ARRAY = 2;
    public static final int INDEX_SUPER = 3;
    public static final int INDEX_NONE = 8;
    static final int UPDATE_ADD = 1;
    static final int UPDATE_REMOVE = 2;
    static final int UPDATE_REBUILD = 3;

    public static IndexInfo constructFromBuffer(OldBuffer oldBuffer, OldClassInfo oldClassInfo) {
        IndexInfo indexInfo;
        switch (oldBuffer.readByte()) {
            case 8: {
                return null;
            }
            case 1: {
                indexInfo = new ValueIndexInfo(oldClassInfo);
                break;
            }
            case 2: {
                indexInfo = new ArrayIndexInfo(oldClassInfo);
                break;
            }
            case 3: {
                indexInfo = new SuperIndexInfo(oldClassInfo);
                break;
            }
            default: {
                throw new RuntimeException("Internal Exception");
            }
        }
        indexInfo.readFromBuffer(oldBuffer);
        return indexInfo;
    }

    public static final class ValueIndexInfo
    extends IndexInfo {
        int m_typeCode;
        long m_oldObjectCount;
        int m_indexRootId;
        OldValue m_keyValue;

        ValueIndexInfo(OldClassInfo oldClassInfo) {
            super(oldClassInfo);
        }

        public int getCode() {
            return 1;
        }

        void writeIntoBuffer(OldBuffer oldBuffer) {
            super.writeIntoBuffer(oldBuffer);
            oldBuffer.writeByte((byte)this.m_typeCode);
            oldBuffer.writeInt(this.m_indexRootId);
            oldBuffer.writeLong(this.m_oldObjectCount);
            oldBuffer.writeCompressedUInt(0);
            oldBuffer.writeCompressedUInt(0);
        }

        void readFromBuffer(OldBuffer oldBuffer) {
            super.readFromBuffer(oldBuffer);
            this.m_typeCode = oldBuffer.readByte();
            this.m_indexRootId = oldBuffer.readInt();
            this.m_oldObjectCount = oldBuffer.readLong();
            this.m_keyValue = OldValue.constructValue(this.m_typeCode);
            oldBuffer.skip(2);
        }
    }

    public static class ArrayIndexInfo
    extends IndexInfo {
        String m_elementType;
        public IndexInfo m_childIndex;
        boolean m_isPrimitive;

        public ArrayIndexInfo(OldClassInfo oldClassInfo) {
            super(oldClassInfo);
        }

        public int getCode() {
            return 2;
        }

        void writeIntoBuffer(OldBuffer oldBuffer) {
            super.writeIntoBuffer(oldBuffer);
            oldBuffer.writeString(this.m_elementType);
            oldBuffer.writeBoolean(this.m_isPrimitive);
            this.m_childIndex.writeIntoBuffer(oldBuffer);
            oldBuffer.writeCompressedUInt(0);
            oldBuffer.writeCompressedUInt(0);
        }

        void readFromBuffer(OldBuffer oldBuffer) {
            super.readFromBuffer(oldBuffer);
            this.m_elementType = oldBuffer.readString();
            this.m_isPrimitive = oldBuffer.readBoolean();
            this.m_childIndex = OldIndexManager.constructFromBuffer(oldBuffer, this.m_classInfo);
            oldBuffer.skip(2);
        }
    }

    public static class SuperIndexInfo
    extends IndexInfo {
        String m_type;
        public HashMap m_indexMap;
        boolean m_isEmbedded;

        SuperIndexInfo(OldClassInfo oldClassInfo) {
            super(oldClassInfo);
        }

        public int getCode() {
            return 3;
        }

        void writeIntoBuffer(OldBuffer oldBuffer) {
            super.writeIntoBuffer(oldBuffer);
            oldBuffer.writeString(this.m_type);
            oldBuffer.writeBoolean(this.m_isEmbedded);
            oldBuffer.writeCompressedUInt(this.m_indexMap.size());
            Iterator iterator = this.m_indexMap.values().iterator();
            while (iterator.hasNext()) {
                ((IndexInfo)iterator.next()).writeIntoBuffer(oldBuffer);
            }
            oldBuffer.writeCompressedUInt(0);
            oldBuffer.writeCompressedUInt(0);
        }

        void readFromBuffer(OldBuffer oldBuffer) {
            super.readFromBuffer(oldBuffer);
            this.m_type = oldBuffer.readString();
            this.m_isEmbedded = oldBuffer.readBoolean();
            int n = oldBuffer.readCompressedUInt();
            HashMap<String, IndexInfo> hashMap = new HashMap<String, IndexInfo>(n * 2 + 1);
            while (n-- > 0) {
                IndexInfo indexInfo = OldIndexManager.constructFromBuffer(oldBuffer, this.m_classInfo);
                hashMap.put(indexInfo.m_fieldName, indexInfo);
            }
            this.m_indexMap = hashMap;
            oldBuffer.skip(2);
        }
    }

    public static abstract class IndexInfo {
        public String m_fullPath;
        String m_fieldName;
        String m_className;
        protected OldClassInfo m_classInfo;

        IndexInfo(OldClassInfo oldClassInfo) {
            this.m_classInfo = oldClassInfo;
            this.m_className = oldClassInfo.getClassName();
        }

        public abstract int getCode();

        void writeIntoBuffer(OldBuffer oldBuffer) {
            oldBuffer.writeByte(this.getCode());
            oldBuffer.writeString(this.m_fullPath);
            oldBuffer.writeString(this.m_fieldName);
            oldBuffer.writeString(this.m_className);
            oldBuffer.writeCompressedUInt(0);
        }

        void readFromBuffer(OldBuffer oldBuffer) {
            this.m_fullPath = oldBuffer.readString();
            this.m_fieldName = oldBuffer.readString();
            this.m_className = oldBuffer.readString();
            oldBuffer.skip(1);
        }
    }
}

