/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo.identity;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jdo.identity.SingleFieldIdentity;

public class ShortIdentity
extends SingleFieldIdentity {
    short key;

    void construct(short s2) {
        this.key = s2;
        this.hashCode = this.hashClassName() ^ s2;
    }

    public ShortIdentity(Class clazz, short s2) {
        super(clazz);
        this.construct(s2);
    }

    public ShortIdentity(Class clazz, Short s2) {
        super(clazz);
        this.setKeyAsObject(s2);
        this.construct(s2);
    }

    public ShortIdentity(Class clazz, String string) {
        super(clazz);
        this.assertKeyNotNull(string);
        this.construct(Short.parseShort(string));
    }

    public ShortIdentity() {
    }

    public short getKey() {
        return this.key;
    }

    public String toString() {
        return Short.toString(this.key);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        ShortIdentity shortIdentity = (ShortIdentity)object;
        return this.key == shortIdentity.key;
    }

    public int compareTo(Object object) {
        if (object instanceof ShortIdentity) {
            ShortIdentity shortIdentity = (ShortIdentity)object;
            int n2 = super.compare(shortIdentity);
            if (n2 == 0) {
                return this.key - shortIdentity.key;
            }
            return n2;
        }
        if (object == null) {
            throw new ClassCastException("object is null");
        }
        throw new ClassCastException(this.getClass().getName() + " != " + object.getClass().getName());
    }

    protected Object createKeyAsObject() {
        return new Short(this.key);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeShort(this.key);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.key = objectInput.readShort();
    }
}

