/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.jpa.criteria;

import com.objectdb.jpa.MetamodelImpl;
import com.objectdb.jpa.criteria.CriteriaElement;
import com.objectdb.jpa.criteria.CriteriaQueryImpl;
import com.objectdb.jpa.criteria.Expressions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.persistence.Tuple;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.CompoundSelection;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.SetJoin;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.Metamodel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CriteriaBuilderImpl
implements CriteriaBuilder {
    final MetamodelImpl m_metamodel;

    public CriteriaBuilderImpl(MetamodelImpl metamodelImpl) {
        this.m_metamodel = metamodelImpl;
    }

    public <T> CriteriaQuery<T> createQuery(Class<T> clazz) {
        return new CriteriaQueryImpl((Metamodel)this.m_metamodel, (Class)clazz);
    }

    public CriteriaQuery<Object> createQuery() {
        return this.createQuery(Object.class);
    }

    public CriteriaQuery<Tuple> createTupleQuery() {
        return this.createQuery(Tuple.class);
    }

    public <Y> CompoundSelection<Y> construct(Class<Y> clazz, Selection<?> ... selectionArray) {
        return new CriteriaElement.CompoundSelectionImpl<Y>(clazz, true, selectionArray);
    }

    public CompoundSelection<Object[]> array(Selection<?> ... selectionArray) {
        return new CriteriaElement.CompoundSelectionImpl<Object[]>(Object[].class, false, selectionArray);
    }

    public CompoundSelection<Tuple> tuple(Selection<?> ... selectionArray) {
        return new CriteriaElement.CompoundSelectionImpl<Tuple>(Tuple.class, false, selectionArray);
    }

    public Order asc(Expression<?> expression) {
        return new CriteriaQueryImpl.OrderImpl(expression, true);
    }

    public Order desc(Expression<?> expression) {
        return new CriteriaQueryImpl.OrderImpl(expression, false);
    }

    public <T> ParameterExpression<T> parameter(Class<T> clazz, String string) {
        return new Expressions.ParameterExpressionImpl<T>(clazz, string);
    }

    public <T> ParameterExpression<T> parameter(Class<T> clazz) {
        return this.parameter(clazz, null);
    }

    public <T> Expression<T> literal(T t2) {
        return Expressions.literal(t2);
    }

    public <T> Expression<T> nullLiteral(Class<T> clazz) {
        return Expressions.literal(null);
    }

    public Predicate equal(Expression<?> expression, Expression<?> expression2) {
        return Expressions.predicate(expression, "=", expression2);
    }

    public Predicate equal(Expression<?> expression, Object object) {
        return this.equal(expression, this.literal(object));
    }

    public Predicate notEqual(Expression<?> expression, Expression<?> expression2) {
        return Expressions.predicate(expression, "<>", expression2);
    }

    public Predicate notEqual(Expression<?> expression, Object object) {
        return this.notEqual(expression, this.literal(object));
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThan(Expression<? extends Y> expression, Expression<? extends Y> expression2) {
        return Expressions.predicate(expression, ">", expression2);
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThan(Expression<? extends Y> expression, Y y) {
        return this.greaterThan(expression, (Y)this.literal(y));
    }

    public Predicate gt(Expression<? extends Number> expression, Expression<? extends Number> expression2) {
        return Expressions.predicate(expression, ">", expression2);
    }

    public Predicate gt(Expression<? extends Number> expression, Number number) {
        return this.gt(expression, this.literal(number));
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThanOrEqualTo(Expression<? extends Y> expression, Expression<? extends Y> expression2) {
        return Expressions.predicate(expression, ">=", expression2);
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThanOrEqualTo(Expression<? extends Y> expression, Y y) {
        return this.greaterThanOrEqualTo(expression, (Y)this.literal(y));
    }

    public Predicate ge(Expression<? extends Number> expression, Expression<? extends Number> expression2) {
        return Expressions.predicate(expression, ">=", expression2);
    }

    public Predicate ge(Expression<? extends Number> expression, Number number) {
        return this.ge(expression, this.literal(number));
    }

    public <Y extends Comparable<? super Y>> Predicate lessThan(Expression<? extends Y> expression, Expression<? extends Y> expression2) {
        return Expressions.predicate(expression, "<", expression2);
    }

    public <Y extends Comparable<? super Y>> Predicate lessThan(Expression<? extends Y> expression, Y y) {
        return this.lessThan(expression, (Y)this.literal(y));
    }

    public Predicate lt(Expression<? extends Number> expression, Expression<? extends Number> expression2) {
        return Expressions.predicate(expression, "<", expression2);
    }

    public Predicate lt(Expression<? extends Number> expression, Number number) {
        return this.lt(expression, this.literal(number));
    }

    public <Y extends Comparable<? super Y>> Predicate lessThanOrEqualTo(Expression<? extends Y> expression, Expression<? extends Y> expression2) {
        return Expressions.predicate(expression, "<=", expression2);
    }

    public <Y extends Comparable<? super Y>> Predicate lessThanOrEqualTo(Expression<? extends Y> expression, Y y) {
        return this.lessThanOrEqualTo(expression, (Y)this.literal(y));
    }

    public Predicate le(Expression<? extends Number> expression, Expression<? extends Number> expression2) {
        return Expressions.predicate(expression, "<=", expression2);
    }

    public Predicate le(Expression<? extends Number> expression, Number number) {
        return this.le(expression, this.literal(number));
    }

    public <Y extends Comparable<? super Y>> Predicate between(Expression<? extends Y> expression, Expression<? extends Y> expression2, Expression<? extends Y> expression3) {
        return Expressions.predicate(expression, " BETWEEN ", expression2, " AND ", expression3);
    }

    public <Y extends Comparable<? super Y>> Predicate between(Expression<? extends Y> expression, Y y, Y y2) {
        return this.between(expression, (Y)this.literal(y), (Y)this.literal(y2));
    }

    public Predicate isFalse(Expression<Boolean> expression) {
        return this.isTrue(expression).not();
    }

    public Predicate isTrue(Expression<Boolean> expression) {
        return Expressions.predicate(expression);
    }

    public Predicate isNull(Expression<?> expression) {
        return Expressions.predicate(expression, " IS NULL");
    }

    public Predicate isNotNull(Expression<?> expression) {
        return Expressions.predicate(expression, " IS NOT NULL");
    }

    public Predicate and(Expression<Boolean> expression, Expression<Boolean> expression2) {
        return new Expressions.LogPredicateImpl(Predicate.BooleanOperator.AND, expression, expression2);
    }

    public Predicate and(Predicate ... predicateArray) {
        if (predicateArray == null || predicateArray.length == 0) {
            return this.conjunction();
        }
        return new Expressions.LogPredicateImpl(Predicate.BooleanOperator.AND, (Expression<Boolean>[])predicateArray);
    }

    public Predicate conjunction() {
        return Expressions.predicate(Expressions.literal(Boolean.TRUE));
    }

    public Predicate or(Expression<Boolean> expression, Expression<Boolean> expression2) {
        return new Expressions.LogPredicateImpl(Predicate.BooleanOperator.OR, expression, expression2);
    }

    public Predicate or(Predicate ... predicateArray) {
        if (predicateArray == null || predicateArray.length == 0) {
            return this.disjunction();
        }
        return new Expressions.LogPredicateImpl(Predicate.BooleanOperator.OR, (Expression<Boolean>[])predicateArray);
    }

    public Predicate disjunction() {
        return Expressions.predicate(Expressions.literal(Boolean.FALSE));
    }

    public Predicate not(Expression<Boolean> expression) {
        return Expressions.predicate(expression).not();
    }

    public <N extends Number> Expression<N> sum(Expression<? extends N> expression, Expression<? extends N> expression2) {
        return Expressions.expression(Number.class, expression, "+", expression2);
    }

    public <N extends Number> Expression<N> sum(Expression<? extends N> expression, N n2) {
        return this.sum((N)expression, (Expression<? extends N>)this.literal(n2));
    }

    public <N extends Number> Expression<N> sum(N n2, Expression<? extends N> expression) {
        return this.sum((N)this.literal(n2), expression);
    }

    public <N extends Number> Expression<N> diff(Expression<? extends N> expression, Expression<? extends N> expression2) {
        return Expressions.expression(Number.class, expression, "-", expression2);
    }

    public <N extends Number> Expression<N> diff(Expression<? extends N> expression, N n2) {
        return this.diff((N)expression, (Expression<? extends N>)this.literal(n2));
    }

    public <N extends Number> Expression<N> diff(N n2, Expression<? extends N> expression) {
        return this.diff((N)this.literal(n2), expression);
    }

    public <N extends Number> Expression<N> prod(Expression<? extends N> expression, Expression<? extends N> expression2) {
        return Expressions.expression(Number.class, expression, "*", expression2);
    }

    public <N extends Number> Expression<N> prod(Expression<? extends N> expression, N n2) {
        return this.prod((N)expression, (Expression<? extends N>)this.literal(n2));
    }

    public <N extends Number> Expression<N> prod(N n2, Expression<? extends N> expression) {
        return this.prod((N)this.literal(n2), expression);
    }

    public Expression<Number> quot(Expression<? extends Number> expression, Expression<? extends Number> expression2) {
        return Expressions.expression(Number.class, expression, "/", expression2);
    }

    public Expression<Number> quot(Expression<? extends Number> expression, Number number) {
        return this.quot(expression, this.literal(number));
    }

    public Expression<Number> quot(Number number, Expression<? extends Number> expression) {
        return this.quot(this.literal(number), expression);
    }

    public Expression<Integer> mod(Expression<Integer> expression, Expression<Integer> expression2) {
        return Expressions.function(Integer.class, "MOD", expression, expression2);
    }

    public Expression<Integer> mod(Expression<Integer> expression, Integer n2) {
        return this.mod(expression, this.literal(n2));
    }

    public Expression<Integer> mod(Integer n2, Expression<Integer> expression) {
        return this.mod(this.literal(n2), expression);
    }

    public <N extends Number> Expression<N> neg(Expression<N> expression) {
        return Expressions.expression(expression.getClass(), "-", expression);
    }

    public <N extends Number> Expression<N> abs(Expression<N> expression) {
        return Expressions.function(expression.getClass(), "ABS", expression);
    }

    public Expression<Double> sqrt(Expression<? extends Number> expression) {
        return Expressions.function(Double.class, "SQRT", expression);
    }

    public Expression<Long> count(Expression<?> expression) {
        return Expressions.function(Long.class, "COUNT", expression);
    }

    public Expression<Long> countDistinct(Expression<?> expression) {
        return Expressions.expression(Long.class, "COUNT(DISTINCT ", expression, ")");
    }

    public <N extends Number> Expression<N> sum(Expression<N> expression) {
        return Expressions.function(expression.getClass(), "SUM", expression);
    }

    public Expression<Double> sumAsDouble(Expression<Float> expression) {
        return Expressions.function(Double.class, "SUM", expression);
    }

    public Expression<Long> sumAsLong(Expression<Integer> expression) {
        return Expressions.function(Long.class, "SUM", expression);
    }

    public <N extends Number> Expression<Double> avg(Expression<N> expression) {
        return Expressions.function(Double.class, "AVG", expression);
    }

    public <N extends Number> Expression<N> max(Expression<N> expression) {
        return Expressions.function(expression.getClass(), "MAX", expression);
    }

    public <X extends Comparable<? super X>> Expression<X> greatest(Expression<X> expression) {
        return Expressions.function(expression.getClass(), "MAX", expression);
    }

    public <N extends Number> Expression<N> min(Expression<N> expression) {
        return Expressions.function(expression.getClass(), "MIN", expression);
    }

    public <X extends Comparable<? super X>> Expression<X> least(Expression<X> expression) {
        return Expressions.function(expression.getClass(), "MIN", expression);
    }

    public Expression<String> concat(Expression<String> expression, Expression<String> expression2) {
        return Expressions.function(String.class, "CONCAT", expression, expression2);
    }

    public Expression<String> concat(Expression<String> expression, String string) {
        return this.concat(expression, this.literal(string));
    }

    public Expression<String> concat(String string, Expression<String> expression) {
        return this.concat(this.literal(string), expression);
    }

    public Expression<Integer> length(Expression<String> expression) {
        return Expressions.function(Integer.class, "LENGTH", expression);
    }

    public Predicate like(Expression<String> expression, Expression<String> expression2) {
        return Expressions.predicate(expression, " LIKE ", expression2);
    }

    public Predicate like(Expression<String> expression, String string) {
        return this.like(expression, this.literal(string));
    }

    public Predicate like(Expression<String> expression, Expression<String> expression2, Expression<Character> expression3) {
        return Expressions.predicate(expression, " LIKE ", expression2, " ESCAPE ", expression3);
    }

    public Predicate like(Expression<String> expression, Expression<String> expression2, char c2) {
        return this.like(expression, expression2, this.literal(Character.valueOf(c2)));
    }

    public Predicate like(Expression<String> expression, String string, Expression<Character> expression2) {
        return this.like(expression, this.literal(string), expression2);
    }

    public Predicate like(Expression<String> expression, String string, char c2) {
        return this.like(expression, string, this.literal(Character.valueOf(c2)));
    }

    public Predicate notLike(Expression<String> expression, Expression<String> expression2) {
        return Expressions.predicate(expression, " NOT LIKE ", expression2);
    }

    public Predicate notLike(Expression<String> expression, String string) {
        return this.notLike(expression, this.literal(string));
    }

    public Predicate notLike(Expression<String> expression, Expression<String> expression2, Expression<Character> expression3) {
        return Expressions.predicate(expression, " NOT LIKE ", expression2, " ESCAPE ", expression3);
    }

    public Predicate notLike(Expression<String> expression, Expression<String> expression2, char c2) {
        return this.notLike(expression, expression2, this.literal(Character.valueOf(c2)));
    }

    public Predicate notLike(Expression<String> expression, String string, Expression<Character> expression2) {
        return this.notLike(expression, this.literal(string), expression2);
    }

    public Predicate notLike(Expression<String> expression, String string, char c2) {
        return this.notLike(expression, string, this.literal(Character.valueOf(c2)));
    }

    public Expression<Integer> locate(Expression<String> expression, Expression<String> expression2) {
        return Expressions.function(Integer.class, "LOCATE", expression, expression2);
    }

    public Expression<Integer> locate(Expression<String> expression, String string) {
        return this.locate(expression, this.literal(string));
    }

    public Expression<Integer> locate(Expression<String> expression, Expression<String> expression2, Expression<Integer> expression3) {
        return Expressions.function(Integer.class, "LOCATE", expression, expression2, expression3);
    }

    public Expression<Integer> locate(Expression<String> expression, String string, int n2) {
        return this.locate(expression, this.literal(string), this.literal(n2));
    }

    public Expression<String> lower(Expression<String> expression) {
        return Expressions.function(String.class, "LOWER", expression);
    }

    public Expression<String> substring(Expression<String> expression, Expression<Integer> expression2) {
        return Expressions.function(String.class, "SUBSTRING", expression, expression2);
    }

    public Expression<String> substring(Expression<String> expression, int n2) {
        return this.substring(expression, this.literal(n2));
    }

    public Expression<String> substring(Expression<String> expression, Expression<Integer> expression2, Expression<Integer> expression3) {
        return Expressions.function(String.class, "SUBSTRING", expression, expression2, expression3);
    }

    public Expression<String> substring(Expression<String> expression, int n2, int n3) {
        return this.substring(expression, this.literal(n2), this.literal(n3));
    }

    public Expression<String> trim(Expression<String> expression) {
        return Expressions.function(String.class, "TRIM", expression);
    }

    public Expression<String> trim(Expression<Character> expression, Expression<String> expression2) {
        return Expressions.expression(String.class, "TRIM(", expression, " FROM ", expression2, ")");
    }

    public Expression<String> trim(char c2, Expression<String> expression) {
        return this.trim(this.literal(Character.valueOf(c2)), expression);
    }

    public Expression<String> trim(CriteriaBuilder.Trimspec trimspec, Expression<String> expression) {
        return Expressions.expression(String.class, "TRIM(", trimspec, " FROM ", expression, ")");
    }

    public Expression<String> trim(CriteriaBuilder.Trimspec trimspec, Expression<Character> expression, Expression<String> expression2) {
        return Expressions.expression(String.class, "TRIM(", trimspec, " ", expression, " FROM ", expression2, ")");
    }

    public Expression<String> trim(CriteriaBuilder.Trimspec trimspec, char c2, Expression<String> expression) {
        return this.trim(trimspec, this.literal(Character.valueOf(c2)), expression);
    }

    public Expression<String> upper(Expression<String> expression) {
        return Expressions.function(String.class, "UPPER", expression);
    }

    public Expression<Date> currentDate() {
        return Expressions.expression(Date.class, "CURRENT_DATE");
    }

    public Expression<Time> currentTime() {
        return Expressions.expression(Time.class, "CURRENT_TIME");
    }

    public Expression<Timestamp> currentTimestamp() {
        return Expressions.expression(Timestamp.class, "CURRENT_TIMESTAMP");
    }

    public <C extends Collection<?>> Predicate isEmpty(Expression<C> expression) {
        if (expression instanceof Expressions.LiteralImpl) {
            return Expressions.predicate(this.literal(((Expressions.LiteralImpl)expression).isEmpty()));
        }
        return Expressions.predicate(expression, " IS EMPTY");
    }

    public <C extends Collection<?>> Predicate isNotEmpty(Expression<C> expression) {
        if (expression instanceof Expressions.LiteralImpl) {
            return Expressions.predicate(this.literal(!((Expressions.LiteralImpl)expression).isEmpty()));
        }
        return Expressions.predicate(expression, " IS NOT EMPTY");
    }

    public <E, C extends Collection<E>> Predicate isMember(Expression<E> expression, Expression<C> expression2) {
        return Expressions.predicate(expression, " MEMBER OF ", expression2);
    }

    public <E, C extends Collection<E>> Predicate isMember(E e2, Expression<C> expression) {
        if (expression instanceof Expressions.LiteralImpl) {
            return Expressions.predicate(this.literal(((Expressions.LiteralImpl)expression).contains(e2)));
        }
        return this.isMember((E)this.literal(e2), expression);
    }

    public <E, C extends Collection<E>> Predicate isNotMember(Expression<E> expression, Expression<C> expression2) {
        return Expressions.predicate(expression, " NOT MEMBER OF ", expression2);
    }

    public <E, C extends Collection<E>> Predicate isNotMember(E e2, Expression<C> expression) {
        if (expression instanceof Expressions.LiteralImpl) {
            return Expressions.predicate(this.literal(!((Expressions.LiteralImpl)expression).contains(e2)));
        }
        return this.isNotMember((E)this.literal(e2), expression);
    }

    public <C extends Collection<?>> Expression<Integer> size(C c2) {
        return this.literal(c2.size());
    }

    public <C extends Collection<?>> Expression<Integer> size(Expression<C> expression) {
        if (expression instanceof Expressions.LiteralImpl) {
            return this.literal(((Expressions.LiteralImpl)expression).size());
        }
        return Expressions.function(Integer.class, "SIZE", expression);
    }

    public <K, M extends Map<K, ?>> Expression<Set<K>> keys(M m) {
        return this.literal(m.keySet());
    }

    public <V, M extends Map<?, V>> Expression<Collection<V>> values(M m) {
        return this.literal(m.values());
    }

    public <T> CriteriaBuilder.In<T> in(Expression<? extends T> expression) {
        return new Expressions.InPredicateImpl<T>(expression);
    }

    public Predicate exists(Subquery<?> subquery) {
        return Expressions.predicate("EXISTS(", subquery, ")");
    }

    public <Y> Expression<Y> all(Subquery<Y> subquery) {
        return Expressions.function(subquery.getResultType(), "ALL", subquery);
    }

    public <Y> Expression<Y> any(Subquery<Y> subquery) {
        return Expressions.function(subquery.getResultType(), "ANY", subquery);
    }

    public <Y> Expression<Y> some(Subquery<Y> subquery) {
        return Expressions.function(subquery.getResultType(), "SOME", subquery);
    }

    public <R> CriteriaBuilder.Case<R> selectCase() {
        return new Expressions.CaseImpl<Object>(Object.class);
    }

    public <C, R> CriteriaBuilder.SimpleCase<C, R> selectCase(Expression<? extends C> expression) {
        return new Expressions.SimpleCaseImpl<C, Object>(Object.class, expression);
    }

    public <T> CriteriaBuilder.Coalesce<T> coalesce() {
        return new Expressions.CoalesceImpl<Object>(Object.class);
    }

    public <Y> Expression<Y> coalesce(Expression<? extends Y> expression, Expression<? extends Y> expression2) {
        return Expressions.function(Object.class, "COALESCE", expression, expression2);
    }

    public <Y> Expression<Y> coalesce(Expression<? extends Y> expression, Y y) {
        return this.coalesce(expression, (Y)this.literal(y));
    }

    public <Y> Expression<Y> nullif(Expression<Y> expression, Expression<?> expression2) {
        return Expressions.function(Object.class, "NULLIF", expression, expression2);
    }

    public <Y> Expression<Y> nullif(Expression<Y> expression, Y y) {
        return this.nullif(expression, (Y)this.literal(y));
    }

    public <T> Expression<T> function(String string, Class<T> clazz, Expression<?> ... expressionArray) {
        return Expressions.function(clazz, string, expressionArray);
    }

    public Expression<Integer> toInteger(Expression<? extends Number> expression) {
        return Expressions.expression(Integer.class, expression);
    }

    public Expression<Long> toLong(Expression<? extends Number> expression) {
        return Expressions.expression(Long.class, expression);
    }

    public Expression<Float> toFloat(Expression<? extends Number> expression) {
        return Expressions.expression(Float.class, expression);
    }

    public Expression<Double> toDouble(Expression<? extends Number> expression) {
        return Expressions.expression(Double.class, expression);
    }

    public Expression<BigInteger> toBigInteger(Expression<? extends Number> expression) {
        return Expressions.expression(BigInteger.class, expression);
    }

    public Expression<BigDecimal> toBigDecimal(Expression<? extends Number> expression) {
        return Expressions.expression(BigDecimal.class, expression);
    }

    public Expression<String> toString(Expression<Character> expression) {
        return Expressions.expression(String.class, expression);
    }

    public <T> CriteriaUpdate<T> createCriteriaUpdate(Class<T> clazz) {
        throw new UnsupportedOperationException();
    }

    public <T> CriteriaDelete<T> createCriteriaDelete(Class<T> clazz) {
        throw new UnsupportedOperationException();
    }

    public <X, T, V extends T> Join<X, V> treat(Join<X, T> join, Class<V> clazz) {
        throw new UnsupportedOperationException();
    }

    public <X, T, E extends T> CollectionJoin<X, E> treat(CollectionJoin<X, T> collectionJoin, Class<E> clazz) {
        throw new UnsupportedOperationException();
    }

    public <X, T, E extends T> SetJoin<X, E> treat(SetJoin<X, T> setJoin, Class<E> clazz) {
        throw new UnsupportedOperationException();
    }

    public <X, T, E extends T> ListJoin<X, E> treat(ListJoin<X, T> listJoin, Class<E> clazz) {
        throw new UnsupportedOperationException();
    }

    public <X, K, T, V extends T> MapJoin<X, K, V> treat(MapJoin<X, K, T> mapJoin, Class<V> clazz) {
        throw new UnsupportedOperationException();
    }

    public <X, T extends X> Path<T> treat(Path<X> path, Class<T> clazz) {
        throw new UnsupportedOperationException();
    }

    public <X, T extends X> Root<T> treat(Root<X> root, Class<T> clazz) {
        throw new UnsupportedOperationException();
    }
}

